/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.pumpjack.PumpjackHandler;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ReservoirTypeSerializer
extends IERecipeSerializer<PumpjackHandler.ReservoirType> {
    public PumpjackHandler.ReservoirType readFromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray array;
        ArrayList<ResourceLocation> blacklist;
        ArrayList<ResourceLocation> whitelist;
        String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
        ResourceLocation fluid = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
        int min = JSONUtils.func_151203_m((JsonObject)json, (String)"fluidminimum");
        int max = JSONUtils.func_151203_m((JsonObject)json, (String)"fluidcapacity");
        int trace = JSONUtils.func_151203_m((JsonObject)json, (String)"fluidtrace");
        int weight = JSONUtils.func_151203_m((JsonObject)json, (String)"weight");
        PumpjackHandler.ReservoirType type = new PumpjackHandler.ReservoirType(name, recipeId, fluid, min, max, trace, weight);
        ImmersivePetroleum.log.debug(String.format("Loaded reservoir %s as %s, with %smB to %smB of %s and %smB trace, with %s of weight.", recipeId, name, min, max, fluid, trace, weight));
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"dimension")) {
            JsonObject dimension = JSONUtils.func_152754_s((JsonObject)json, (String)"dimension");
            whitelist = new ArrayList<ResourceLocation>();
            blacklist = new ArrayList<ResourceLocation>();
            if (JSONUtils.func_151204_g((JsonObject)dimension, (String)"whitelist")) {
                array = JSONUtils.func_151214_t((JsonObject)dimension, (String)"whitelist");
                for (JsonElement obj : array) {
                    whitelist.add(new ResourceLocation(obj.getAsString()));
                }
            }
            if (JSONUtils.func_151204_g((JsonObject)dimension, (String)"blacklist")) {
                array = JSONUtils.func_151214_t((JsonObject)dimension, (String)"blacklist");
                for (JsonElement obj : array) {
                    blacklist.add(new ResourceLocation(obj.getAsString()));
                }
            }
            if (whitelist.size() > 0) {
                ImmersivePetroleum.log.debug("- Adding these to dimension-whitelist for {} -", (Object)name);
                whitelist.forEach(ins -> ImmersivePetroleum.log.debug(ins));
                type.addDimension(false, whitelist);
            } else if (blacklist.size() > 0) {
                ImmersivePetroleum.log.debug("- Adding these to dimension-blacklist for {} -", (Object)name);
                blacklist.forEach(ins -> ImmersivePetroleum.log.debug(ins));
                type.addDimension(true, blacklist);
            }
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"biome")) {
            JsonObject biome = JSONUtils.func_152754_s((JsonObject)json, (String)"biome");
            whitelist = new ArrayList();
            blacklist = new ArrayList();
            if (JSONUtils.func_151204_g((JsonObject)biome, (String)"whitelist")) {
                array = JSONUtils.func_151214_t((JsonObject)biome, (String)"whitelist");
                for (JsonElement obj : array) {
                    whitelist.add(new ResourceLocation(obj.getAsString()));
                }
            }
            if (JSONUtils.func_151204_g((JsonObject)biome, (String)"blacklist")) {
                array = JSONUtils.func_151214_t((JsonObject)biome, (String)"blacklist");
                for (JsonElement obj : array) {
                    blacklist.add(new ResourceLocation(obj.getAsString()));
                }
            }
            if (whitelist.size() > 0) {
                ImmersivePetroleum.log.debug("- Adding these to biome-whitelist for {} -", (Object)name);
                whitelist.forEach(ins -> ImmersivePetroleum.log.debug(ins));
                type.addBiome(false, whitelist);
            } else if (blacklist.size() > 0) {
                ImmersivePetroleum.log.debug("- Adding these to biome-blacklist for {} -", (Object)name);
                blacklist.forEach(ins -> ImmersivePetroleum.log.debug(ins));
                type.addBiome(true, blacklist);
            }
        }
        return type;
    }

    public PumpjackHandler.ReservoirType read(ResourceLocation recipeId, PacketBuffer buffer) {
        return new PumpjackHandler.ReservoirType(buffer.func_150793_b());
    }

    public void write(PacketBuffer buffer, PumpjackHandler.ReservoirType recipe) {
        buffer.func_150786_a(recipe.writeToNBT());
    }

    public ItemStack getIcon() {
        return ItemStack.field_190927_a;
    }
}

