/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ComparableItemStack {
    public ItemStack stack;
    public boolean useNBT;

    public ComparableItemStack(ItemStack stack) {
        this(stack, false);
    }

    public ComparableItemStack(ItemStack stack, boolean copy) {
        if (stack == null) {
            throw new RuntimeException("You cannot instantiate a ComparableItemStack with null for an Item!");
        }
        this.stack = stack;
        if (copy) {
            this.copy();
        }
    }

    public static ComparableItemStack create(ItemStack stack, boolean copy) {
        return ComparableItemStack.create(stack, copy, stack.func_77942_o() && !stack.func_196082_o().isEmpty());
    }

    public static ComparableItemStack create(ItemStack stack, boolean copy, boolean useNbt) {
        ComparableItemStack comp = new ComparableItemStack(stack, copy);
        comp.setUseNBT(useNbt);
        return comp;
    }

    public void copy() {
        this.stack = this.stack.func_77946_l();
    }

    public ComparableItemStack setUseNBT(boolean useNBT) {
        this.useNBT = useNBT;
        return this;
    }

    public String toString() {
        return "ComparableStack: {" + this.stack.toString() + "}; checkNBT: " + this.useNBT;
    }

    public int hashCode() {
        int hash = this.stack.func_77973_b().hashCode();
        if (this.useNBT && this.stack.func_77942_o()) {
            hash += this.stack.func_196082_o().hashCode() * 31;
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparableItemStack)) {
            return false;
        }
        ItemStack otherStack = ((ComparableItemStack)object).stack;
        if (!ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)otherStack)) {
            return false;
        }
        if (this.useNBT) {
            return ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)otherStack);
        }
        return true;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_218657_a("stack", (INBT)this.stack.func_77955_b(new CompoundNBT()));
        nbt.func_74757_a("useNBT", this.useNBT);
        return nbt;
    }

    public static ComparableItemStack readFromNBT(CompoundNBT nbt) {
        ComparableItemStack comp = new ComparableItemStack(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("stack")), false);
        comp.useNBT = nbt.func_74767_n("useNBT");
        return comp;
    }
}

