/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class DimensionChunkCoords
extends ChunkPos {
    public RegistryKey<World> dimension;

    public DimensionChunkCoords(RegistryKey<World> dimension, int x, int z) {
        super(x, z);
        this.dimension = dimension;
    }

    public DimensionChunkCoords(RegistryKey<World> dimension, ChunkPos pos) {
        this(dimension, pos.field_77276_a, pos.field_77275_b);
    }

    public DimensionChunkCoords(World world, int chunkX, int chunkZ) {
        this((RegistryKey<World>)world.func_234923_W_(), chunkX, chunkZ);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DimensionChunkCoords)) {
            return false;
        }
        DimensionChunkCoords coordPair = (DimensionChunkCoords)((Object)o);
        return this.dimension == coordPair.dimension && this.field_77276_a == coordPair.field_77276_a && this.field_77275_b == coordPair.field_77275_b;
    }

    public String toString() {
        return "[dim:" + this.dimension + "; " + this.field_77276_a + ", " + this.field_77275_b + "]";
    }

    public DimensionChunkCoords withOffset(int offsetX, int offsetZ) {
        return new DimensionChunkCoords(this.dimension, this.field_77276_a + offsetX, this.field_77275_b + offsetZ);
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("dim", this.dimension.func_240901_a_().toString());
        tag.func_74768_a("x", this.field_77276_a);
        tag.func_74768_a("z", this.field_77275_b);
        return tag;
    }

    @Nullable
    public static DimensionChunkCoords readFromNBT(CompoundNBT tag) {
        if (tag.func_150297_b("dim", 8) && tag.func_150297_b("x", 3) && tag.func_150297_b("z", 3)) {
            String dimNameStr = tag.func_74779_i("dim");
            ResourceLocation dimName = new ResourceLocation(dimNameStr);
            RegistryKey dimType = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimName);
            return new DimensionChunkCoords((RegistryKey<World>)dimType, tag.func_74762_e("x"), tag.func_74762_e("z"));
        }
        return null;
    }
}

