/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.INoiseGenerator;
import org.apache.commons.lang3.tuple.Pair;

public class ExcavatorHandler {
    private static final Multimap<RegistryKey<World>, MineralVein> MINERAL_VEIN_LIST = ArrayListMultimap.create();
    private static final Map<Pair<RegistryKey<World>, ColumnPos>, MineralWorldInfo> MINERAL_INFO_CACHE = new HashMap<Pair<RegistryKey<World>, ColumnPos>, MineralWorldInfo>();
    static final SetRestrictedField<Runnable> MARK_SAVE_DATA_DIRTY = SetRestrictedField.common();
    public static int mineralVeinYield = 0;
    public static double initialVeinDepletion = 0.0;
    public static double mineralNoiseThreshold = 0.0;
    public static INoiseGenerator noiseGenerator;

    @Nullable
    public static MineralVein getRandomMineral(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return null;
        }
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(world, pos);
        return info.getMineralVein(ApiUtils.RANDOM);
    }

    public static Multimap<RegistryKey<World>, MineralVein> getMineralVeinList() {
        return MINERAL_VEIN_LIST;
    }

    public static MineralWorldInfo getMineralWorldInfo(World world, BlockPos pos) {
        return ExcavatorHandler.getMineralWorldInfo(world, new ColumnPos(pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MineralWorldInfo getMineralWorldInfo(World world, ColumnPos columnPos) {
        if (world.field_72995_K) {
            return null;
        }
        RegistryKey dimension = world.func_234923_W_();
        Pair cacheKey = Pair.of((Object)dimension, (Object)columnPos);
        Multimap<RegistryKey<World>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            MineralWorldInfo worldInfo = MINERAL_INFO_CACHE.get(cacheKey);
            if (worldInfo == null) {
                ArrayList<Pair> inVeins = new ArrayList<Pair>();
                double totalSaturation = 0.0;
                Iterator iterator = MINERAL_VEIN_LIST.get((Object)dimension).iterator();
                while (iterator.hasNext()) {
                    MineralVein vein;
                    long dX = vein.getPos().field_219439_a - columnPos.field_219439_a;
                    long dZ = vein.getPos().field_219440_b - columnPos.field_219440_b;
                    long d = dX * dX + dZ * dZ;
                    vein = (MineralVein)iterator.next();
                    double rSq = vein.getRadius() * vein.getRadius();
                    if (!((double)d < rSq)) continue;
                    double saturation = 1.0 - (double)d / rSq;
                    inVeins.add(Pair.of((Object)vein, (Object)saturation));
                    totalSaturation += saturation;
                }
                double finalTotalSaturation = totalSaturation;
                worldInfo = new MineralWorldInfo(inVeins.stream().map(pair -> Pair.of((Object)pair.getLeft(), (Object)((int)((Double)pair.getRight() / finalTotalSaturation * 1000.0)))).filter(p -> ((MineralVein)p.getLeft()).getMineral() != null).collect(Collectors.toList()));
                MINERAL_INFO_CACHE.put((Pair<RegistryKey<World>, ColumnPos>)cacheKey, worldInfo);
            }
            return worldInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePotentialVein(World world, ChunkPos chunkpos, Random rand) {
        int xStart = chunkpos.func_180334_c();
        int zStart = chunkpos.func_180333_d();
        double d0 = 0.0625;
        ColumnPos pos = null;
        double maxNoise = 0.0;
        for (int xx = 0; xx < 16; ++xx) {
            for (int zz = 0; zz < 16; ++zz) {
                double noise = noiseGenerator.func_215460_a((double)(xStart + xx) * d0, (double)(zStart + zz) * d0, d0, (double)xx * d0);
                double chance = Math.abs(noise) / 0.55;
                if (!(chance > mineralNoiseThreshold) || !(chance > maxNoise)) continue;
                pos = new ColumnPos(xStart + xx, zStart + zz);
                maxNoise = chance;
            }
        }
        if (pos != null) {
            Multimap<RegistryKey<World>, MineralVein> multimap = MINERAL_VEIN_LIST;
            synchronized (multimap) {
                ColumnPos finalPos = pos;
                int radius = 12 + rand.nextInt(32);
                int radiusSq = radius * radius;
                boolean crossover = MINERAL_VEIN_LIST.get((Object)world.func_234923_W_()).stream().anyMatch(vein -> {
                    long dX = vein.getPos().field_219439_a - finalPos.field_219439_a;
                    long dZ = vein.getPos().field_219440_b - finalPos.field_219440_b;
                    long dSq = dX * dX + dZ * dZ;
                    return dSq < (long)(vein.getRadius() * vein.getRadius()) || dSq < (long)radiusSq;
                });
                if (!crossover) {
                    IESerializableRecipe mineralMix = null;
                    MineralSelection selection = new MineralSelection((RegistryKey<World>)world.func_234923_W_());
                    if (selection.getTotalWeight() > 0) {
                        int weight = selection.getRandomWeight(rand);
                        for (MineralMix e : selection.getMinerals()) {
                            if ((weight -= e.weight) >= 0) continue;
                            mineralMix = e;
                            break;
                        }
                    }
                    if (mineralMix != null) {
                        MineralVein vein2 = new MineralVein(pos, mineralMix.func_199560_c(), radius);
                        if (initialVeinDepletion > 0.0) {
                            vein2.setDepletion((int)((double)mineralVeinYield * (rand.nextDouble() * initialVeinDepletion)));
                        }
                        ExcavatorHandler.addVein((RegistryKey<World>)world.func_234923_W_(), vein2);
                        MARK_SAVE_DATA_DIRTY.getValue().run();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVein(RegistryKey<World> dimension, MineralVein vein) {
        Multimap<RegistryKey<World>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            MINERAL_VEIN_LIST.put(dimension, (Object)vein);
            ExcavatorHandler.resetCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        Multimap<RegistryKey<World>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            MINERAL_INFO_CACHE.clear();
        }
    }

    public static void setSetDirtyCallback(Runnable setDirty) {
        MARK_SAVE_DATA_DIRTY.setValue(setDirty);
    }

    public static class MineralSelection {
        private final int totalWeight;
        private final Set<MineralMix> validMinerals;

        public MineralSelection(RegistryKey<World> dimension) {
            int weight = 0;
            this.validMinerals = new HashSet<MineralMix>();
            for (MineralMix e : MineralMix.mineralList.values()) {
                if (!e.validDimension(dimension)) continue;
                this.validMinerals.add(e);
                weight += e.weight;
            }
            this.totalWeight = weight;
        }

        public int getTotalWeight() {
            return this.totalWeight;
        }

        public int getRandomWeight(Random random) {
            return random.nextInt(this.totalWeight);
        }

        public Set<MineralMix> getMinerals() {
            return this.validMinerals;
        }
    }
}

