/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonLogicCircuitRegister;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.client.gui.elements.GuiSelectingList;
import blusunrize.immersiveengineering.common.blocks.wooden.CircuitTableTileEntity;
import blusunrize.immersiveengineering.common.gui.CircuitTableContainer;
import blusunrize.immersiveengineering.common.items.LogicCircuitBoardItem;
import blusunrize.immersiveengineering.common.network.MessageContainerUpdate;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class CircuitTableScreen
extends IEContainerScreen<CircuitTableContainer> {
    private static final ResourceLocation TEXTURE = IEContainerScreen.makeTextureLocation("circuit_table");
    private final CircuitTableTileEntity tile;
    private GuiSelectingList operatorList;
    private final List<GuiButtonState<LogicCircuitHandler.LogicCircuitRegister>> inputButtons = new ArrayList<GuiButtonState<LogicCircuitHandler.LogicCircuitRegister>>(LogicCircuitHandler.LogicCircuitOperator.TOTAL_MAX_INPUTS);
    private GuiButtonState<LogicCircuitHandler.LogicCircuitRegister> outputButton;
    private final ResettableLazy<Optional<LogicCircuitHandler.LogicCircuitInstruction>> instruction = new ResettableLazy(() -> {
        LogicCircuitHandler.LogicCircuitOperator operator = this.getSelectedOperator();
        if (operator == null) {
            return Optional.empty();
        }
        LogicCircuitHandler.LogicCircuitRegister[] inputs = (LogicCircuitHandler.LogicCircuitRegister[])this.inputButtons.stream().map(GuiButtonState::getState).filter(Objects::nonNull).limit(operator.getArgumentCount()).toArray(LogicCircuitHandler.LogicCircuitRegister[]::new);
        if (inputs.length < operator.getArgumentCount()) {
            return Optional.empty();
        }
        return Optional.of(new LogicCircuitHandler.LogicCircuitInstruction(operator, this.outputButton.getState(), inputs));
    });

    public CircuitTableScreen(CircuitTableContainer container, PlayerInventory inventoryPlayer, ITextComponent title) {
        super(container, inventoryPlayer, title);
        this.tile = (CircuitTableTileEntity)container.tile;
        this.field_146999_f = 234;
        this.field_147000_g = 182;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        ClientUtils.mc().field_195559_v.func_197967_a(true);
        this.operatorList = (GuiSelectingList)this.func_230480_a_((Widget)new GuiSelectingList((Screen)this, this.field_147003_i + 58, this.field_147009_r + 16, 36, 56, btn -> {
            this.field_230706_i_.func_212871_a_(this::updateButtons);
            this.field_230706_i_.func_212871_a_(this::updateInstruction);
        }, (String[])Arrays.stream(LogicCircuitHandler.LogicCircuitOperator.values()).map(Enum::name).toArray(String[]::new)).setPadding(1, 1, 2, 0));
        this.outputButton = (GuiButtonState)this.func_230480_a_((Widget)new GuiButtonLogicCircuitRegister(this.field_147003_i + 121, this.field_147009_r + 56, (ITextComponent)new StringTextComponent("Output"), btn -> this.field_230706_i_.func_212871_a_(this::updateInstruction)));
        this.updateButtons();
    }

    @Nullable
    private LogicCircuitHandler.LogicCircuitOperator getSelectedOperator() {
        return LogicCircuitHandler.LogicCircuitOperator.getByString(this.operatorList.getSelectedString());
    }

    private void updateInstruction() {
        this.instruction.reset();
        this.instruction.get().ifPresent(instr -> {
            ((CircuitTableContainer)this.field_147002_h).instruction = instr;
            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageContainerUpdate(((CircuitTableContainer)this.field_147002_h).field_75152_c, instr.serialize()));
        });
    }

    private void updateButtons() {
        block5: {
            LogicCircuitHandler.LogicCircuitOperator operator = this.getSelectedOperator();
            if (operator == null) break block5;
            int inputCount = operator.getArgumentCount();
            int inputStart = 130 - (inputCount * 10 - 1);
            if (inputCount < this.inputButtons.size()) {
                Iterator<GuiButtonState<LogicCircuitHandler.LogicCircuitRegister>> it = this.inputButtons.iterator();
                int i = 0;
                while (it.hasNext()) {
                    GuiButtonState<LogicCircuitHandler.LogicCircuitRegister> btn2 = it.next();
                    btn2.field_230690_l_ = this.field_147003_i + inputStart + 20 * i;
                    if (++i <= inputCount) continue;
                    this.field_230710_m_.remove(btn2);
                    this.field_230705_e_.remove(btn2);
                    it.remove();
                }
            } else {
                for (int i = 0; i < inputCount; ++i) {
                    if (i < this.inputButtons.size()) {
                        this.inputButtons.get((int)i).field_230690_l_ = this.field_147003_i + inputStart + 20 * i;
                        continue;
                    }
                    this.inputButtons.add((GuiButtonState<LogicCircuitHandler.LogicCircuitRegister>)this.func_230480_a_((Widget)new GuiButtonLogicCircuitRegister(this.field_147003_i + inputStart + 20 * i, this.field_147009_r + 18, (ITextComponent)new StringTextComponent("Input " + (i + 1)), btn -> this.field_230706_i_.func_212871_a_(this::updateInstruction))));
                }
            }
        }
    }

    @Override
    public void func_230430_a_(MatrixStack transform, int mx, int my, float partial) {
        super.func_230430_a_(transform, mx, my, partial);
        ArrayList<Object> tooltip = new ArrayList<Object>();
        if (this.field_147006_u != null && this.field_147006_u.field_75222_d < CircuitTableTileEntity.SLOT_TYPES.length && !this.field_147006_u.func_75216_d()) {
            int slotNum = this.field_147006_u.field_75222_d;
            tooltip.add(TextUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.circuit_table.slot." + CircuitTableTileEntity.SLOT_TYPES[slotNum]), TextFormatting.GRAY));
        }
        if (this.isMouseIn(mx, my, 217, 16, 7, 46)) {
            tooltip.add(new StringTextComponent(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " IF"));
        }
        if (this.isMouseIn(mx, my, 52, 7, 100, 70) && this.field_213127_e.func_70445_o().func_77973_b() instanceof LogicCircuitBoardItem) {
            tooltip.add(TextUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.circuit_table.copy"), TextFormatting.GRAY));
        }
        for (GuiButtonState<LogicCircuitHandler.LogicCircuitRegister> input : this.inputButtons) {
            if (!input.func_230449_g_()) continue;
            tooltip.add(TextUtils.applyFormat((ITextComponent)input.getState().getDescription(), TextFormatting.GRAY));
        }
        if (this.outputButton.func_230449_g_()) {
            tooltip.add(TextUtils.applyFormat((ITextComponent)this.outputButton.getState().getDescription(), TextFormatting.GRAY));
        }
        if (!tooltip.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)transform, tooltip, (int)mx, (int)my, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
    }

    protected void func_230451_b_(MatrixStack transform, int mouseX, int mouseY) {
        CircuitTableScreen.func_238471_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (String)"Operator:", (int)76, (int)4, (int)DyeColor.LIGHT_GRAY.getColorValue());
        CircuitTableScreen.func_238471_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (String)"Inputs:", (int)130, (int)8, (int)DyeColor.LIGHT_GRAY.getColorValue());
        CircuitTableScreen.func_238471_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (String)"Outputs:", (int)130, (int)42, (int)DyeColor.LIGHT_GRAY.getColorValue());
        for (int i = 0; i < CircuitTableTileEntity.SLOT_TYPES.length; ++i) {
            int amount = 0;
            DyeColor col = DyeColor.LIGHT_GRAY;
            if (this.instruction.get().isPresent()) {
                amount = CircuitTableTileEntity.getIngredientAmount(this.instruction.get().get(), i);
                col = ((Slot)((CircuitTableContainer)this.field_147002_h).field_75151_b.get(i)).func_75211_c().func_190916_E() >= amount ? DyeColor.GREEN : DyeColor.RED;
            }
            this.field_230712_o_.func_238421_b_(transform, "x " + amount, 30.0f, (float)(18 + 20 * i), col.getColorValue());
        }
    }

    protected void func_230450_a_(MatrixStack transform, float f, int mx, int my) {
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture(TEXTURE);
        this.func_238474_b_(transform, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        this.func_238468_a_(transform, this.field_147003_i + 217, this.field_147009_r + 16 + (46 - stored), this.field_147003_i + 224, this.field_147009_r + 62, -4909824, -10482944);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        for (GuiButtonState<LogicCircuitHandler.LogicCircuitRegister> input : this.inputButtons) {
            if (!input.func_230449_g_()) continue;
            return input.func_231042_a_(codePoint, modifiers);
        }
        if (this.outputButton.func_230449_g_()) {
            return this.outputButton.func_231042_a_(codePoint, modifiers);
        }
        return super.func_231042_a_(codePoint, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        LogicCircuitHandler.LogicCircuitInstruction instr;
        if (this.isMouseIn((int)mouseX, (int)mouseY, 52, 7, 100, 70) && this.field_213127_e.func_70445_o().func_77973_b() instanceof LogicCircuitBoardItem && (instr = LogicCircuitBoardItem.getInstruction(this.field_213127_e.func_70445_o())) != null) {
            this.operatorList.setSelectedString(instr.getOperator().name());
            this.updateButtons();
            this.outputButton.setStateByInt(instr.getOutput().ordinal());
            LogicCircuitHandler.LogicCircuitRegister[] inputs = instr.getInputs();
            for (int i = 0; i < inputs.length; ++i) {
                this.inputButtons.get(i).setStateByInt(inputs[i].ordinal());
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }
}

