/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.SorterScreen;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.blocks.wooden.FluidSorterTileEntity;
import blusunrize.immersiveengineering.common.gui.FluidSorterContainer;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class FluidSorterScreen
extends IEContainerScreen<FluidSorterContainer> {
    private static final ResourceLocation TEXTURE = FluidSorterScreen.makeTextureLocation("sorter");
    public final FluidSorterTileEntity tile;
    private final PlayerInventory playerInventory;

    public FluidSorterScreen(FluidSorterContainer container, PlayerInventory inventoryPlayer, ITextComponent title) {
        super(container, inventoryPlayer, title);
        this.tile = (FluidSorterTileEntity)container.tile;
        this.playerInventory = inventoryPlayer;
        this.field_147000_g = 244;
    }

    @Override
    public void func_230430_a_(MatrixStack transform, int mx, int my, float partial) {
        super.func_230430_a_(transform, mx, my, partial);
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        for (Widget button : this.field_230710_m_) {
            if (!(button instanceof SorterScreen.ButtonSorter) || mx <= button.field_230690_l_ || mx >= button.field_230690_l_ + 18 || my <= button.field_230691_m_ || my >= button.field_230691_m_ + 18) continue;
            String[] split = I18n.func_135052_a((String)"desc.immersiveengineering.info.filter.nbt", (Object[])new Object[0]).split("<br>");
            for (int i = 0; i < split.length; ++i) {
                StringTextComponent component = new StringTextComponent(split[i]);
                TextUtils.applyFormat((ITextComponent)component, i == 0 ? TextFormatting.WHITE : TextFormatting.GRAY);
                tooltip.add((ITextComponent)component);
            }
        }
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                if (this.tile.filters[side][i] == null || this.tile.filters[side][i].isEmpty()) continue;
                int x = this.field_147003_i + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
                int y = this.field_147009_r + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
                if (mx <= x || mx >= x + 16 || my <= y || my >= y + 16) continue;
                GuiHelper.addFluidTooltip(this.tile.filters[side][i], tooltip, 0);
            }
        }
        if (!tooltip.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)transform, tooltip, (int)mx, (int)my, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                int x = this.field_147003_i + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
                int y = this.field_147009_r + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
                if (!(mouseX > (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY > (double)y) || !(mouseY < (double)(y + 16))) continue;
                ItemStack stack = this.playerInventory.func_70445_o();
                if (stack.func_190926_b()) {
                    this.setFluidInSlot(side, i, FluidStack.EMPTY);
                } else {
                    int finalSide = side;
                    int finalI = i;
                    FluidUtil.getFluidContained((ItemStack)stack).ifPresent(fs -> this.setFluidInSlot(finalSide, finalI, (FluidStack)fs));
                }
                return true;
            }
        }
        return false;
    }

    protected void func_230450_a_(MatrixStack transform, float f, int mx, int my) {
        ClientUtils.bindTexture(TEXTURE);
        this.func_238474_b_(transform, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        IVertexBuilder builder = buffers.getBuffer(IERenderTypes.getGui(PlayerContainer.field_226615_c_));
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                TextureAtlasSprite sprite;
                if (this.tile.filters[side][i].isEmpty() || (sprite = ClientUtils.getSprite(this.tile.filters[side][i].getFluid().getAttributes().getStillTexture(this.tile.filters[side][i]))) == null) continue;
                int x = this.field_147003_i + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
                int y = this.field_147009_r + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
                int col = this.tile.filters[side][i].getFluid().getAttributes().getColor(this.tile.filters[side][i]);
                GuiHelper.drawTexturedColoredRect(builder, transform, x, y, 16.0f, 16.0f, (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 1.0f, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h());
            }
        }
        buffers.func_228461_a_();
        for (int side = 0; side < 6; ++side) {
            int x = this.field_147003_i + 30 + side / 2 * 58;
            int y = this.field_147009_r + 44 + side % 2 * 76;
            String s = I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide." + Direction.func_82600_a((int)side).toString()), (Object[])new Object[0]).substring(0, 1);
            ClientUtils.font().func_238405_a_(transform, s, (float)(x - ClientUtils.font().func_78256_a(s) / 2), (float)y, -1429418804);
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        for (int side = 0; side < 6; ++side) {
            int x = this.field_147003_i + 21 + side / 2 * 58;
            int y = this.field_147009_r + 3 + side % 2 * 76;
            int sideFinal = side;
            SorterScreen.ButtonSorter b = new SorterScreen.ButtonSorter(x, y, 1, btn -> {
                this.tile.sortWithNBT[sideFinal] = (byte)(this.tile.sortWithNBT[sideFinal] != 1 ? 1 : 0);
                CompoundNBT tag = new CompoundNBT();
                tag.func_74773_a("sideConfig", this.tile.sortWithNBT);
                ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageTileSync(this.tile, tag));
                this.fullInit();
            });
            b.field_230693_o_ = this.tile.doNBT(side);
            this.func_230480_a_((Widget)b);
        }
    }

    public void setFluidInSlot(int side, int slot, FluidStack fluid) {
        this.tile.filters[side][slot] = fluid;
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("filter_side", side);
        tag.func_74768_a("filter_slot", slot);
        if (fluid != null) {
            tag.func_218657_a("filter", (INBT)fluid.writeToNBT(new CompoundNBT()));
        }
        ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageTileSync(this.tile, tag));
    }
}

