/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipes;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MetalPressTileEntity
extends PoweredMultiblockTileEntity<MetalPressTileEntity, MetalPressRecipe>
implements IEBlockInterfaces.IPlayerInteraction,
ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds {
    public static final float TRANSLATION_DISTANCE = 2.5f;
    private static final float STANDARD_TRANSPORT_TIME = 20.0f;
    private static final float STANDARD_PRESS_TIME = 3.75f;
    private static final float MIN_CYCLE_TIME = 60.0f;
    public ItemStack mold = ItemStack.field_190927_a;
    private CapabilityReference<IItemHandler> outputCap = CapabilityReference.forTileEntityAt(this, this::getOutputPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new PoweredMultiblockTileEntity.MultiblockInventoryHandler_DirectProcessing(this));

    public MetalPressTileEntity() {
        super(IEMultiblocks.METAL_PRESS, 16000, true, (TileEntityType)IETileTypes.METAL_PRESS.get());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K) {
            return;
        }
        for (PoweredMultiblockTileEntity.MultiblockProcess process : this.processQueue) {
            float maxTicks = process.maxTicks;
            float transportTime = MetalPressTileEntity.getTransportTime(maxTicks);
            float pressTime = MetalPressTileEntity.getPressTime(maxTicks);
            float fProcess = process.processTick;
            if (fProcess >= transportTime && fProcess < transportTime + 1.0f) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.metalpress_piston, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
            if (fProcess >= transportTime + pressTime && fProcess < transportTime + pressTime + 1.0f) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.metalpress_smash, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
            if (!(fProcess >= maxTicks - transportTime) || !(fProcess < maxTicks - transportTime + 1.0f)) continue;
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.metalpress_piston, SoundCategory.BLOCKS, 0.3f, 1.0f);
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.mold = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("mold"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.mold.func_190926_b()) {
            nbt.func_218657_a("mold", (INBT)this.mold.func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        MetalPressTileEntity master = (MetalPressTileEntity)this.master();
        if (master != null) {
            if (player.func_225608_bj_() && !master.mold.func_190926_b()) {
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, master.mold.func_77946_l());
                } else if (!this.field_145850_b.field_72995_K) {
                    player.func_70099_a(master.mold.func_77946_l(), 0.0f);
                }
                master.mold = ItemStack.field_190927_a;
                this.updateMasterBlock(null, true);
                return true;
            }
            if (MetalPressRecipe.isValidMold(heldItem)) {
                ItemStack tempMold = !master.mold.func_190926_b() ? master.mold.func_77946_l() : ItemStack.field_190927_a;
                master.mold = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1);
                heldItem.func_190918_g(1);
                if (heldItem.func_190916_E() <= 0) {
                    heldItem = ItemStack.field_190927_a;
                } else {
                    player.func_184611_a(hand, heldItem);
                }
                if (!tempMold.func_190926_b()) {
                    if (heldItem.func_190926_b()) {
                        player.func_184611_a(hand, tempMold);
                    } else if (!this.field_145850_b.field_72995_K) {
                        player.func_70099_a(tempMold, 0.0f);
                    }
                }
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (this.posInMultiblock.func_177956_o() == 1 && this.posInMultiblock.func_177958_n() % 2 == 0) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, BlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 1 && l != 1 && (tile = this.field_145850_b.func_175625_s(pos)) instanceof ConveyorBeltTileEntity) {
            ((ConveyorBeltTileEntity)tile).setFacing(this.getFacing());
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (new BlockPos(0, 1, 0).equals((Object)this.posInMultiblock) && !world.field_72995_K && entity instanceof ItemEntity && entity.func_70089_S() && !((ItemEntity)entity).func_92059_d().func_190926_b()) {
            MetalPressTileEntity master = (MetalPressTileEntity)this.master();
            if (master == null) {
                return;
            }
            ItemStack stack = ((ItemEntity)entity).func_92059_d();
            if (stack.func_190926_b()) {
                return;
            }
            MetalPressRecipe recipe = master.findRecipeForInsertion(stack);
            if (recipe == null) {
                return;
            }
            float transformationPoint = 0.5f;
            ItemStack displayStack = recipe.getDisplayStack(stack);
            PoweredMultiblockTileEntity.MultiblockProcessInWorld<MetalPressRecipe> process = new PoweredMultiblockTileEntity.MultiblockProcessInWorld<MetalPressRecipe>(recipe, transformationPoint, Utils.createNonNullItemStackListFromItemStack(displayStack));
            if (master.addProcessToQueue(process, true)) {
                master.addProcessToQueue(process, false);
                stack.func_190918_g(displayStack.func_190916_E());
                if (stack.func_190916_E() <= 0) {
                    entity.func_70106_y();
                }
            }
        }
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(1, 2, 0));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 0));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<MetalPressRecipe> process) {
        return true;
    }

    private DirectionalBlockPos getOutputPos() {
        return new DirectionalBlockPos(this.field_174879_c.func_177967_a(this.getFacing(), 2), this.getFacing());
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).func_190926_b()) {
            DirectionalBlockPos outPos = this.getOutputPos();
            Utils.dropStackAtPos(this.field_145850_b, outPos.getPosition(), output, outPos.getSide());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<MetalPressRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 3;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 3;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<MetalPressRecipe> process) {
        float maxTicks = process.maxTicks;
        return 1.0f - (MetalPressTileEntity.getTransportTime(maxTicks) + MetalPressTileEntity.getPressTime(maxTicks)) / maxTicks;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public NonNullList<ItemStack> getDroppedItems() {
        return ListUtils.fromItem(this.mold);
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            MetalPressTileEntity master = (MetalPressTileEntity)this.master();
            if (master == null) {
                return LazyOptional.empty();
            }
            if (new BlockPos(0, 1, 0).equals((Object)this.posInMultiblock) && facing == this.getFacing().func_176734_d()) {
                return master.insertionHandler.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MetalPressRecipe findRecipeForInsertion(ItemStack inserting) {
        return MetalPressRecipe.findRecipe(this.mold, inserting, this.field_145850_b);
    }

    @Override
    protected MetalPressRecipe getRecipeForId(ResourceLocation id) {
        MetalPressRecipe recipe = MetalPressRecipe.recipeList.get(id);
        if (recipe == null) {
            recipe = MetalPressPackingRecipes.getRecipeDelegate(id);
        }
        return recipe;
    }

    @Override
    public Direction[] sigOutputDirections() {
        if (new BlockPos(2, 1, 0).equals((Object)this.posInMultiblock)) {
            return new Direction[]{this.getFacing()};
        }
        return new Direction[0];
    }

    public static float getTransportTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 20.0f;
        }
        return processMaxTicks * 20.0f / 60.0f;
    }

    public static float getPressTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 3.75f;
        }
        return processMaxTicks * 3.75f / 60.0f;
    }
}

