/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MineralMixSerializer
extends IERecipeSerializer<MineralMix> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.crusher);
    }

    @Override
    public MineralMix readFromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray array = json.getAsJsonArray("ores");
        ArrayList<StackWithChance> tempOres = new ArrayList<StackWithChance>();
        float totalChance = 0.0f;
        for (int i = 0; i < array.size(); ++i) {
            JsonObject element = array.get(i).getAsJsonObject();
            if (!CraftingHelper.processConditions((JsonObject)element, (String)"conditions")) continue;
            ItemStack stack2 = this.readOutput(element.get("output"));
            float chance = JSONUtils.func_151217_k((JsonObject)element, (String)"chance");
            totalChance += chance;
            tempOres.add(new StackWithChance(stack2, chance));
        }
        float finalTotalChance = totalChance;
        StackWithChance[] ores = (StackWithChance[])tempOres.stream().map(stack -> stack.recalculate(finalTotalChance)).toArray(StackWithChance[]::new);
        int weight = JSONUtils.func_151203_m((JsonObject)json, (String)"weight");
        float failChance = JSONUtils.func_151221_a((JsonObject)json, (String)"fail_chance", (float)0.0f);
        array = json.getAsJsonArray("dimensions");
        ArrayList<RegistryKey<World>> dimensions = new ArrayList<RegistryKey<World>>();
        for (int i = 0; i < array.size(); ++i) {
            dimensions.add(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(array.get(i).getAsString())));
        }
        ResourceLocation rl = new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"sample_background", (String)"minecraft:stone"));
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(rl);
        if (b == Blocks.field_150350_a) {
            b = Blocks.field_150348_b;
        }
        return new MineralMix(recipeId, ores, weight, failChance, dimensions, b);
    }

    @Nullable
    public MineralMix read(ResourceLocation recipeId, PacketBuffer buffer) {
        int count = buffer.readInt();
        StackWithChance[] outputs = new StackWithChance[count];
        for (int i = 0; i < count; ++i) {
            outputs[i] = StackWithChance.read(buffer);
        }
        int weight = buffer.readInt();
        float failChance = buffer.readFloat();
        count = buffer.readInt();
        ArrayList<RegistryKey<World>> dimensions = new ArrayList<RegistryKey<World>>();
        for (int i = 0; i < count; ++i) {
            dimensions.add(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buffer.func_192575_l()));
        }
        Block bg = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        return new MineralMix(recipeId, outputs, weight, failChance, dimensions, bg);
    }

    public void write(PacketBuffer buffer, MineralMix recipe) {
        buffer.writeInt(recipe.outputs.length);
        for (StackWithChance secondaryOutput : recipe.outputs) {
            secondaryOutput.write(buffer);
        }
        buffer.writeInt(recipe.weight);
        buffer.writeFloat(recipe.failChance);
        buffer.writeInt(recipe.dimensions.size());
        for (RegistryKey dimension : recipe.dimensions) {
            buffer.func_192572_a(dimension.func_240901_a_());
        }
        buffer.func_192572_a(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)recipe.background));
    }
}

