/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.blocks.metal.ArcFurnaceTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.AssemblerTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.AutoWorkbenchTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ClocheTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FermenterTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MixerTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.RefineryTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.SqueezerTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ToolboxTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretChemTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunTileEntity;
import blusunrize.immersiveengineering.common.blocks.stone.AlloySmelterTileEntity;
import blusunrize.immersiveengineering.common.blocks.stone.BlastFurnaceAdvancedTileEntity;
import blusunrize.immersiveengineering.common.blocks.stone.BlastFurnaceTileEntity;
import blusunrize.immersiveengineering.common.blocks.stone.CokeOvenTileEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.CircuitTableTileEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.CraftingTableTileEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.FluidSorterTileEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.ItemBatcherTileEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.LogicUnitTileEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchTileEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterTileEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.WoodenCrateTileEntity;
import blusunrize.immersiveengineering.common.entities.CrateMinecartEntity;
import blusunrize.immersiveengineering.common.entities.ReinforcedCrateMinecartEntity;
import blusunrize.immersiveengineering.common.gui.AlloySmelterContainer;
import blusunrize.immersiveengineering.common.gui.ArcFurnaceContainer;
import blusunrize.immersiveengineering.common.gui.AssemblerContainer;
import blusunrize.immersiveengineering.common.gui.AutoWorkbenchContainer;
import blusunrize.immersiveengineering.common.gui.BlastFurnaceContainer;
import blusunrize.immersiveengineering.common.gui.CircuitTableContainer;
import blusunrize.immersiveengineering.common.gui.ClocheContainer;
import blusunrize.immersiveengineering.common.gui.CokeOvenContainer;
import blusunrize.immersiveengineering.common.gui.CraftingTableContainer;
import blusunrize.immersiveengineering.common.gui.CrateContainer;
import blusunrize.immersiveengineering.common.gui.CrateEntityContainer;
import blusunrize.immersiveengineering.common.gui.FermenterContainer;
import blusunrize.immersiveengineering.common.gui.FluidSorterContainer;
import blusunrize.immersiveengineering.common.gui.IEBaseContainer;
import blusunrize.immersiveengineering.common.gui.ItemBatcherContainer;
import blusunrize.immersiveengineering.common.gui.LogicUnitContainer;
import blusunrize.immersiveengineering.common.gui.MaintenanceKitContainer;
import blusunrize.immersiveengineering.common.gui.MixerContainer;
import blusunrize.immersiveengineering.common.gui.ModWorkbenchContainer;
import blusunrize.immersiveengineering.common.gui.RefineryContainer;
import blusunrize.immersiveengineering.common.gui.RevolverContainer;
import blusunrize.immersiveengineering.common.gui.SorterContainer;
import blusunrize.immersiveengineering.common.gui.SqueezerContainer;
import blusunrize.immersiveengineering.common.gui.ToolboxBlockContainer;
import blusunrize.immersiveengineering.common.gui.ToolboxContainer;
import blusunrize.immersiveengineering.common.gui.TurretContainer;
import blusunrize.immersiveengineering.common.items.MaintenanceKitItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.items.ToolboxItem;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.IContainerFactory;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuiHandler {
    private static final Map<Class<? extends TileEntity>, TileContainer<?, ?>> TILE_CONTAINERS = new HashMap();
    private static final Map<Class<? extends Item>, ItemContainer<?>> ITEM_CONTAINERS = new HashMap();
    private static final Map<Class<? extends Entity>, EntityContainer<?, ?>> ENTITY_CONTAINERS = new HashMap();
    private static final Map<ResourceLocation, ContainerType<?>> ALL_TYPES = new HashMap();

    public static void commonInit() {
        GuiHandler.register(CokeOvenTileEntity.class, Lib.GUIID_CokeOven, CokeOvenContainer::new);
        GuiHandler.register(AlloySmelterTileEntity.class, Lib.GUIID_AlloySmelter, AlloySmelterContainer::new);
        GuiHandler.register(BlastFurnaceTileEntity.class, Lib.GUIID_BlastFurnace, BlastFurnaceContainer::new);
        GuiHandler.useSameContainerTile(BlastFurnaceTileEntity.class, BlastFurnaceAdvancedTileEntity.class);
        GuiHandler.register(CraftingTableTileEntity.class, Lib.GUIID_CraftingTable, CraftingTableContainer::new);
        GuiHandler.register(WoodenCrateTileEntity.class, Lib.GUIID_WoodenCrate, CrateContainer::new);
        GuiHandler.register(ModWorkbenchTileEntity.class, Lib.GUIID_Workbench, ModWorkbenchContainer::new);
        GuiHandler.register(CircuitTableTileEntity.class, Lib.GUIID_CircuitTable, CircuitTableContainer::new);
        GuiHandler.register(AssemblerTileEntity.class, Lib.GUIID_Assembler, AssemblerContainer::new);
        GuiHandler.register(SorterTileEntity.class, Lib.GUIID_Sorter, SorterContainer::new);
        GuiHandler.register(ItemBatcherTileEntity.class, Lib.GUIID_ItemBatcher, ItemBatcherContainer::new);
        GuiHandler.register(LogicUnitTileEntity.class, Lib.GUIID_LogicUnit, LogicUnitContainer::new);
        GuiHandler.register(SqueezerTileEntity.class, Lib.GUIID_Squeezer, SqueezerContainer::new);
        GuiHandler.register(FermenterTileEntity.class, Lib.GUIID_Fermenter, FermenterContainer::new);
        GuiHandler.register(RefineryTileEntity.class, Lib.GUIID_Refinery, RefineryContainer::new);
        GuiHandler.register(ArcFurnaceTileEntity.class, Lib.GUIID_ArcFurnace, ArcFurnaceContainer::new);
        GuiHandler.register(AutoWorkbenchTileEntity.class, Lib.GUIID_AutoWorkbench, AutoWorkbenchContainer::new);
        GuiHandler.register(MixerTileEntity.class, Lib.GUIID_Mixer, MixerContainer::new);
        GuiHandler.register(TurretGunTileEntity.class, Lib.GUIID_Turret_Gun, TurretContainer::new);
        GuiHandler.register(TurretChemTileEntity.class, Lib.GUIID_Turret_Chem, TurretContainer::new);
        GuiHandler.register(FluidSorterTileEntity.class, Lib.GUIID_FluidSorter, FluidSorterContainer::new);
        GuiHandler.register(ClocheTileEntity.class, Lib.GUIID_Cloche, ClocheContainer::new);
        GuiHandler.register(ToolboxTileEntity.class, Lib.GUIID_ToolboxBlock, ToolboxBlockContainer::new);
        GuiHandler.register(ToolboxItem.class, Lib.GUIID_Toolbox, ToolboxContainer::new);
        GuiHandler.register(RevolverItem.class, Lib.GUIID_Revolver, RevolverContainer::new);
        GuiHandler.register(MaintenanceKitItem.class, Lib.GUIID_MaintenanceKit, MaintenanceKitContainer::new);
        GuiHandler.useSameContainerItem(RevolverItem.class, SpeedloaderItem.class);
        GuiHandler.register(CrateMinecartEntity.class, Lib.GUIID_CartCrate, (int windowId, PlayerInventory inventoryPlayer, E entity) -> new CrateEntityContainer(windowId, inventoryPlayer, (WoodenCrateTileEntity)entity.getContainedTileEntity(), entity));
        GuiHandler.register(ReinforcedCrateMinecartEntity.class, Lib.GUIID_CartReinforcedCrate, (int windowId, PlayerInventory inventoryPlayer, E entity) -> new CrateEntityContainer(windowId, inventoryPlayer, (WoodenCrateTileEntity)entity.getContainedTileEntity(), entity));
    }

    public static <T extends TileEntity, C extends IEBaseContainer<? super T>> void register(Class<T> tileClass, ResourceLocation name, TileContainerConstructor<T, C> container) {
        ContainerType type = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            World world = ImmersiveEngineering.proxy.getClientWorld();
            BlockPos pos = data.func_179259_c();
            TileEntity te = world.func_175625_s(pos);
            return container.construct(windowId, inv, te);
        }));
        type.setRegistryName(name);
        TILE_CONTAINERS.put(tileClass, new TileContainer(type, container));
        ALL_TYPES.put(name, type);
    }

    public static void useSameContainerTile(Class<? extends TileEntity> existing, Class<? extends TileEntity> toAdd) {
        Preconditions.checkArgument((boolean)TILE_CONTAINERS.containsKey(existing));
        TILE_CONTAINERS.put(toAdd, TILE_CONTAINERS.get(existing));
    }

    public static <C extends Container> void register(Class<? extends Item> itemClass, ResourceLocation name, ItemContainerConstructor<C> container) {
        ContainerType type = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            World world = ImmersiveEngineering.proxy.getClientWorld();
            int slotOrdinal = data.readInt();
            EquipmentSlotType slot = EquipmentSlotType.values()[slotOrdinal];
            ItemStack stack = ImmersiveEngineering.proxy.getClientPlayer().func_184582_a(slot);
            return container.construct(windowId, inv, world, slot, stack);
        }));
        type.setRegistryName(name);
        ITEM_CONTAINERS.put(itemClass, new ItemContainer(type, container));
        ALL_TYPES.put(name, type);
    }

    public static <T0 extends Item, T extends Item> void useSameContainerItem(Class<T0> existing, Class<T> toAdd) {
        Preconditions.checkArgument((boolean)ITEM_CONTAINERS.containsKey(existing));
        ITEM_CONTAINERS.put(toAdd, ITEM_CONTAINERS.get(existing));
    }

    public static <E extends Entity, C extends Container> void register(Class<? extends Entity> entityClass, ResourceLocation name, EntityContainerConstructor<E, C> container) {
        ContainerType type = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            World world = ImmersiveEngineering.proxy.getClientWorld();
            int entityId = data.readInt();
            Entity entity = ImmersiveEngineering.proxy.getClientWorld().func_73045_a(entityId);
            return container.construct(windowId, inv, entity);
        }));
        type.setRegistryName(name);
        ENTITY_CONTAINERS.put(entityClass, new EntityContainer(type, container));
        ALL_TYPES.put(name, type);
    }

    public static <T extends TileEntity> Container createContainer(PlayerInventory inv, T te, int id) {
        return GuiHandler.TILE_CONTAINERS.get(te.getClass()).factory.construct(id, inv, te);
    }

    public static Container createContainer(PlayerInventory inv, World w, EquipmentSlotType slot, ItemStack stack, int id) {
        return GuiHandler.ITEM_CONTAINERS.get(stack.func_77973_b().getClass()).factory.construct(id, inv, w, slot, stack);
    }

    public static <E extends Entity> Container createContainer(PlayerInventory inv, E entity, int id) {
        return GuiHandler.ENTITY_CONTAINERS.get(entity.getClass()).factory.construct(id, inv, entity);
    }

    public static ContainerType<?> getContainerTypeFor(TileEntity te) {
        return GuiHandler.TILE_CONTAINERS.get(te.getClass()).type;
    }

    public static ContainerType<?> getContainerTypeFor(ItemStack stack) {
        return GuiHandler.ITEM_CONTAINERS.get(stack.func_77973_b().getClass()).type;
    }

    public static ContainerType<?> getContainerTypeFor(Entity entity) {
        return GuiHandler.ENTITY_CONTAINERS.get(entity.getClass()).type;
    }

    public static ContainerType<?> getContainerType(ResourceLocation name) {
        return ALL_TYPES.get(name);
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> evt) {
        for (TileContainer<?, ?> tileContainer : new HashSet(TILE_CONTAINERS.values())) {
            evt.getRegistry().register(tileContainer.type);
        }
        for (ItemContainer itemContainer : new HashSet(ITEM_CONTAINERS.values())) {
            evt.getRegistry().register(itemContainer.type);
        }
        for (EntityContainer entityContainer : new HashSet(ENTITY_CONTAINERS.values())) {
            evt.getRegistry().register(entityContainer.type);
        }
    }

    private static class EntityContainer<E extends Entity, C extends Container> {
        final ContainerType<C> type;
        final EntityContainerConstructor<E, C> factory;

        private EntityContainer(ContainerType<C> type, EntityContainerConstructor<E, C> factory) {
            this.type = type;
            this.factory = factory;
        }
    }

    private static class ItemContainer<C extends Container> {
        final ContainerType<C> type;
        final ItemContainerConstructor<C> factory;

        private ItemContainer(ContainerType<C> type, ItemContainerConstructor<C> factory) {
            this.type = type;
            this.factory = factory;
        }
    }

    private static class TileContainer<T extends TileEntity, C extends IEBaseContainer<? super T>> {
        final ContainerType<C> type;
        final TileContainerConstructor<T, C> factory;

        private TileContainer(ContainerType<C> type, TileContainerConstructor<T, C> factory) {
            this.type = type;
            this.factory = factory;
        }
    }

    public static interface EntityContainerConstructor<E extends Entity, C extends Container> {
        public C construct(int var1, PlayerInventory var2, E var3);
    }

    public static interface TileContainerConstructor<T extends TileEntity, C extends IEBaseContainer<? super T>> {
        public C construct(int var1, PlayerInventory var2, T var3);
    }

    public static interface ItemContainerConstructor<C extends Container> {
        public C construct(int var1, PlayerInventory var2, World var3, EquipmentSlotType var4, ItemStack var5);
    }
}

