/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseItem;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerTileEntity;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class ShaderItem
extends IEBaseItem
implements IShaderItem,
IEItemInterfaces.ITextureOverride {
    public ShaderItem() {
        super("shader", new Item.Properties().func_200917_a(1));
    }

    @Override
    public ShaderCase getShaderCase(ItemStack shader, ItemStack item, ResourceLocation shaderType) {
        return ShaderRegistry.getShader(this.getShaderName(shader), shaderType);
    }

    @Override
    public ResourceLocation getShaderName(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "shader_name")) {
            return new ResourceLocation(ItemNBTHelper.getString(stack, "shader_name"));
        }
        return null;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        ResourceLocation name = this.getShaderName(ctx.func_195996_i());
        if (ShaderRegistry.shaderRegistry.containsKey(name)) {
            BlockState blockState = world.func_180495_p(pos);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof BannerTileEntity) {
                ShaderCase sCase = ShaderRegistry.shaderRegistry.get(name).getCase(new ResourceLocation("immersiveengineering", "banner"));
                if (sCase != null) {
                    boolean wall = blockState.func_177230_c() instanceof WallBannerBlock;
                    if (wall) {
                        world.func_175656_a(pos, (BlockState)IEBlocks.Cloth.shaderBannerWall.func_176223_P().func_206870_a(ShaderBannerWallBlock.FACING, blockState.func_177229_b((Property)WallBannerBlock.field_196290_a)));
                    } else {
                        world.func_175656_a(pos, (BlockState)IEBlocks.Cloth.shaderBanner.func_176223_P().func_206870_a((Property)ShaderBannerStandingBlock.ROTATION, blockState.func_177229_b((Property)BannerBlock.field_176448_b)));
                    }
                    tile = world.func_175625_s(pos);
                    if (tile instanceof ShaderBannerTileEntity) {
                        ((ShaderBannerTileEntity)tile).shader.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)ctx.func_195996_i(), (int)1));
                        tile.func_70296_d();
                        return ActionResultType.SUCCESS;
                    }
                }
            } else if (tile instanceof ShaderBannerTileEntity) {
                ((ShaderBannerTileEntity)tile).shader.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)ctx.func_195996_i(), (int)1));
                tile.func_70296_d();
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.level").func_240702_b_(this.func_77613_e((ItemStack)stack).field_77937_e.toString()).func_230529_a_((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.rarity." + this.func_77613_e(stack).name().toLowerCase(Locale.US))));
        if (!Screen.func_231173_s_()) {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.applyTo").func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.holdShift")));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.applyTo"));
            ResourceLocation rl = this.getShaderName(stack);
            if (rl != null) {
                List<ShaderCase> array = ShaderRegistry.shaderRegistry.get(rl).getCases();
                for (ShaderCase sCase : array) {
                    if (sCase instanceof ShaderCaseItem) continue;
                    list.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader." + sCase.getShaderType()), TextFormatting.DARK_GRAY));
                }
            }
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        IFormattableTextComponent itc = super.func_200295_i(stack).func_230532_e_();
        ResourceLocation rl = this.getShaderName(stack);
        if (rl != null) {
            itc.func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent("item." + rl.func_110624_b() + ".shader.name." + rl.func_110623_a()));
        }
        return itc;
    }

    @Nonnull
    public Rarity func_77613_e(ItemStack stack) {
        ResourceLocation rl = this.getShaderName(stack);
        return ShaderRegistry.shaderRegistry.containsKey(rl) ? ShaderRegistry.shaderRegistry.get(rl).getRarity() : Rarity.COMMON;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (ResourceLocation key : ShaderRegistry.shaderRegistry.keySet()) {
                ItemStack s = new ItemStack((IItemProvider)this);
                ItemNBTHelper.putString(s, "shader_name", key.toString());
                list.add((Object)s);
            }
        }
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        ShaderCase sCase;
        ResourceLocation name = this.getShaderName(stack);
        if (ShaderRegistry.shaderRegistry.containsKey(name) && (sCase = ShaderRegistry.shaderRegistry.get(name).getCase(new ResourceLocation("immersiveengineering", "item"))) != null) {
            ShaderLayer[] layers = sCase.getLayers();
            if (pass < layers.length && layers[pass] != null) {
                return Utils.intFromRGBA(layers[pass].getColor());
            }
            return -1;
        }
        return super.getColourForIEItem(stack, pass);
    }

    @Override
    public String getModelCacheKey(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "shader_name")) {
            return ItemNBTHelper.getString(stack, "shader_name");
        }
        return null;
    }

    @Override
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ShaderCase sCase;
        ResourceLocation name = this.getShaderName(stack);
        if (ShaderRegistry.shaderRegistry.containsKey(name) && (sCase = ShaderRegistry.shaderRegistry.get(name).getCase(new ResourceLocation("immersiveengineering", "item"))) != null) {
            ShaderLayer[] layers = sCase.getLayers();
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(layers.length);
            for (ShaderLayer layer : layers) {
                list.add(layer.getTexture());
            }
            return list;
        }
        return Arrays.asList(new ResourceLocation("immersiveengineering:item/shader_0"), new ResourceLocation("immersiveengineering:item/shader_1"), new ResourceLocation("immersiveengineering:item/shader_2"));
    }
}

