/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.entities.CapabilitySkyhookData;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SkylineHelper {
    private static final double LN_0_98 = Math.log(0.98);

    public static void spawnHook(LivingEntity player, Connection connection, Hand hand, boolean limitSpeed) {
        if (!player.field_70170_p.field_72995_K) {
            GlobalWireNetwork global = GlobalWireNetwork.getNetwork(player.field_70170_p);
            ConnectionPoint cpA = connection.getEndA();
            ConnectionPoint cpB = connection.getEndB();
            IImmersiveConnectable iicB = global.getExistingConnector(cpB);
            IImmersiveConnectable iicA = global.getExistingConnector(cpA);
            Vector3d vStart = Vector3d.func_237491_b_((Vector3i)cpA.getPosition());
            Vector3d vEnd = Vector3d.func_237491_b_((Vector3i)cpB.getPosition());
            if (iicB != null) {
                vStart = vStart.func_178787_e(iicB.getConnectionOffset(connection, cpB));
            }
            if (iicA != null) {
                vEnd = vEnd.func_178787_e(iicA.getConnectionOffset(connection, cpA));
            }
            Vector3d pos = player.func_174824_e(0.0f);
            Vector3d across = new Vector3d(vEnd.field_72450_a - vStart.field_72450_a, vEnd.field_72448_b - vStart.field_72448_b, vEnd.field_72449_c - vStart.field_72449_c);
            double linePos = WireUtils.getCoeffForMinDistance(pos, vStart, across);
            connection.generateCatenaryData(player.field_70170_p);
            Connection.CatenaryData catData = connection.getCatenaryData();
            Vector3d playerMovement = new Vector3d(player.func_213322_ci().field_72450_a, player.func_213322_ci().field_72448_b, player.func_213322_ci().field_72449_c);
            double slopeAtPos = connection.getSlope(linePos, cpA);
            Vector3d extendedWire = catData.isVertical() ? new Vector3d(0.0, catData.getHorLength(), 0.0) : new Vector3d(catData.getDeltaX(), slopeAtPos * catData.getHorLength(), catData.getDeltaZ());
            extendedWire = extendedWire.func_72432_b();
            double totalSpeed = playerMovement.func_72430_b(extendedWire);
            double horSpeed = totalSpeed / Math.sqrt(1.0 + slopeAtPos * slopeAtPos);
            SkylineHookEntity hook = new SkylineHookEntity(player.field_70170_p, connection, cpA, linePos, hand, horSpeed, limitSpeed);
            IELogger.logger.info("Speed keeping: Player {}, wire {}, Pos: {}", (Object)playerMovement, (Object)extendedWire, (Object)hook.func_213303_ch());
            if (hook.isValidPosition(hook.func_226277_ct_(), hook.func_226278_cu_(), hook.func_226281_cx_(), player)) {
                double vertSpeed = Math.sqrt(totalSpeed * totalSpeed - horSpeed * horSpeed);
                double speedDiff = player.func_213322_ci().field_72448_b - vertSpeed;
                if (speedDiff < 0.0) {
                    player.func_225503_b_(SkylineHelper.fallDistanceFromSpeed(speedDiff), 1.2f);
                    player.field_70143_R = 0.0f;
                }
                player.field_70170_p.func_217376_c((Entity)hook);
                player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).ifPresent(data -> {
                    data.startRiding();
                    data.hook = hook;
                });
                player.func_184220_m((Entity)hook);
                IELogger.logger.debug("Started riding");
            } else {
                IELogger.logger.debug("Invalid pos");
            }
        }
    }

    public static float fallDistanceFromSpeed(double v) {
        double fallTime = Math.log(v / 3.92 + 1.0) / LN_0_98;
        return -((float)(196.0 - 3.92 * fallTime - 194.04 * Math.pow(0.98, fallTime - 0.5)));
    }

    public static List<VoxelShape> getCollisionBoxes(@Nullable Entity entityIn, AxisAlignedBB aabb, World w, Collection<BlockPos> ignored) {
        ArrayList list = Lists.newArrayList();
        SkylineHelper.getBlockCollisionBoxes(entityIn, aabb, list, w, ignored);
        w.func_226666_b_(entityIn, aabb).forEach(list::add);
        return list;
    }

    public static void getBlockCollisionBoxes(final @Nullable Entity entityIn, AxisAlignedBB aabb, @Nonnull List<VoxelShape> outList, final World w, final Collection<BlockPos> ignored) {
        int minX = MathHelper.func_76128_c((double)(aabb.field_72340_a - 1.0E-7)) - 1;
        int maxX = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0E-7)) + 1;
        int minY = MathHelper.func_76128_c((double)(aabb.field_72338_b - 1.0E-7)) - 1;
        int maxY = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0E-7)) + 1;
        int minZ = MathHelper.func_76128_c((double)(aabb.field_72339_c - 1.0E-7)) - 1;
        int maxZ = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0E-7)) + 1;
        final ISelectionContext selectionCtx = entityIn == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entityIn);
        final CubeCoordinateIterator it = new CubeCoordinateIterator(minX, minY, minZ, maxX, maxY, maxZ);
        final BlockPos.Mutable currPos = new BlockPos.Mutable();
        final VoxelShape searchShape = VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
        StreamSupport.stream(new Spliterators.AbstractSpliterator<VoxelShape>(Long.MAX_VALUE, 1280){
            boolean isEntityNull;
            {
                super(x0, x1);
                this.isEntityNull = entityIn == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super VoxelShape> add) {
                VoxelShape blockShapeWithOffset;
                if (!this.isEntityNull) {
                    assert (entityIn != null);
                    this.isEntityNull = true;
                    VoxelShape worldBorder = w.func_175723_af().func_222521_a();
                    boolean veryOutside = VoxelShapes.func_197879_c((VoxelShape)worldBorder, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entityIn.func_174813_aQ().func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_);
                    boolean nearlyOutside = VoxelShapes.func_197879_c((VoxelShape)worldBorder, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entityIn.func_174813_aQ().func_186662_g(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_);
                    if (!veryOutside && nearlyOutside) {
                        add.accept((VoxelShape)worldBorder);
                        return true;
                    }
                }
                while (true) {
                    VoxelShape blockShape;
                    int chunkZ;
                    int chunkX;
                    IBlockReader iblockreader;
                    if (!it.func_218301_a()) {
                        return false;
                    }
                    int currX = it.func_218304_b();
                    int currY = it.func_218302_c();
                    int currZ = it.func_218303_d();
                    int numBounderies = it.func_223473_e();
                    if (numBounderies == 3 || (iblockreader = w.func_225522_c_(chunkX = currX >> 4, chunkZ = currZ >> 4)) == null) continue;
                    currPos.func_181079_c(currX, currY, currZ);
                    BlockState blockstate = iblockreader.func_180495_p((BlockPos)currPos);
                    if (!(numBounderies == 1 && !blockstate.func_215704_f() || numBounderies == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb || ignored.contains(currPos) || !VoxelShapes.func_197879_c((VoxelShape)searchShape, (VoxelShape)(blockShapeWithOffset = (blockShape = blockstate.func_215685_b((IBlockReader)w, (BlockPos)currPos, selectionCtx)).func_197751_a((double)currX, (double)currY, (double)currZ)), (IBooleanFunction)IBooleanFunction.field_223238_i_))) break;
                }
                add.accept((VoxelShape)blockShapeWithOffset);
                return true;
            }
        }, false).forEach(outList::add);
    }
}

