/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.SpecialDoorBlock;
import net.geforcemods.securitycraft.tileentity.KeypadDoorTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class KeypadDoorBlock
extends SpecialDoorBlock {
    public KeypadDoorBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((Property)field_176519_b)).booleanValue()) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            KeypadDoorTileEntity te = (KeypadDoorTileEntity)world.func_175625_s(pos);
            if (ModuleUtils.isDenied(te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                }
                return ActionResultType.FAIL;
            }
            if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                }
                KeypadDoorBlock.activate(world, pos, state, te.getSignalLength());
            } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand) && !PlayerUtils.isHoldingItem(player, SCContent.KEY_PANEL, hand)) {
                te.openPasswordGUI(player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static void activate(World world, BlockPos pos, BlockState state, int signalLength) {
        boolean open = (Boolean)state.func_177229_b((Property)field_176519_b) == false;
        world.func_217378_a(null, open ? 1005 : 1011, pos, 0);
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(open)));
        world.func_195593_d(pos, (Block)SCContent.KEYPAD_DOOR.get());
        if (open && signalLength > 0) {
            world.func_205220_G_().func_205360_a(pos, (Object)SCContent.KEYPAD_DOOR.get(), signalLength);
        }
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KeypadDoorTileEntity().linkable();
    }

    @Override
    public Item getDoorItem() {
        return (Item)SCContent.KEYPAD_DOOR_ITEM.get();
    }
}

