/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.tileentity.KeypadFurnaceTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class KeypadFurnaceBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    private static final VoxelShape NORTH_OPEN = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)2.0, (double)3.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)2.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)1.0, (double)1.0, (double)11.0, (double)2.0, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)), (VoxelShape)Block.func_208617_a((double)1.0, (double)2.0, (double)3.0, (double)15.0, (double)15.0, (double)4.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape NORTH_CLOSED = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)3.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)14.0, (double)1.0, (double)11.0, (double)15.0, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));
    private static final VoxelShape EAST_OPEN = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)1.0, (double)1.0, (double)14.0, (double)2.0, (double)15.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)14.0, (double)1.0, (double)4.0, (double)16.0, (double)2.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)14.0, (double)1.0, (double)5.0, (double)15.0, (double)2.0, (double)11.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)), (VoxelShape)Block.func_208617_a((double)12.0, (double)2.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape EAST_CLOSED = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)14.0, (double)14.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)14.0, (double)14.0, (double)5.0, (double)15.0, (double)15.0, (double)11.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));
    private static final VoxelShape SOUTH_OPEN = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0, (double)14.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)4.0, (double)1.0, (double)14.0, (double)12.0, (double)2.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)1.0, (double)14.0, (double)11.0, (double)2.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)), (VoxelShape)Block.func_208617_a((double)1.0, (double)2.0, (double)12.0, (double)15.0, (double)15.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape SOUTH_CLOSED = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0, (double)14.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)4.0, (double)14.0, (double)14.0, (double)12.0, (double)15.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)14.0, (double)14.0, (double)11.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));
    private static final VoxelShape WEST_OPEN = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)1.0, (double)1.0, (double)3.0, (double)2.0, (double)15.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)2.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)5.0, (double)2.0, (double)2.0, (double)11.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)), (VoxelShape)Block.func_208617_a((double)3.0, (double)2.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape WEST_CLOSED = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)15.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)0.0, (double)14.0, (double)4.0, (double)2.0, (double)15.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)14.0, (double)5.0, (double)2.0, (double)15.0, (double)11.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));

    public KeypadFurnaceBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
                    return NORTH_OPEN;
                }
                return NORTH_CLOSED;
            }
            case EAST: {
                if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
                    return EAST_OPEN;
                }
                return EAST_CLOSED;
            }
            case SOUTH: {
                if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
                    return SOUTH_OPEN;
                }
                return SOUTH_CLOSED;
            }
            case WEST: {
                if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
                    return WEST_OPEN;
                }
                return WEST_CLOSED;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.func_177230_c() instanceof KeypadFurnaceBlock)) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            KeypadFurnaceTileEntity te = (KeypadFurnaceTileEntity)world.func_175625_s(pos);
            if (ModuleUtils.isDenied(te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                }
                return ActionResultType.FAIL;
            }
            if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                }
                KeypadFurnaceBlock.activate(world, pos, player);
            } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand)) {
                te.openPasswordGUI(player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static void activate(World world, BlockPos pos, PlayerEntity player) {
        TileEntity te;
        BlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(true)));
        }
        if (player instanceof ServerPlayerEntity && (te = world.func_175625_s(pos)) instanceof INamedContainerProvider) {
            world.func_217378_a((PlayerEntity)null, 1006, pos, 0);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d())).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue() && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = pos.func_177956_o();
            double z = (double)pos.func_177952_p() + 0.5;
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a(x, y, z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            Direction.Axis axis = direction.func_176740_k();
            double randomNumber = rand.nextDouble() * 0.6 - 0.3;
            double xOffset = axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : randomNumber;
            double yOffset = rand.nextDouble() * 6.0 / 16.0;
            double zOffset = axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : randomNumber;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, OPEN, LIT});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KeypadFurnaceTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public static class Convertible
    implements IPasswordConvertible {
        @Override
        public Block getOriginalBlock() {
            return Blocks.field_150460_al;
        }

        @Override
        public boolean convert(PlayerEntity player, World world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            boolean lit = (Boolean)state.func_177229_b((Property)LIT);
            FurnaceTileEntity furnace = (FurnaceTileEntity)world.func_175625_s(pos);
            CompoundNBT tag = furnace.func_189515_b(new CompoundNBT());
            furnace.func_174888_l();
            world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((Block)SCContent.KEYPAD_FURNACE.get()).func_176223_P().func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(lit)));
            ((KeypadFurnaceTileEntity)world.func_175625_s(pos)).func_230337_a_(world.func_180495_p(pos), tag);
            ((IOwnable)world.func_175625_s(pos)).setOwner(player.func_110124_au().toString(), player.func_200200_C_().getString());
            return true;
        }
    }
}

