/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.top;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class TOPDataProvider
implements Function<ITheOneProbe, Void> {
    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
            ItemStack disguisedAs = ItemStack.field_190927_a;
            if (blockState.func_177230_c() instanceof DisguisableBlock) {
                disguisedAs = ((DisguisableBlock)blockState.func_177230_c()).getDisguisedStack((IBlockReader)world, data.getPos());
            } else if (blockState.func_177230_c() instanceof IOverlayDisplay) {
                disguisedAs = ((IOverlayDisplay)blockState.func_177230_c()).getDisplayStack(world, blockState, data.getPos());
            }
            if (!disguisedAs.func_190926_b()) {
                probeInfo.horizontal().item(disguisedAs).vertical().itemLabel(disguisedAs).text((ITextComponent)new StringTextComponent("" + TextFormatting.BLUE + TextFormatting.ITALIC + ((ModContainer)ModList.get().getModContainerById(disguisedAs.func_77973_b().getRegistryName().func_110624_b()).get()).getModInfo().getDisplayName()));
                return true;
            }
            return false;
        });
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
                Block block = blockState.func_177230_c();
                if (block instanceof IOverlayDisplay && !((IOverlayDisplay)block).shouldShowSCInfo(world, blockState, data.getPos())) {
                    return;
                }
                TileEntity te = world.func_175625_s(data.getPos());
                if (te instanceof IOwnable) {
                    probeInfo.vertical().text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + Utils.localize("waila.securitycraft:owner", ((IOwnable)te).getOwner().getName()).getString()));
                }
                if (te instanceof IModuleInventory && (!(te instanceof IOwnable) || ((IOwnable)te).getOwner().isOwner(player)) && !((IModuleInventory)te).getInsertedModules().isEmpty()) {
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + Utils.localize("waila.securitycraft:equipped", new Object[0]).getString()));
                    for (ModuleType module : ((IModuleInventory)te).getInsertedModules()) {
                        probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "- ").func_230529_a_((ITextComponent)new TranslationTextComponent(module.getTranslationKey())));
                    }
                }
                if (te instanceof IPasswordProtected && !(te instanceof KeycardReaderTileEntity) && ((IOwnable)te).getOwner().isOwner(player)) {
                    String password = ((IPasswordProtected)te).getPassword();
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + Utils.localize("waila.securitycraft:password", password != null && !password.isEmpty() ? password : Utils.localize("waila.securitycraft:password.notSet", new Object[0])).getString()));
                }
                if (te instanceof INameable && ((INameable)te).canBeNamed()) {
                    ITextComponent text = ((INameable)te).getCustomSCName();
                    ITextComponent name = text == null ? StringTextComponent.field_240750_d_ : text;
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + Utils.localize("waila.securitycraft:customName", ((INameable)te).hasCustomSCName() ? name : Utils.localize("waila.securitycraft:customName.notSet", new Object[0])).getString()));
                }
            }
        });
        theOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, Entity entity, IProbeHitEntityData data) {
                if (entity instanceof SentryEntity) {
                    SentryEntity sentry = (SentryEntity)entity;
                    SentryEntity.SentryMode mode = sentry.getMode();
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + Utils.localize("waila.securitycraft:owner", ((SentryEntity)entity).getOwner().getName()).getString()));
                    if (!sentry.getAllowlistModule().func_190926_b() || !sentry.getDisguiseModule().func_190926_b() || sentry.hasSpeedModule()) {
                        probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + Utils.localize("waila.securitycraft:equipped", new Object[0]).getString()));
                        if (!sentry.getAllowlistModule().func_190926_b()) {
                            probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "- ").func_230529_a_((ITextComponent)new TranslationTextComponent(ModuleType.ALLOWLIST.getTranslationKey())));
                        }
                        if (!sentry.getDisguiseModule().func_190926_b()) {
                            probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "- ").func_230529_a_((ITextComponent)new TranslationTextComponent(ModuleType.DISGUISE.getTranslationKey())));
                        }
                        if (sentry.hasSpeedModule()) {
                            probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "- ").func_230529_a_((ITextComponent)new TranslationTextComponent(ModuleType.SPEED.getTranslationKey())));
                        }
                    }
                    TranslationTextComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
                    if (mode != SentryEntity.SentryMode.IDLE) {
                        modeDescription.func_240702_b_("- ").func_230529_a_((ITextComponent)Utils.localize(mode.getTargetKey(), new Object[0]));
                    }
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GRAY + modeDescription.getString()));
                }
            }
        });
        return null;
    }
}

