/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.fluids;

import java.util.Random;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

public abstract class FakeWaterFluid
extends FlowingFluid {
    public Fluid func_210197_e() {
        return (Fluid)SCContent.FLOWING_FAKE_WATER.get();
    }

    public Fluid func_210198_f() {
        return (Fluid)SCContent.FAKE_WATER.get();
    }

    public Item func_204524_b() {
        return (Item)SCContent.FAKE_WATER_BUCKET.get();
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.Water.builder((ResourceLocation)new ResourceLocation("block/water_still"), (ResourceLocation)new ResourceLocation("block/water_flow")).overlay(new ResourceLocation("block/water_overlay")).translationKey("block.minecraft.water").color(-12618012).build((Fluid)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World world, BlockPos pos, FluidState state, Random random) {
        if (!state.func_206889_d() && !((Boolean)state.func_177229_b((Property)field_207209_a)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197605_P, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)((float)pos.func_177956_o() + random.nextFloat()), (double)((float)pos.func_177952_p() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IParticleData func_204521_c() {
        return ParticleTypes.field_197618_k;
    }

    protected boolean func_205579_d() {
        return true;
    }

    protected void func_205580_a(IWorld world, BlockPos pos, BlockState state) {
        TileEntity te = state.hasTileEntity() ? world.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)te);
    }

    public int func_185698_b(IWorldReader world) {
        return 4;
    }

    public BlockState func_204527_a(FluidState state) {
        return (BlockState)((Block)SCContent.FAKE_WATER_BLOCK.get()).func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(FakeWaterFluid.func_207205_e((FluidState)state)));
    }

    public boolean func_207187_a(Fluid fluid) {
        return fluid == SCContent.FAKE_WATER.get() || fluid == SCContent.FLOWING_FAKE_WATER.get();
    }

    public int func_204528_b(IWorldReader world) {
        return 1;
    }

    public int func_205569_a(IWorldReader world) {
        return 5;
    }

    public boolean func_215665_a(FluidState fluidState, IBlockReader world, BlockPos pos, Fluid fluid, Direction dir) {
        return dir == Direction.DOWN && !fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    public static class Source
    extends FakeWaterFluid {
        public int func_207192_d(FluidState p_207192_1_) {
            return 8;
        }

        public boolean func_207193_c(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FakeWaterFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        public int func_207192_d(FluidState p_207192_1_) {
            return (Integer)p_207192_1_.func_177229_b((Property)field_207210_b);
        }

        public boolean func_207193_c(FluidState state) {
            return false;
        }
    }
}

