/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.TrophySystemTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;

public class TrophySystemScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/blank.png");
    private final TranslationTextComponent projectiles = Utils.localize("gui.securitycraft:trophy_system.targetableProjectiles", new Object[0]);
    private final TranslationTextComponent moduleRequired = Utils.localize("gui.securitycraft:trophy_system.moduleRequired", new Object[0]);
    private final TranslationTextComponent toggle = Utils.localize("gui.securitycraft:trophy_system.toggle", new Object[0]);
    private final TranslationTextComponent moddedProjectiles = Utils.localize("gui.securitycraft:trophy_system.moddedProjectiles", new Object[0]);
    private final boolean isSmart;
    private final List<EntityType<?>> orderedFilterList;
    private TrophySystemTileEntity tileEntity;
    private ProjectileScrollList projectileList;

    public TrophySystemScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = (TrophySystemTileEntity)container.te;
        this.isSmart = this.tileEntity.hasModule(ModuleType.SMART);
        this.orderedFilterList = new ArrayList(this.tileEntity.getFilters().keySet());
        this.orderedFilterList.sort((e1, e2) -> {
            if (e1 == EntityType.field_200784_X) {
                return 1;
            }
            if (e2 == EntityType.field_200784_X) {
                return -1;
            }
            return e1.func_212546_e().getString().compareTo(e2.func_212546_e().getString());
        });
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.projectileList = new ProjectileScrollList(this.field_230706_i_, this.field_146999_f - 24, this.field_147000_g - 60, this.field_147009_r + 40, this.field_147003_i + 12);
        this.field_230705_e_.add(this.projectileList);
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, this.field_230704_d_, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2), (float)this.field_238743_q_, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.projectiles, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.projectiles) / 2), (float)(this.field_238743_q_ + 25), 0x404040);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (this.projectileList != null) {
            this.projectileList.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
        ClientUtils.renderModuleInfo(matrix, ModuleType.SMART, (ITextComponent)this.toggle, (ITextComponent)this.moduleRequired, this.isSmart, this.field_147003_i + 5, this.field_147009_r + 5, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.projectileList != null) {
            this.projectileList.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    class ProjectileScrollList
    extends ScrollPanel {
        private final int slotHeight = 12;
        private final int listLength;

        public ProjectileScrollList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.slotHeight = 12;
            this.listLength = TrophySystemScreen.this.orderedFilterList.size();
        }

        protected int getContentHeight() {
            TrophySystemScreen.this.field_230712_o_.getClass();
            int height = 50 + this.listLength * 9;
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        protected boolean clickPanel(double mouseX, double mouseY, int button) {
            int slotIndex = (int)(mouseY + 2.0) / 12;
            if (TrophySystemScreen.this.isSmart && slotIndex >= 0 && mouseY >= 0.0 && slotIndex < this.listLength) {
                TrophySystemScreen.this.tileEntity.toggleFilter((EntityType)TrophySystemScreen.this.orderedFilterList.get(slotIndex));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return true;
            }
            return false;
        }

        protected void drawPanel(MatrixStack matrix, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            int baseY = this.top + 4 - (int)this.scrollDistance;
            int slotBuffer = 8;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 2.0f);
            int slotIndex = mouseListY / 12;
            if (TrophySystemScreen.this.isSmart && mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                int min = this.left;
                int max = entryRight - 6;
                int slotTop = baseY + slotIndex * 12;
                BufferBuilder bufferBuilder = tess.func_178180_c();
                RenderSystem.enableBlend();
                RenderSystem.disableTexture();
                RenderSystem.defaultBlendFunc();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                bufferBuilder.func_225582_a_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferBuilder.func_225582_a_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferBuilder.func_225582_a_((double)max, (double)(slotTop - 2), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferBuilder.func_225582_a_((double)min, (double)(slotTop - 2), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferBuilder.func_225582_a_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferBuilder.func_225582_a_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferBuilder.func_225582_a_((double)(max - 1), (double)(slotTop - 1), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferBuilder.func_225582_a_((double)(min + 1), (double)(slotTop - 1), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferBuilder.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
                RenderSystem.enableTexture();
                RenderSystem.disableBlend();
            }
            int i = 0;
            for (EntityType projectileType : TrophySystemScreen.this.orderedFilterList) {
                ITextComponent projectileName = projectileType == EntityType.field_200784_X ? TrophySystemScreen.this.moddedProjectiles : projectileType.func_212546_e();
                int yStart = relativeY + 12 * i;
                TrophySystemScreen.this.field_230712_o_.func_243248_b(matrix, projectileName, (float)(this.left + this.width / 2 - TrophySystemScreen.this.field_230712_o_.func_238414_a_((ITextProperties)projectileName) / 2), (float)yStart, 0xC6C6C6);
                TrophySystemScreen.this.field_230706_i_.func_110434_K().func_110577_a(BEACON_GUI);
                ProjectileScrollList.func_238466_a_((MatrixStack)matrix, (int)this.left, (int)(yStart - 3), (int)14, (int)14, (float)(TrophySystemScreen.this.tileEntity.getFilter(projectileType) ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)256, (int)256);
                ++i;
            }
        }
    }
}

