/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class BlockUtils {
    private static final LazyOptional<IItemHandler> EMPTY_INVENTORY = LazyOptional.of(() -> new EmptyHandler());

    public static boolean isSideSolid(IWorldReader world, BlockPos pos, Direction side) {
        return world.func_180495_p(pos).func_224755_d((IBlockReader)world, pos, side);
    }

    public static void updateAndNotify(World world, BlockPos pos, Block block, int delay, boolean shouldUpdate) {
        if (shouldUpdate) {
            world.func_205220_G_().func_205360_a(pos, (Object)block, delay);
        }
        world.func_195593_d(pos, block);
    }

    public static int[] posToIntArray(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    public static Explosion.Mode getExplosionMode() {
        return (Boolean)ConfigHandler.SERVER.mineExplosionsBreakBlocks.get() != false ? Explosion.Mode.BREAK : Explosion.Mode.NONE;
    }

    public static boolean hasActiveSCBlockNextTo(World world, BlockPos pos) {
        return SecurityCraftAPI.getRegisteredDoorActivators().stream().anyMatch(activator -> BlockUtils.hasActiveSCBlockNextTo(world, pos, world.func_175625_s(pos), activator));
    }

    private static boolean hasActiveSCBlockNextTo(World world, BlockPos pos, TileEntity te, IDoorActivator activator) {
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.func_177972_a(dir);
            BlockState offsetState = world.func_180495_p(offsetPos);
            if (activator.getBlocks().contains(offsetState.func_177230_c())) {
                TileEntity offsetTe = world.func_175625_s(offsetPos);
                return activator.isPowering(world, offsetPos, offsetState, offsetTe) && (!(offsetTe instanceof IOwnable) || ((IOwnable)offsetTe).getOwner().owns((IOwnable)te));
            }
            if (world.func_175651_c(offsetPos, dir) != 15 || offsetState.func_185897_m()) continue;
            for (Direction dirOffset : Direction.values()) {
                TileEntity offsetTe;
                if (dirOffset.func_176734_d() == dir) continue;
                BlockPos newOffsetPos = offsetPos.func_177972_a(dirOffset);
                offsetState = world.func_180495_p(newOffsetPos);
                if (!activator.getBlocks().contains(offsetState.func_177230_c())) continue;
                if (offsetState.func_235901_b_((Property)BlockStateProperties.field_208158_K) && offsetState.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                    Direction.Axis offsetAxis = dirOffset.func_176740_k();
                    Direction offsetFacing = (Direction)offsetState.func_177229_b((Property)BlockStateProperties.field_208157_J);
                    AttachFace offsetAttachFace = (AttachFace)offsetState.func_177229_b((Property)BlockStateProperties.field_208158_K);
                    switch (offsetAxis) {
                        case X: 
                        case Z: {
                            if (offsetAttachFace == AttachFace.WALL && dirOffset == offsetFacing) break;
                            return false;
                        }
                        case Y: {
                            if ((dirOffset != Direction.UP || offsetAttachFace == AttachFace.FLOOR) && (dirOffset != Direction.DOWN || offsetAttachFace == AttachFace.CEILING)) break;
                            return false;
                        }
                    }
                }
                return activator.isPowering(world, newOffsetPos, offsetState, offsetTe = world.func_175625_s(newOffsetPos)) && (!(offsetTe instanceof IOwnable) || ((IOwnable)offsetTe).getOwner().owns((IOwnable)te));
            }
        }
        return false;
    }

    public static LazyOptional<?> getProtectedCapability(Direction side, TileEntity te, Supplier<LazyOptional<?>> extractionPermittedHandler, Supplier<LazyOptional<?>> insertOnlyHandler) {
        if (side == null) {
            return EMPTY_INVENTORY;
        }
        BlockPos offsetPos = te.func_174877_v().func_177972_a(side);
        BlockState offsetState = te.func_145831_w().func_180495_p(offsetPos);
        for (IExtractionBlock extractionBlock : SecurityCraftAPI.getRegisteredExtractionBlocks()) {
            if (offsetState.func_177230_c() != extractionBlock.getBlock()) continue;
            if (!extractionBlock.canExtract((IOwnable)te, te.func_145831_w(), offsetPos, offsetState)) {
                return EMPTY_INVENTORY;
            }
            return extractionPermittedHandler.get();
        }
        return insertOnlyHandler.get();
    }
}

