/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.entity.SecurityCameraEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerUtils {
    public static PlayerEntity getPlayerFromName(String name) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            List players = Minecraft.func_71410_x().field_71441_e.func_217369_A();
            for (PlayerEntity tempPlayer : players) {
                if (!tempPlayer.func_200200_C_().getString().equals(name)) continue;
                return tempPlayer;
            }
            return null;
        }
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (PlayerEntity tempPlayer : players) {
            if (!tempPlayer.func_200200_C_().getString().equals(name)) continue;
            return tempPlayer;
        }
        return null;
    }

    public static boolean isPlayerOnline(String name) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            for (AbstractClientPlayerEntity player : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
                if (player == null || !player.func_200200_C_().getString().equals(name)) continue;
                return true;
            }
            return false;
        }
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(name) != null;
    }

    public static void sendMessageToPlayer(String playerName, IFormattableTextComponent prefix, IFormattableTextComponent text, TextFormatting color) {
        PlayerEntity player = PlayerUtils.getPlayerFromName(playerName);
        if (player != null) {
            PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
        }
    }

    public static void sendMessageToPlayer(PlayerEntity player, IFormattableTextComponent prefix, IFormattableTextComponent text, TextFormatting color) {
        PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
    }

    public static void sendMessageToPlayer(PlayerEntity player, IFormattableTextComponent prefix, IFormattableTextComponent text, TextFormatting color, boolean shouldSendFromClient) {
        if (player.field_70170_p.field_72995_K == shouldSendFromClient) {
            player.func_145747_a((ITextComponent)new StringTextComponent("[").func_230529_a_((ITextComponent)prefix.func_230530_a_(Style.field_240709_b_.func_240712_a_(color))).func_230529_a_((ITextComponent)new StringTextComponent("] ")).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)text), Util.field_240973_b_);
        }
    }

    public static void sendMessageEndingWithLink(ICommandSource sender, IFormattableTextComponent prefix, IFormattableTextComponent text, String link, TextFormatting color) {
        sender.func_145747_a((ITextComponent)new StringTextComponent("[").func_230529_a_((ITextComponent)prefix.func_230530_a_(Style.field_240709_b_.func_240712_a_(color))).func_230529_a_((ITextComponent)new StringTextComponent("] ")).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)text).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(ForgeHooks.newChatWithLinks((String)link)), Util.field_240973_b_);
    }

    public static boolean isHoldingItem(PlayerEntity player, Supplier<Item> item, Hand hand) {
        return PlayerUtils.isHoldingItem(player, item.get(), hand);
    }

    public static boolean isHoldingItem(PlayerEntity player, Item item, Hand hand) {
        if (hand != Hand.OFF_HAND && !player.func_184586_b(Hand.MAIN_HAND).func_190926_b() && player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == item) {
            return true;
        }
        if (hand != Hand.MAIN_HAND && !player.func_184586_b(Hand.OFF_HAND).func_190926_b() && player.func_184586_b(Hand.OFF_HAND).func_77973_b() == item) {
            return true;
        }
        return item == null;
    }

    public static ItemStack getSelectedItemStack(PlayerEntity player, Item item) {
        return PlayerUtils.getSelectedItemStack(player.field_71071_by, item);
    }

    public static ItemStack getSelectedItemStack(PlayerInventory inventory, Item item) {
        if (!inventory.func_70448_g().func_190926_b() && inventory.func_70448_g().func_77973_b() == item) {
            return inventory.func_70448_g();
        }
        if (!((ItemStack)inventory.field_184439_c.get(0)).func_190926_b() && ((ItemStack)inventory.field_184439_c.get(0)).func_77973_b() == item) {
            return (ItemStack)inventory.field_184439_c.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isPlayerMountedOnCamera(LivingEntity entity) {
        return entity != null && entity.func_184187_bx() instanceof SecurityCameraEntity;
    }
}

