/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.event;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.ClientProxy;
import com.github.alexthe666.alexsmobs.client.model.ModelWanderingVillagerRider;
import com.github.alexthe666.alexsmobs.client.render.AMItemstackRenderer;
import com.github.alexthe666.alexsmobs.client.render.LavaVisionFluidRenderer;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBaldEagle;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.message.MessageUpdateEagleControls;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.client.event.EventGetOutlineColor;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ResourceLocation RADIUS_TEXTURE = new ResourceLocation("alexsmobs:textures/falconry_radius.png");
    private boolean previousLavaVision = false;
    private FluidBlockRenderer previousFluidRenderer;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onOutlineEntityColor(EventGetOutlineColor event) {
        if (event.getEntityIn() instanceof ItemEntity && ItemTags.func_199903_a().func_199910_a(AMTagRegistry.VOID_WORM_DROPS).func_230235_a_((Object)((ItemEntity)event.getEntityIn()).func_92059_d().func_77973_b())) {
            int fromColor = 0;
            int toColor = 2221567;
            float startR = (float)(fromColor >> 16 & 0xFF) / 255.0f;
            float startG = (float)(fromColor >> 8 & 0xFF) / 255.0f;
            float startB = (float)(fromColor & 0xFF) / 255.0f;
            float endR = (float)(toColor >> 16 & 0xFF) / 255.0f;
            float endG = (float)(toColor >> 8 & 0xFF) / 255.0f;
            float endB = (float)(toColor & 0xFF) / 255.0f;
            float f = (float)(Math.cos(0.4f * ((float)event.getEntityIn().field_70173_aa + Minecraft.func_71410_x().func_184121_ak())) + 1.0) * 0.5f;
            float r = (endR - startR) * f + startR;
            float g = (endG - startG) * f + startG;
            float b = (endB - startB) * f + startB;
            int j = ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | ((int)(b * 255.0f) & 0xFF) << 0;
            event.setColor(j);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        FluidState fluidstate = event.getInfo().func_216771_k();
        if (Minecraft.func_71410_x().field_71439_g.func_70644_a(AMEffectRegistry.LAVA_VISION) && fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
            event.setDensity(0.05f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPreRenderEntity(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof WanderingTraderEntity && event.getEntity().func_184187_bx() instanceof EntityElephant && !(event.getRenderer().field_77045_g instanceof ModelWanderingVillagerRider)) {
            event.getRenderer().field_77045_g = new ModelWanderingVillagerRider();
        }
        if (event.getEntity().func_70644_a(AMEffectRegistry.CLINGING) && event.getEntity().func_70047_e() < event.getEntity().func_213302_cg() * 0.45f || event.getEntity().func_70644_a(AMEffectRegistry.DEBILITATING_STING) && event.getEntity().func_70668_bt() == CreatureAttribute.field_223224_c_ && event.getEntity().func_213311_cf() > event.getEntity().func_213302_cg()) {
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227861_a_(0.0, (double)(event.getEntity().func_213302_cg() + 0.1f), 0.0);
            event.getMatrixStack().func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            event.getEntity().field_70760_ar = -event.getEntity().field_70760_ar;
            event.getEntity().field_70761_aq = -event.getEntity().field_70761_aq;
            event.getEntity().field_70758_at = -event.getEntity().field_70758_at;
            event.getEntity().field_70759_as = -event.getEntity().field_70759_as;
        }
        if (event.getEntity().func_70644_a(AMEffectRegistry.ENDER_FLU)) {
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(Math.cos((double)event.getEntity().field_70173_aa * 7.0) * Math.PI * (double)1.2f)));
            float vibrate = 0.05f;
            event.getMatrixStack().func_227861_a_((double)((event.getEntity().func_70681_au().nextFloat() - 0.5f) * vibrate), (double)((event.getEntity().func_70681_au().nextFloat() - 0.5f) * vibrate), (double)((event.getEntity().func_70681_au().nextFloat() - 0.5f) * vibrate));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPostRenderEntity(RenderLivingEvent.Post event) {
        if (event.getEntity().func_70644_a(AMEffectRegistry.ENDER_FLU)) {
            event.getMatrixStack().func_227865_b_();
        }
        if (event.getEntity().func_70644_a(AMEffectRegistry.CLINGING) && event.getEntity().func_70047_e() < event.getEntity().func_213302_cg() * 0.45f || event.getEntity().func_70644_a(AMEffectRegistry.DEBILITATING_STING) && event.getEntity().func_70668_bt() == CreatureAttribute.field_223224_c_ && event.getEntity().func_213311_cf() > event.getEntity().func_213302_cg()) {
            event.getMatrixStack().func_227865_b_();
            event.getEntity().field_70760_ar = -event.getEntity().field_70760_ar;
            event.getEntity().field_70761_aq = -event.getEntity().field_70761_aq;
            event.getEntity().field_70758_at = -event.getEntity().field_70758_at;
            event.getEntity().field_70759_as = -event.getEntity().field_70759_as;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderHand(RenderHandEvent event) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityBaldEagle) {
            event.setCanceled(true);
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_184188_bt().isEmpty() && event.getHand() == Hand.MAIN_HAND) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            boolean leftHand = false;
            if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == AMItemRegistry.FALCONRY_GLOVE) {
                leftHand = player.func_184591_cq() == HandSide.LEFT;
            } else if (player.func_184586_b(Hand.OFF_HAND).func_77973_b() == AMItemRegistry.FALCONRY_GLOVE) {
                leftHand = player.func_184591_cq() != HandSide.LEFT;
            }
            for (Entity entity : player.func_184188_bt()) {
                if (!(entity instanceof EntityBaldEagle)) continue;
                float yaw = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * event.getPartialTicks();
                ClientProxy.currentUnrenderedEntities.remove(entity.func_110124_au());
                MatrixStack matrixStackIn = event.getMatrixStack();
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
                matrixStackIn.func_227861_a_(leftHand ? (double)-0.8f : (double)0.8f, (double)-0.6f, -1.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw));
                if (leftHand) {
                    matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                } else {
                    matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
                }
                this.renderEntity(entity, 0.0, 0.0, 0.0, 0.0f, event.getPartialTicks(), matrixStackIn, event.getBuffers(), event.getLight());
                matrixStackIn.func_227865_b_();
                ClientProxy.currentUnrenderedEntities.add(entity.func_110124_au());
            }
        }
        if (Minecraft.func_71410_x().field_71439_g.func_184607_cu().func_77973_b() == AMItemRegistry.DIMENSIONAL_CARVER && event.getItemStack().func_77973_b() == AMItemRegistry.DIMENSIONAL_CARVER) {
            MatrixStack matrixStackIn = event.getMatrixStack();
            matrixStackIn.func_227860_a_();
            FirstPersonRenderer renderer = Minecraft.func_71410_x().func_175597_ag();
            Hand hand = (Hand)MoreObjects.firstNonNull((Object)Minecraft.func_71410_x().field_71439_g.field_184622_au, (Object)Hand.MAIN_HAND);
            float f = Minecraft.func_71410_x().field_71439_g.func_70678_g(event.getPartialTicks());
            float f1 = MathHelper.func_219799_g((float)event.getPartialTicks(), (float)Minecraft.func_71410_x().field_71439_g.field_70127_C, (float)Minecraft.func_71410_x().field_71439_g.field_70125_A);
            float f5 = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * (float)Math.PI));
            float f6 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * ((float)Math.PI * 2)));
            float f10 = -0.2f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
            HandSide handside = hand == Hand.MAIN_HAND ? Minecraft.func_71410_x().field_71439_g.func_184591_cq() : Minecraft.func_71410_x().field_71439_g.func_184591_cq().func_188468_a();
            boolean flag3 = handside == HandSide.RIGHT;
            int l = flag3 ? 1 : -1;
            matrixStackIn.func_227861_a_((double)((float)l * f5), (double)f6, (double)f10);
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, double x, double y, double z, float yaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
            try {
                render = manager.func_78713_a(entityIn);
                if (render == null) break block4;
                try {
                    render.func_225623_a_(entityIn, yaw, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being rendered");
                entityIn.func_85029_a(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Renderer details");
                crashreportcategory1.func_71507_a("Assigned renderer", (Object)render);
                crashreportcategory1.func_71507_a("Location", (Object)CrashReportCategory.func_85074_a((double)x, (double)y, (double)z));
                crashreportcategory1.func_71507_a("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.func_71507_a("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderNameplate(RenderNameplateEvent event) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityBaldEagle && event.getEntity() == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().func_71356_B()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        AMItemstackRenderer.incrementTick();
        if (!AMConfig.shadersCompat) {
            RenderType lavaType;
            if (Minecraft.func_71410_x().field_71439_g.func_70644_a(AMEffectRegistry.LAVA_VISION)) {
                if (!this.previousLavaVision) {
                    lavaType = RenderType.func_228645_f_();
                    RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_204547_b, (RenderType)lavaType);
                    RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_207213_d, (RenderType)lavaType);
                    this.previousFluidRenderer = Minecraft.func_71410_x().func_175602_ab().field_175025_e;
                    Minecraft.func_71410_x().func_175602_ab().field_175025_e = new LavaVisionFluidRenderer();
                    this.updateAllChunks();
                }
            } else if (this.previousLavaVision) {
                if (this.previousFluidRenderer != null) {
                    lavaType = RenderType.func_228639_c_();
                    RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_204547_b, (RenderType)lavaType);
                    RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_207213_d, (RenderType)lavaType);
                    Minecraft.func_71410_x().func_175602_ab().field_175025_e = this.previousFluidRenderer;
                }
                this.updateAllChunks();
            }
            this.previousLavaVision = Minecraft.func_71410_x().field_71439_g.func_70644_a(AMEffectRegistry.LAVA_VISION);
            if (AMConfig.clingingFlipEffect) {
                if (Minecraft.func_71410_x().field_71439_g.func_70644_a(AMEffectRegistry.CLINGING) && Minecraft.func_71410_x().field_71439_g.func_70047_e() < Minecraft.func_71410_x().field_71439_g.func_213302_cg() * 0.45f) {
                    Minecraft.func_71410_x().field_71460_t.func_175069_a(new ResourceLocation("shaders/post/flip.json"));
                } else if (Minecraft.func_71410_x().field_71460_t.func_147706_e() != null && Minecraft.func_71410_x().field_71460_t.func_147706_e().func_148022_b().equals("minecraft:shaders/post/flip.json")) {
                    Minecraft.func_71410_x().field_71460_t.func_181022_b();
                }
            }
        }
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityBaldEagle) {
            EntityBaldEagle eagle = (EntityBaldEagle)Minecraft.func_71410_x().func_175606_aa();
            ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
            if (((EntityBaldEagle)Minecraft.func_71410_x().func_175606_aa()).shouldHoodedReturn() || eagle.field_70128_L) {
                Minecraft.func_71410_x().func_175607_a((Entity)playerEntity);
                Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.values()[AlexsMobs.PROXY.getPreviousPOV()]);
            } else {
                float rotX = MathHelper.func_76142_g((float)(playerEntity.field_70177_z + playerEntity.field_70759_as));
                float rotY = playerEntity.field_70125_A;
                Entity over = null;
                if (Minecraft.func_71410_x().field_71476_x instanceof EntityRayTraceResult) {
                    over = ((EntityRayTraceResult)Minecraft.func_71410_x().field_71476_x).func_216348_a();
                } else {
                    Minecraft.func_71410_x().field_71476_x = null;
                }
                boolean loadChunks = playerEntity.field_70170_p.func_72820_D() % 10L == 0L;
                ((EntityBaldEagle)Minecraft.func_71410_x().func_175606_aa()).directFromPlayer(rotX, rotY, false, over);
                AlexsMobs.NETWORK_WRAPPER.sendToServer((Object)new MessageUpdateEagleControls(Minecraft.func_71410_x().func_175606_aa().func_145782_y(), rotX, rotY, loadChunks, over == null ? -1 : over.func_145782_y()));
            }
        }
    }

    private void updateAllChunks() {
        if (Minecraft.func_71410_x().field_71438_f.field_175008_n != null) {
            int length = Minecraft.func_71410_x().field_71438_f.field_175008_n.field_178164_f.length;
            for (int i = 0; i < length; ++i) {
                Minecraft.func_71410_x().field_71438_f.field_175008_n.field_178164_f[i].field_178593_n = true;
            }
        }
    }
}

