/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCentipedeBody;
import com.github.alexthe666.alexsmobs.entity.EntityCockroach;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityCentipedeHead
extends MonsterEntity {
    private static final DataParameter<Optional<UUID>> CHILD_UUID = EntityDataManager.func_187226_a(EntityCentipedeHead.class, (IDataSerializer)DataSerializers.field_187203_m);

    protected EntityCentipedeHead(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 3.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.caveCentipedeSpawnRolls, this.func_70681_au(), spawnReasonIn) && super.func_213380_a(worldIn, spawnReasonIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 13, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 20, true, true, null));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, 20, true, true, null));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EntityCockroach.class, 45, true, true, null));
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.CENTIPEDE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.CENTIPEDE_HURT;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 35.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233826_i_, 6.0).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.5).func_233815_a_(Attributes.field_233821_d_, (double)0.22f);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(AMSoundRegistry.CENTIPEDE_WALK, 1.0f, 1.0f);
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public int func_213396_dB() {
        return 1;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHILD_UUID, Optional.empty());
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 3;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 20;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, i * 20, 1));
                }
            }
            this.func_184185_a(AMSoundRegistry.CENTIPEDE_ATTACK, this.func_70599_aP(), this.func_70647_i());
            return true;
        }
        return false;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.field_70180_af.func_187225_a(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    public void func_85033_bc() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        entities.stream().filter(entity -> !(entity instanceof EntityCentipedeBody) && entity.func_70104_M()).forEach(entity -> entity.func_70108_f((Entity)this));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getChildId() != null) {
            compound.func_186854_a("ChildUUID", this.getChildId());
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || super.func_180431_b(source);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("ChildUUID")) {
            this.setChildId(compound.func_186857_a("ChildUUID"));
        }
    }

    public void func_70071_h_() {
        Entity child;
        super.func_70071_h_();
        this.field_71087_bX = false;
        this.field_70177_z = this.field_70761_aq;
        if (!this.field_70170_p.field_72995_K && (child = this.getChild()) == null) {
            Object partParent = this;
            int segments = 5 + this.func_70681_au().nextInt(3);
            for (int i = 0; i < segments; ++i) {
                EntityCentipedeBody part = this.createBody((LivingEntity)partParent, i == segments - 1);
                part.setParent((Entity)partParent);
                part.setBodyIndex(i);
                if (partParent == this) {
                    this.setChildId(part.func_110124_au());
                }
                part.setInitialPartPos((LivingEntity)this, i + 1);
                this.field_70170_p.func_217376_c((Entity)part);
                partParent = part;
            }
        }
    }

    public EntityCentipedeBody createBody(LivingEntity parent, boolean tail) {
        return tail ? new EntityCentipedeBody(AMEntityRegistry.CENTIPEDE_TAIL, parent, 0.84f, 180.0f, 0.0f) : new EntityCentipedeBody(AMEntityRegistry.CENTIPEDE_BODY, parent, 0.84f, 180.0f, 0.0f);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    public static <T extends MobEntity> boolean canCentipedeSpawn(EntityType<EntityCentipedeHead> entityType, IServerWorld iServerWorld, SpawnReason reason, BlockPos pos, Random random) {
        return reason == SpawnReason.SPAWNER || !iServerWorld.func_226660_f_(pos) && pos.func_177956_o() <= AMConfig.caveCentipedeSpawnHeight && EntityCentipedeHead.func_223325_c(entityType, (IServerWorld)iServerWorld, (SpawnReason)reason, (BlockPos)pos, (Random)random);
    }
}

