/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.ElephantAIFollowCaravan;
import com.github.alexthe666.alexsmobs.entity.ai.ElephantAIForageLeaves;
import com.github.alexthe666.alexsmobs.entity.ai.ElephantAIVillagerRide;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIRide;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityElephant
extends TameableEntity
implements ITargetsDroppedItems,
IAnimatedEntity {
    public static final Animation ANIMATION_TRUMPET_0 = Animation.create((int)20);
    public static final Animation ANIMATION_TRUMPET_1 = Animation.create((int)30);
    public static final Animation ANIMATION_CHARGE_PREPARE = Animation.create((int)25);
    public static final Animation ANIMATION_STOMP = Animation.create((int)20);
    public static final Animation ANIMATION_FLING = Animation.create((int)25);
    public static final Animation ANIMATION_EAT = Animation.create((int)30);
    public static final Animation ANIMATION_BREAKLEAVES = Animation.create((int)20);
    protected static final EntitySize TUSKED_SIZE = EntitySize.func_220311_c((float)2.3f, (float)2.75f);
    private static final DataParameter<Boolean> TUSKED = EntityDataManager.func_187226_a(EntityElephant.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityElephant.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> STANDING = EntityDataManager.func_187226_a(EntityElephant.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(EntityElephant.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CARPET_COLOR = EntityDataManager.func_187226_a(EntityElephant.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> TRADER = EntityDataManager.func_187226_a(EntityElephant.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Map<DyeColor, Item> DYE_COLOR_ITEM_MAP = (Map)Util.func_200696_a((Object)Maps.newHashMap(), map -> {
        map.put(DyeColor.WHITE, Items.field_221809_eO);
        map.put(DyeColor.ORANGE, Items.field_221811_eP);
        map.put(DyeColor.MAGENTA, Items.field_221813_eQ);
        map.put(DyeColor.LIGHT_BLUE, Items.field_221815_eR);
        map.put(DyeColor.YELLOW, Items.field_221817_eS);
        map.put(DyeColor.LIME, Items.field_221819_eT);
        map.put(DyeColor.PINK, Items.field_221821_eU);
        map.put(DyeColor.GRAY, Items.field_221823_eV);
        map.put(DyeColor.LIGHT_GRAY, Items.field_221825_eW);
        map.put(DyeColor.CYAN, Items.field_221827_eX);
        map.put(DyeColor.PURPLE, Items.field_221829_eY);
        map.put(DyeColor.BLUE, Items.field_221831_eZ);
        map.put(DyeColor.BROWN, Items.field_221886_fa);
        map.put(DyeColor.GREEN, Items.field_221888_fb);
        map.put(DyeColor.RED, Items.field_221890_fc);
        map.put(DyeColor.BLACK, Items.field_221892_fd);
    });
    private static final ResourceLocation TRADER_LOOT = new ResourceLocation("alexsmobs", "gameplay/trader_elephant_chest");
    public boolean forcedSit = false;
    public float prevSitProgress;
    public float sitProgress;
    public float prevStandProgress;
    public float standProgress;
    public int maxStandTime = 75;
    public boolean aiItemFlag = false;
    public Inventory elephantInventory;
    private int animationTick;
    private Animation currentAnimation;
    private boolean hasTuskedAttributes = false;
    private int standingTime = 0;
    @Nullable
    private EntityElephant caravanHead;
    @Nullable
    private EntityElephant caravanTail;
    private boolean hasChestVarChanged = false;
    private boolean hasChargedSpeed = false;
    private boolean charging;
    private int chargeCooldown = 0;
    private int chargingTicks = 0;
    @Nullable
    private UUID blossomThrowerUUID = null;
    private int despawnDelay = 47999;

    protected EntityElephant(EntityType type, World world) {
        super(type, world);
        this.initElephantInventory();
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 65.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233820_c_, (double)0.9f).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f);
    }

    @Nullable
    public static DyeColor getCarpetColor(ItemStack stack) {
        Block lvt_1_1_ = Block.func_149634_a((Item)stack.func_77973_b());
        return lvt_1_1_ instanceof CarpetBlock ? ((CarpetBlock)lvt_1_1_).func_196547_d() : null;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.ELEPHANT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.ELEPHANT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.ELEPHANT_DIE;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.elephantSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    private void initElephantInventory() {
        Inventory animalchest = this.elephantInventory;
        this.elephantInventory = new Inventory(54);
        if (animalchest != null) {
            int i = Math.min(animalchest.func_70302_i_(), this.elephantInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.elephantInventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundPathNavigatorWide((MobEntity)this, worldIn);
    }

    public int func_184649_cE() {
        return super.func_184649_cE();
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.isSitting() || this.getAnimation() == ANIMATION_CHARGE_PREPARE && this.getAnimationTick() < 10;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TameableAIRide((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new ElephantAIVillagerRide(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{AMItemRegistry.ACACIA_BLOSSOM}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new ElephantAIForageLeaves(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new ElephantAIFollowCaravan(this, 0.5));
        this.field_70714_bg.func_75776_a(8, (Goal)new AvoidEntityGoal((CreatureEntity)this, BeeEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(9, (Goal)new AIWalkIdle(this, 0.5));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal().func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, new CreatureAITargetItems((CreatureEntity)this, false));
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.func_70909_n() && item == AMItemRegistry.ACACIA_BLOSSOM;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        if (!this.func_70631_g_()) {
            this.func_184185_a(AMSoundRegistry.ELEPHANT_WALK, 0.2f, 1.0f);
        } else {
            super.func_180429_a(pos, state);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity)) continue;
            return passenger;
        }
        return null;
    }

    @Nullable
    public AbstractVillagerEntity getControllingVillager() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof AbstractVillagerEntity)) continue;
            return (AbstractVillagerEntity)passenger;
        }
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TUSKED, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(STANDING, (Object)false);
        this.field_70180_af.func_187214_a(CHESTED, (Object)false);
        this.field_70180_af.func_187214_a(TRADER, (Object)false);
        this.field_70180_af.func_187214_a(CARPET_COLOR, (Object)-1);
    }

    public void func_70071_h_() {
        PlayerEntity rider;
        super.func_70071_h_();
        this.prevSitProgress = this.sitProgress;
        this.prevStandProgress = this.standProgress;
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding() && this.standProgress < 5.0f) {
            this.standProgress += 0.5f;
        }
        if (!this.isStanding() && this.standProgress > 0.0f) {
            this.standProgress -= 0.5f;
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (this.isSitting() && this.isStanding()) {
            this.setStanding(false);
        }
        if (this.hasChestVarChanged && this.elephantInventory != null && !this.isChested()) {
            for (int i = 3; i < 18; ++i) {
                if (this.elephantInventory.func_70301_a(i).func_190926_b()) continue;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.elephantInventory.func_70301_a(i), 1.0f);
                }
                this.elephantInventory.func_70304_b(i);
            }
            this.hasChestVarChanged = false;
        }
        if (this.isTusked() && !this.func_70631_g_() && !this.hasTuskedAttributes) {
            this.func_213323_x_();
        }
        if (!this.isTusked() && !this.func_70631_g_() && this.hasTuskedAttributes) {
            this.func_213323_x_();
        }
        if (this.charging) {
            ++this.chargingTicks;
        }
        if (!this.func_184614_ca().func_190926_b() && this.canTargetItem(this.func_184614_ca())) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_EAT);
            }
            if (this.getAnimation() == ANIMATION_EAT && this.getAnimationTick() == 17) {
                this.eatItemEffect(this.func_184614_ca());
                if (!(this.func_184614_ca().func_77973_b() != AMItemRegistry.ACACIA_BLOSSOM || this.func_70909_n() || this.isTusked() && !this.func_70631_g_() || this.blossomThrowerUUID == null)) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.func_70903_f(true);
                        this.func_184754_b(this.blossomThrowerUUID);
                        PlayerEntity player = this.field_70170_p.func_217371_b(this.blossomThrowerUUID);
                        if (player != null) {
                            this.func_193101_c(player);
                        }
                        for (Entity passenger : this.func_184188_bt()) {
                            passenger.func_233575_bb_();
                        }
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                this.func_70691_i(10.0f);
            }
        }
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        this.chargingTicks = this.charging ? ++this.chargingTicks : 0;
        if (this.getAnimation() == ANIMATION_CHARGE_PREPARE) {
            this.field_70761_aq = this.field_70177_z;
            if (this.getAnimationTick() == 20) {
                this.charging = true;
            }
        }
        if (this.func_184179_bs() != null && this.charging && this.chargingTicks > 100) {
            this.charging = false;
            this.chargeCooldown = 200;
        }
        LivingEntity target = this.func_70638_az();
        double maxAttackMod = 0.0;
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity && (rider = (PlayerEntity)this.func_184179_bs()).func_110144_aD() != null && !this.func_184191_r((Entity)rider.func_110144_aD())) {
            UUID preyUUID = rider.func_110144_aD().func_110124_au();
            if (!this.func_110124_au().equals(preyUUID)) {
                target = rider.func_110144_aD();
                maxAttackMod = 4.0;
            }
        }
        if (!this.field_70170_p.field_72995_K && target != null) {
            double dist;
            if (this.func_70032_d((Entity)target) > 8.0f && this.func_184179_bs() == null && this.isTusked() && this.func_70685_l((Entity)target) && this.getAnimation() == NO_ANIMATION && !this.charging && this.chargeCooldown == 0) {
                this.setAnimation(ANIMATION_CHARGE_PREPARE);
            }
            if (this.getAnimation() == ANIMATION_CHARGE_PREPARE && this.func_184179_bs() == null) {
                this.func_70625_a((Entity)target, 360.0f, 30.0f);
                this.field_70761_aq = this.field_70177_z;
                if (this.getAnimationTick() == 20) {
                    this.charging = true;
                }
            }
            if ((double)this.func_70032_d((Entity)target) < 10.0 && this.charging) {
                this.setAnimation(ANIMATION_FLING);
            }
            if ((double)this.func_70032_d((Entity)target) < 2.1 && this.charging) {
                target.func_233627_a_(1.0f, target.func_226277_ct_() - this.func_226277_ct_(), target.func_226281_cx_() - this.func_226281_cx_());
                target.field_70160_al = true;
                target.func_213317_d(target.func_213322_ci().func_72441_c(0.0, (double)0.7f, 0.0));
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.4f * (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
                this.launch((Entity)target, true);
                this.charging = false;
                this.chargeCooldown = 400;
            }
            if ((dist = (double)this.func_70032_d((Entity)target)) < 4.5 + maxAttackMod && this.getAnimation() == ANIMATION_FLING && this.getAnimationTick() == 15) {
                target.func_233627_a_(1.0f, target.func_226277_ct_() - this.func_226277_ct_(), target.func_226281_cx_() - this.func_226281_cx_());
                target.func_213317_d(target.func_213322_ci().func_72441_c(0.0, (double)0.3f, 0.0));
                this.launch((Entity)target, false);
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
            }
            if (dist < 4.5 + maxAttackMod && this.getAnimation() == ANIMATION_STOMP && this.getAnimationTick() == 17) {
                target.func_233627_a_(0.3f, target.func_226277_ct_() - this.func_226277_ct_(), target.func_226281_cx_() - this.func_226281_cx_());
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.func_184179_bs() == null) {
            this.charging = false;
        }
        if (this.charging && !this.hasChargedSpeed) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.65f);
            this.hasChargedSpeed = true;
        }
        if (!this.charging && this.hasChargedSpeed) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.35f);
            this.hasChargedSpeed = false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(400) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_TRUMPET_0 : ANIMATION_TRUMPET_1);
        }
        if (this.getAnimation() == ANIMATION_TRUMPET_0 && this.getAnimationTick() == 8 || this.getAnimation() == ANIMATION_TRUMPET_1 && this.getAnimationTick() == 4) {
            this.func_184185_a(AMSoundRegistry.ELEPHANT_TRUMPET, this.func_70599_aP(), this.func_70647_i());
        }
        if (this.func_70089_S() && this.charging) {
            for (Entity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(1.0), null)) {
                if (this.func_70909_n() && this.func_184191_r(entity) || !this.func_70909_n() && entity instanceof EntityElephant || entity == this) continue;
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 8.0f + this.field_70146_Z.nextFloat() * 8.0f);
                this.launch(entity, true);
            }
            this.field_70138_W = 2.0f;
        }
        if (!this.func_70909_n() && this.isTrader() && !this.field_70170_p.field_72995_K) {
            this.tryDespawn();
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70631_g_() && this.func_70047_e() > this.func_213302_cg()) {
            this.func_213323_x_();
        }
    }

    private boolean canDespawn() {
        return !this.func_70909_n() && this.isTrader();
    }

    private void tryDespawn() {
        if (this.canDespawn()) {
            int riderDelay;
            if (this.getControllingVillager() instanceof WanderingTraderEntity && (riderDelay = ((WanderingTraderEntity)this.getControllingVillager()).func_213735_eg()) > 0) {
                this.despawnDelay = riderDelay;
            }
            --this.despawnDelay;
            if (this.despawnDelay <= 0) {
                this.func_110160_i(true, false);
                this.elephantInventory.func_174888_l();
                if (this.getControllingVillager() != null) {
                    this.getControllingVillager().func_70106_y();
                }
                this.func_70106_y();
            }
        }
    }

    private void launch(Entity e, boolean huge) {
        if (e.func_233570_aj_()) {
            double d0 = e.func_226277_ct_() - this.func_226277_ct_();
            double d1 = e.func_226281_cx_() - this.func_226281_cx_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = huge ? 2.0f : 0.5f;
            e.func_70024_g(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    private void eatItemEffect(ItemStack heldItemMainhand) {
        this.func_184185_a(SoundEvents.field_232840_oa_, this.func_70647_i(), this.func_70599_aP());
        for (int i = 0; i < 8 + this.field_70146_Z.nextInt(3); ++i) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            float radius = this.func_213311_cf() * 0.65f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            ItemParticleData data = new ItemParticleData(ParticleTypes.field_197591_B, heldItemMainhand);
            if (heldItemMainhand.func_77973_b() instanceof BlockItem) {
                data = new BlockParticleData(ParticleTypes.field_197611_d, ((BlockItem)heldItemMainhand.func_77973_b()).func_179223_d().func_176223_P());
            }
            this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + extraX, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.6f), this.func_226281_cx_() + extraZ, d0, d1, d2);
        }
    }

    private boolean isChargePlayer(Entity controllingPassenger) {
        return true;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION && !this.charging) {
            this.setAnimation(this.field_70146_Z.nextBoolean() ? ANIMATION_FLING : ANIMATION_STOMP);
        }
        return true;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean owner = this.func_70909_n() && this.func_152114_e((LivingEntity)player);
        ActionResultType type = super.func_230254_b_(player, hand);
        if (this.isChested() && player.func_225608_bj_()) {
            this.openGUI(player);
            return ActionResultType.SUCCESS;
        }
        if (this.canTargetItem(stack) && this.func_184614_ca().func_190926_b()) {
            ItemStack rippedStack = stack.func_77946_l();
            rippedStack.func_190920_e(1);
            stack.func_190918_g(1);
            this.func_184611_a(Hand.MAIN_HAND, rippedStack);
            if (rippedStack.func_77973_b() == AMItemRegistry.ACACIA_BLOSSOM) {
                this.blossomThrowerUUID = player.func_110124_au();
            }
            return ActionResultType.SUCCESS;
        }
        if (owner && ItemTags.field_200035_e.func_230235_a_((Object)stack.func_77973_b())) {
            DyeColor color = EntityElephant.getCarpetColor(stack.getStack());
            if (color != this.getColor()) {
                if (this.getColor() != null) {
                    this.func_199703_a((IItemProvider)this.getCarpetItemBeingWorn());
                }
                this.func_184185_a(SoundEvents.field_191257_dH, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                stack.func_190918_g(1);
                this.setColor(color);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (owner && this.getColor() != null && stack.func_77973_b() == Items.field_151097_aZ) {
            this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            if (this.getColor() != null) {
                this.func_199703_a((IItemProvider)this.getCarpetItemBeingWorn());
            }
            this.setColor(null);
            return ActionResultType.SUCCESS;
        }
        if (owner && !this.isChested() && ItemTags.func_199903_a().func_199910_a(AMTagRegistry.FORGE_WOODEN_CHESTS).func_230235_a_((Object)stack.func_77973_b())) {
            this.setChested(true);
            this.func_184185_a(SoundEvents.field_187584_ax, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (owner && this.isChested() && stack.func_77973_b() == Items.field_151097_aZ) {
            this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_199703_a((IItemProvider)Blocks.field_150486_ae);
            for (int i = 0; i < this.elephantInventory.func_70302_i_(); ++i) {
                this.func_199701_a_(this.elephantInventory.func_70301_a(i));
            }
            this.elephantInventory.func_174888_l();
            this.setChested(false);
            return ActionResultType.SUCCESS;
        }
        if (owner && !this.func_70631_g_() && type != ActionResultType.CONSUME) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isTusked() && !this.func_70631_g_() ? TUSKED_SIZE : super.func_213305_a(poseIn);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_TRUMPET_0, ANIMATION_TRUMPET_1, ANIMATION_CHARGE_PREPARE, ANIMATION_STOMP, ANIMATION_FLING, ANIMATION_EAT, ANIMATION_BREAKLEAVES};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Item getCarpetItemBeingWorn() {
        if (this.getColor() != null) {
            return DYE_COLOR_ITEM_MAP.get(this.getColor());
        }
        return Items.field_190931_a;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.isChested()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_199703_a((IItemProvider)Blocks.field_150486_ae);
            }
            for (int i = 0; i < this.elephantInventory.func_70302_i_(); ++i) {
                this.func_199701_a_(this.elephantInventory.func_70301_a(i));
            }
            this.elephantInventory.func_174888_l();
            this.setChested(false);
        }
        if (!this.isTrader() && this.getColor() != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_199703_a((IItemProvider)this.getCarpetItemBeingWorn());
            }
            this.setColor(null);
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        EntityElephant baby = (EntityElephant)AMEntityRegistry.ELEPHANT.func_200721_a((World)serverWorld);
        baby.setTusked(this.getNearestTusked((IWorld)this.field_70170_p, 15.0) == null || this.field_70146_Z.nextInt(2) == 0);
        return baby;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Tusked", this.isTusked());
        compound.func_74757_a("ElephantSitting", this.isSitting());
        compound.func_74757_a("Standing", this.isStanding());
        compound.func_74757_a("Chested", this.isChested());
        compound.func_74757_a("Trader", this.isTrader());
        compound.func_74757_a("ForcedToSit", this.forcedSit);
        compound.func_74757_a("Tamed", this.func_70909_n());
        compound.func_74768_a("ChargeCooldown", this.chargeCooldown);
        compound.func_74768_a("Carpet", ((Integer)this.field_70180_af.func_187225_a(CARPET_COLOR)).intValue());
        compound.func_74768_a("DespawnDelay", this.despawnDelay);
        if (this.elephantInventory != null) {
            ListNBT nbttaglist = new ListNBT();
            for (int i = 0; i < this.elephantInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.elephantInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT CompoundNBT2 = new CompoundNBT();
                CompoundNBT2.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(CompoundNBT2);
                nbttaglist.add((Object)CompoundNBT2);
            }
            compound.func_218657_a("Items", (INBT)nbttaglist);
        }
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_82731_v) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_70903_f(compound.func_74767_n("Tamed"));
        this.setTusked(compound.func_74767_n("Tusked"));
        this.setStanding(compound.func_74767_n("Standing"));
        this.func_233687_w_(compound.func_74767_n("ElephantSitting"));
        this.setChested(compound.func_74767_n("Chested"));
        this.setTrader(compound.func_74767_n("Trader"));
        this.forcedSit = compound.func_74767_n("ForcedToSit");
        this.chargeCooldown = compound.func_74762_e("ChargeCooldown");
        this.field_70180_af.func_187227_b(CARPET_COLOR, (Object)compound.func_74762_e("Carpet"));
        if (this.elephantInventory != null) {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initElephantInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT2 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT2.func_74771_c("Slot") & 0xFF;
                this.elephantInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT2));
            }
        } else {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initElephantInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT3 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT3.func_74771_c("Slot") & 0xFF;
                this.initElephantInventory();
                this.elephantInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT3));
            }
        }
        if (compound.func_150297_b("DespawnDelay", 99)) {
            this.despawnDelay = compound.func_74762_e("DespawnDelay");
        }
    }

    public boolean isChested() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    public void setChested(boolean chested) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    public boolean func_174820_d(int inventorySlot, @Nullable ItemStack itemStackIn) {
        int j = inventorySlot - 500 + 2;
        if (j >= 0 && j < this.elephantInventory.func_70302_i_()) {
            this.elephantInventory.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.elephantInventory != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.elephantInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.elephantInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(STANDING, (Object)standing);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void func_233687_w_(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    @Nullable
    public DyeColor getColor() {
        int lvt_1_1_ = (Integer)this.field_70180_af.func_187225_a(CARPET_COLOR);
        return lvt_1_1_ == -1 ? null : DyeColor.func_196056_a((int)lvt_1_1_);
    }

    public void setColor(@Nullable DyeColor color) {
        this.field_70180_af.func_187227_b(CARPET_COLOR, (Object)(color == null ? -1 : color.func_196059_a()));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (spawnDataIn instanceof AgeableEntity.AgeableData) {
            AgeableEntity.AgeableData lvt_6_1_ = (AgeableEntity.AgeableData)spawnDataIn;
            if (lvt_6_1_.func_226257_a_() == 0) {
                this.setTusked(true);
            }
        } else {
            this.setTusked(this.func_70681_au().nextBoolean());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public EntityElephant getNearestTusked(IWorld world, double dist) {
        List list = world.func_217357_a(this.getClass(), this.func_174813_aQ().func_72314_b(dist, dist / 2.0, dist));
        if (list.isEmpty()) {
            return null;
        }
        EntityElephant elephant1 = null;
        double d0 = Double.MAX_VALUE;
        for (EntityElephant elephant : list) {
            double d1;
            if (!elephant.isTusked() || (d1 = this.func_70068_e((Entity)elephant)) > d0) continue;
            d0 = d1;
            elephant1 = elephant;
        }
        return elephant1;
    }

    public boolean isTusked() {
        return (Boolean)this.field_70180_af.func_187225_a(TUSKED);
    }

    public void setTusked(boolean tusked) {
        boolean prev = this.isTusked();
        if (!prev && tusked) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(80.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(15.0);
            this.func_70606_j(150.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(65.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(10.0);
        }
        this.field_70180_af.func_187227_b(TUSKED, (Object)tusked);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return ItemTags.func_199903_a().func_199910_a(AMTagRegistry.ELEPHANT_FOODSTUFFS).func_230235_a_((Object)stack.func_77973_b()) || stack.func_77973_b() == AMItemRegistry.ACACIA_BLOSSOM;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.func_92059_d().func_77946_l();
        duplicate.func_190920_e(1);
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
        }
        this.blossomThrowerUUID = duplicate.func_77973_b() == AMItemRegistry.ACACIA_BLOSSOM ? e.func_200214_m() : null;
        this.func_184611_a(Hand.MAIN_HAND, duplicate);
        this.aiItemFlag = false;
    }

    @Override
    public void onFindTarget(ItemEntity e) {
        this.aiItemFlag = true;
    }

    public void addElephantLoot(@Nullable PlayerEntity player, int seed) {
        if (this.field_70170_p.func_73046_m() != null) {
            LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(TRADER_LOOT);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216016_a((long)seed);
            loottable.func_216118_a((IInventory)this.elephantInventory, lootcontext$builder.func_216022_a(LootParameterSets.field_216260_a));
        }
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityElephant caravanHeadIn) {
        this.caravanHead = caravanHeadIn;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTrail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityElephant getCaravanHead() {
        return this.caravanHead;
    }

    @Override
    public double getMaxDistToItem() {
        return 5.0;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float sinWave;
            float standAdd = -0.3f * this.standProgress;
            float scale = this.func_70631_g_() ? 0.5f : (this.isTusked() ? 1.1f : 1.0f);
            float sitAdd = -0.065f * this.sitProgress;
            float scaleY = scale * (2.4f * sitAdd - 0.4f * standAdd);
            if (passenger instanceof AbstractVillagerEntity) {
                AbstractVillagerEntity villager = (AbstractVillagerEntity)passenger;
                scaleY -= 0.3f;
            }
            float radius = scale * (0.5f + standAdd);
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            if (this.getAnimation() == ANIMATION_CHARGE_PREPARE) {
                sinWave = MathHelper.func_76126_a((float)((float)(Math.PI * (double)((float)this.getAnimationTick() / 25.0f))));
                radius += sinWave * 0.2f * scale;
            }
            if (this.getAnimation() == ANIMATION_STOMP) {
                sinWave = MathHelper.func_76126_a((float)((float)(Math.PI * (double)((float)this.getAnimationTick() / 20.0f))));
                radius -= sinWave * 1.0f * scale;
                scaleY += sinWave * 0.7f * scale;
            }
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + this.func_70042_X() + (double)scaleY + passenger.func_70033_W(), this.func_226281_cx_() + extraZ);
        }
    }

    public boolean func_82171_bF() {
        return false;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public double func_70042_X() {
        float scale = this.func_70631_g_() ? 0.5f : (this.isTusked() ? 1.1f : 1.0f);
        float f = Math.min(0.25f, this.field_70721_aZ);
        float f1 = this.field_184619_aG;
        float sitAdd = 0.0f;
        float standAdd = 0.0f;
        return (double)this.func_213302_cg() - (double)0.05f - (double)scale * ((double)(0.1f * MathHelper.func_76134_b((float)(f1 * 1.4f)) * 1.4f * f) + (double)sitAdd + (double)standAdd);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.isSitting()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    public void openGUI(PlayerEntity playerEntity) {
        if (!this.field_70170_p.field_72995_K && !this.func_184196_w((Entity)playerEntity)) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                    return ChestContainer.func_216984_b((int)p_createMenu_1_, (PlayerInventory)p_createMenu_2_, (IInventory)EntityElephant.this.elephantInventory);
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("entity.alexsmobs.elephant.chest");
                }
            });
        }
    }

    public boolean isTrader() {
        return (Boolean)this.field_70180_af.func_187225_a(TRADER);
    }

    public void setTrader(boolean trader) {
        this.field_70180_af.func_187227_b(TRADER, (Object)trader);
    }

    public boolean triggerCharge(ItemStack stack) {
        if (this.func_184179_bs() != null && this.chargeCooldown == 0 && !this.charging && this.getAnimation() == NO_ANIMATION && this.isTusked()) {
            this.setAnimation(ANIMATION_CHARGE_PREPARE);
            this.eatItemEffect(stack);
            this.func_70691_i(2.0f);
            return true;
        }
        return false;
    }

    public boolean canSpawnWithTraderHere() {
        return this.func_205019_a((IWorldReader)this.field_70170_p) && this.field_70170_p.func_175623_d(this.func_233580_cy_().func_177981_b(4));
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)EntityElephant.this, 1.0);
        }

        public boolean func_75250_a() {
            return (EntityElephant.this.func_70631_g_() || !EntityElephant.this.isTusked() || EntityElephant.this.func_70027_ad()) && super.func_75250_a();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)EntityElephant.this, new Class[0]);
        }

        public void func_75249_e() {
            if (EntityElephant.this.func_70631_g_() || !EntityElephant.this.isTusked()) {
                this.func_190105_f();
                this.func_75251_c();
            } else {
                super.func_75249_e();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (!(!(mobIn instanceof EntityElephant) || mobIn.func_70631_g_() && ((EntityElephant)mobIn).isTusked())) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    private class AIWalkIdle
    extends RandomWalkingGoal {
        public AIWalkIdle(EntityElephant e, double v) {
            super((CreatureEntity)e, v);
        }

        public boolean func_75250_a() {
            this.field_179481_f = EntityElephant.this.isTusked() || !EntityElephant.this.inCaravan() ? 50 : 120;
            return super.func_75250_a();
        }

        @Nullable
        protected Vector3d func_190864_f() {
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)(EntityElephant.this.isTusked() || !EntityElephant.this.inCaravan() ? 25 : 10), (int)7);
        }
    }
}

