/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.multistate;

import mod.chiselsandbits.api.IChiselsAndBitsAPI;

public enum StateEntrySize {
    ONE_SIXTEENTH(16),
    ONE_EIGHT(8),
    ONE_QUARTER(4),
    ONE_HALF(2),
    ONE(1);

    private final int bitsPerBlockSide;
    private final int bitsPerBlock;
    private final int bitsPerLayer;
    private final float sizePerBit;
    private final float sizePerHalfBit;

    public static StateEntrySize current() {
        if (IChiselsAndBitsAPI.getInstance() == null) {
            return ONE;
        }
        return IChiselsAndBitsAPI.getInstance().getStateEntrySize();
    }

    private StateEntrySize(int bitsPerBlockSide) {
        this.bitsPerBlockSide = bitsPerBlockSide;
        this.bitsPerBlock = this.bitsPerBlockSide * this.bitsPerBlockSide * this.bitsPerBlockSide;
        this.bitsPerLayer = this.bitsPerBlockSide * this.bitsPerBlockSide;
        this.sizePerBit = 1.0f / (float)bitsPerBlockSide;
        this.sizePerHalfBit = this.sizePerBit / 2.0f;
    }

    public int getBitsPerBlockSide() {
        return this.bitsPerBlockSide;
    }

    public int getBitsPerBlock() {
        return this.bitsPerBlock;
    }

    public int getBitsPerLayer() {
        return this.bitsPerLayer;
    }

    public float getSizePerBit() {
        return this.sizePerBit;
    }

    public float getSizePerHalfBit() {
        return this.sizePerHalfBit;
    }
}

