/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.events;

import mod.chiselsandbits.api.item.wireframe.IWireframeProvidingItem;
import mod.chiselsandbits.api.item.withhighlight.IWithHighlightItem;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.client.render.ChiseledBlockWireframeRenderer;
import mod.chiselsandbits.client.render.MeasurementRenderer;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class WorldRenderLastHandler {
    @SubscribeEvent
    public static void renderCustomWorldHighlight(RenderWorldLastEvent event) {
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        if (playerEntity == null) {
            return;
        }
        ItemStack heldStack = ItemStackUtils.getHighlightItemStackFromPlayer((PlayerEntity)playerEntity);
        if (heldStack.func_190926_b()) {
            return;
        }
        Item heldItem = heldStack.func_77973_b();
        if (!(heldItem instanceof IWithHighlightItem)) {
            return;
        }
        IWithHighlightItem withHighlightItem = (IWithHighlightItem)heldItem;
        if (withHighlightItem.shouldDrawDefaultHighlight((PlayerEntity)playerEntity)) {
            return;
        }
        withHighlightItem.renderHighlight((PlayerEntity)playerEntity, event.getContext(), event.getMatrixStack(), event.getPartialTicks(), event.getProjectionMatrix(), event.getFinishTimeNano());
    }

    @SubscribeEvent
    public static void renderMeasurements(RenderWorldLastEvent event) {
        MeasurementRenderer.getInstance().renderMeasurements(event);
    }

    @SubscribeEvent
    public static void renderMultiStateBlockPreview(RenderWorldLastEvent event) {
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        if (playerEntity == null) {
            return;
        }
        ItemStack heldStack = ItemStackUtils.getMultiStateItemStackFromPlayer((PlayerEntity)playerEntity);
        if (heldStack.func_190926_b()) {
            return;
        }
        Item heldItem = heldStack.func_77973_b();
        if (!(heldItem instanceof IWireframeProvidingItem)) {
            return;
        }
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer((PlayerEntity)playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        if (!(rayTraceResult instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        IWireframeProvidingItem wireframeItem = (IWireframeProvidingItem)heldItem;
        VoxelShape wireFrame = wireframeItem.getWireFrame(heldStack, (PlayerEntity)playerEntity, blockRayTraceResult);
        Vector3d color = wireframeItem.getWireFrameColor(heldStack, (PlayerEntity)playerEntity, blockRayTraceResult);
        Vector3d targetedRenderPos = wireframeItem.getTargetedBlockPos(heldStack, (PlayerEntity)playerEntity, blockRayTraceResult);
        ChiseledBlockWireframeRenderer.getInstance().renderShape(event.getMatrixStack(), wireFrame, targetedRenderPos, color);
    }
}

