/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.item.withmode.IRenderableMode;
import mod.chiselsandbits.api.item.withmode.IToolMode;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.network.packets.HeldToolModeChangedPacket;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.TranslationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.jetbrains.annotations.NotNull;

public class RadialToolModeSelectionScreen<M extends IToolMode<?>>
extends Screen {
    private static final float DRAWS = 720.0f;
    private static final float MAIN_TORUS_INNER = 40.0f;
    private static final float MAIN_TORUS_OUTER = 80.0f;
    private static final float OUTER_TORUS_INNER = 85.0f;
    private static final float OUTER_TORUS_OUTER = 120.0f;
    private static final float MAIN_SELECT_RADIUS = 10.0f;
    private static final float OUTER_SELECT_RADIUS = 83.0f;
    private static final int DEFAULT_ICON_SIZE = 16;
    private static final int DEFAULT_ICON_TEXT_SPACER = 6;
    private final IWithModeItem<M> toolModeItem;
    private final ItemStack sourceStack;
    private final LinkedHashSet<IRenderableMode> mainToolModes = Sets.newLinkedHashSet();
    private final LinkedList<IRenderableMode> mainToolModeList = Lists.newLinkedList();
    private final LinkedListMultimap<IToolModeGroup, M> outerToolModes = LinkedListMultimap.create();
    private final List<M> candidates = Lists.newLinkedList();
    private IRenderableMode lastFrameMainSelectedToolMode;
    private IRenderableMode mainSelectedToolMode;
    private M selectedOuterToolMode;

    private RadialToolModeSelectionScreen(IWithModeItem<M> toolModeItem, ItemStack sourceStack, ITextComponent itemName) {
        super((ITextComponent)TranslationUtils.build("guis.titles.tool-mode", itemName));
        this.toolModeItem = toolModeItem;
        this.sourceStack = sourceStack;
        this.candidates.addAll(this.toolModeItem.getPossibleModes());
        this.candidates.forEach(candidate -> {
            if (candidate.getGroup().isPresent()) {
                this.outerToolModes.put(candidate.getGroup().get(), candidate);
                this.mainToolModes.add((IRenderableMode)candidate.getGroup().get());
            } else {
                this.mainToolModes.add((IRenderableMode)candidate);
            }
        });
        M currentMode = toolModeItem.getMode(this.sourceStack);
        if (currentMode.getGroup().isPresent()) {
            this.mainSelectedToolMode = (IRenderableMode)currentMode.getGroup().get();
            this.selectedOuterToolMode = currentMode;
        } else {
            this.mainSelectedToolMode = currentMode;
            this.selectedOuterToolMode = null;
        }
        this.lastFrameMainSelectedToolMode = this.mainSelectedToolMode;
        this.mainToolModeList.addAll(this.mainToolModes);
    }

    public static <W extends IToolMode<?>> RadialToolModeSelectionScreen<W> create(IWithModeItem<W> modeItem, ItemStack stack) {
        return new RadialToolModeSelectionScreen<W>(modeItem, stack, stack.func_200301_q());
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        float centerX = (float)Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2.0f;
        float centerY = (float)Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2.0f;
        matrixStack.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        matrixStack.func_227861_a_((double)centerX, (double)centerY, 0.0);
        RenderSystem.disableTexture();
        this.renderTorus(matrixStack, mouseX, mouseY, centerX, centerY);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227865_b_();
    }

    private void renderTorus(@NotNull MatrixStack matrix, int mouseX, int mouseY, float centerX, float centerY) {
        RadialToolModeSelectionScreen.handleSelectableTorusRendering(matrix, mouseX, mouseY, centerX, centerY, 40.0f, 80.0f, 10.0f, 120.0f, 0.0f, 360.0f, 1.0f, this.mainToolModeList, () -> this.mainSelectedToolMode, this::onMainToolModeHover, this.field_230712_o_);
        if (this.selectedOuterToolMode != null && this.mainSelectedToolMode instanceof IToolModeGroup) {
            RadialToolModeSelectionScreen.handleSelectableTorusRendering(matrix, mouseX, mouseY, centerX, centerY, 85.0f, 120.0f, 83.0f, 120.0f, (float)this.mainToolModeList.indexOf(this.mainSelectedToolMode) * (360.0f / (float)this.mainToolModeList.size()), 360.0f / (float)this.mainToolModeList.size(), 0.6f, this.outerToolModes.get((Object)((IToolModeGroup)this.mainSelectedToolMode)), () -> this.selectedOuterToolMode, mode -> {
                if (mode != null) {
                    this.selectedOuterToolMode = (IToolMode)mode;
                }
            }, this.field_230712_o_);
        }
    }

    private static void drawTorus(MatrixStack matrix, float startAngle, float sizeAngle, float inner, float outer) {
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        vertexBuffer.func_181668_a(8, DefaultVertexFormats.field_181705_e);
        float draws = 720.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float angle = (float)Math.toRadians(startAngle + (float)i / 720.0f * 360.0f);
            vertexBuffer.func_227888_a_(matrix4f, (float)((double)outer * Math.cos(angle)), (float)((double)outer * Math.sin(angle)), 0.0f).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, (float)((double)inner * Math.cos(angle)), (float)((double)inner * Math.sin(angle)), 0.0f).func_181675_d();
            ++i;
        }
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
    }

    private static void handleSelectableTorusRendering(@NotNull MatrixStack matrixStack, int mouseX, int mouseY, float centerX, float centerY, float innerRadius, float outerRadius, float innerSelectionRadius, float outerSelectionRadius, float startAngle, float sectionArcAngle, float iconScaleFactor, List<? extends IRenderableMode> candidates, Supplier<IRenderableMode> currentGetter, Consumer<IRenderableMode> currentSetter, FontRenderer font) {
        RadialToolModeSelectionScreen.drawSelectableOptions(matrixStack, startAngle, sectionArcAngle, innerRadius, outerRadius, innerSelectionRadius, outerSelectionRadius, mouseX, mouseY, centerX, centerY, font, iconScaleFactor, candidates, currentGetter, currentSetter);
    }

    private void onMainToolModeHover(IRenderableMode mode) {
        this.mainSelectedToolMode = mode;
        if (this.lastFrameMainSelectedToolMode == null && this.mainSelectedToolMode == null) {
            return;
        }
        if (this.lastFrameMainSelectedToolMode != null && this.mainSelectedToolMode == null) {
            this.lastFrameMainSelectedToolMode = null;
            this.selectedOuterToolMode = null;
            return;
        }
        if ((this.lastFrameMainSelectedToolMode == null || this.lastFrameMainSelectedToolMode != this.mainSelectedToolMode) && this.mainSelectedToolMode instanceof IToolModeGroup) {
            this.lastFrameMainSelectedToolMode = this.mainSelectedToolMode;
            this.selectedOuterToolMode = (IToolMode)this.outerToolModes.get((Object)((IToolModeGroup)this.mainSelectedToolMode)).get(0);
            return;
        }
        if (this.mainSelectedToolMode instanceof IToolMode) {
            this.lastFrameMainSelectedToolMode = this.mainSelectedToolMode;
            this.selectedOuterToolMode = null;
        }
    }

    private static void drawSelectableOptions(@NotNull MatrixStack stack, float sectionStartAngle, float sectionArcAngle, float innerRadius, float outerRadius, float innerSelectionRadius, float outerSelectionRadius, float mouseX, float mouseY, float centerX, float centerY, @NotNull FontRenderer fontRenderer, float iconScaleFactor, @NotNull List<? extends IRenderableMode> modes, @NotNull Supplier<IRenderableMode> currentlySelectedModeSupplier, @NotNull Consumer<IRenderableMode> currentlyHoveredModeCallback) {
        IRenderableMode current = currentlySelectedModeSupplier.get();
        int selectableItemCount = modes.size();
        if (selectableItemCount == 0) {
            return;
        }
        float itemArcAngle = sectionArcAngle / (float)selectableItemCount;
        float mouseAngle = RadialToolModeSelectionScreen.calculateMouseAngle(mouseX, mouseY, centerX, centerY);
        float mouseRadius = RadialToolModeSelectionScreen.calculateMouseRadius(mouseX, mouseY, centerX, centerY);
        float inSectionMouseAngle = mouseAngle - sectionStartAngle;
        boolean mouseIsInSectionArc = inSectionMouseAngle >= 0.0f && inSectionMouseAngle <= sectionArcAngle;
        boolean isMouseInSection = mouseIsInSectionArc && mouseRadius >= innerSelectionRadius && mouseRadius <= outerSelectionRadius;
        int hoveredItemIndex = !isMouseInSection ? -1 : (int)(inSectionMouseAngle / itemArcAngle);
        RenderSystem.enableBlend();
        modes.forEach(mode -> {
            int modeIndex = modes.indexOf(mode);
            boolean isSelected = current != null && mode == current;
            boolean isHovered = hoveredItemIndex == modeIndex;
            float itemTargetAngle = ((float)modeIndex + 0.5f) * itemArcAngle + sectionStartAngle;
            RadialToolModeSelectionScreen.drawSelectableSection(stack, sectionArcAngle, innerRadius, outerRadius, selectableItemCount, itemTargetAngle, isSelected, isHovered);
        });
        RenderSystem.disableBlend();
        if (isMouseInSection) {
            if (((Boolean)Configuration.getInstance().getClient().enableMouseIndicatorInRadialMenu.get()).booleanValue()) {
                float startOfMouseArcAngle = mouseAngle - itemArcAngle / 2.0f;
                float mouseArcAngle = itemArcAngle;
                if (sectionArcAngle != 360.0f) {
                    if (startOfMouseArcAngle < sectionStartAngle) {
                        mouseArcAngle -= sectionStartAngle - startOfMouseArcAngle;
                        startOfMouseArcAngle = sectionStartAngle;
                    }
                    if (startOfMouseArcAngle + mouseArcAngle > sectionStartAngle + sectionArcAngle) {
                        mouseArcAngle = sectionStartAngle + sectionArcAngle - startOfMouseArcAngle;
                    }
                }
                RenderSystem.color4f((float)0.8f, (float)0.8f, (float)0.8f, (float)0.3f);
                RadialToolModeSelectionScreen.drawTorus(stack, startOfMouseArcAngle - 90.0f, mouseArcAngle, innerRadius, outerRadius);
            }
            if (hoveredItemIndex >= 0) {
                currentlyHoveredModeCallback.accept(modes.get(hoveredItemIndex));
            }
        } else {
            currentlyHoveredModeCallback.accept(null);
        }
        RenderSystem.enableTexture();
        modes.forEach(mode -> {
            int modeIndex = modes.indexOf(mode);
            float itemTargetAngle = ((float)modeIndex + 0.5f) * itemArcAngle + sectionStartAngle;
            RadialToolModeSelectionScreen.renderModeIcon(stack, innerRadius, outerRadius, itemTargetAngle, iconScaleFactor, mode, fontRenderer);
        });
        RenderSystem.disableTexture();
    }

    private static float calculateMouseAngle(float mouseX, float mouseY, float centerX, float centerY) {
        float mouseAngle;
        float xDiff = mouseX - centerX;
        float yDiff = mouseY - centerY;
        for (mouseAngle = (float)Math.toDegrees(Math.atan2(yDiff, xDiff)) - 270.0f; mouseAngle < 0.0f; mouseAngle += 360.0f) {
        }
        return mouseAngle;
    }

    private static float calculateMouseRadius(float mouseX, float mouseY, float centerX, float centerY) {
        float xDiff = mouseX - centerX;
        float yDiff = mouseY - centerY;
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    private static void drawSelectableSection(@NotNull MatrixStack stack, float sectionArcAngle, float innerRadius, float outerRadius, int itemCountInSection, float itemTargetAngle, boolean isSelected, boolean isHovered) {
        float itemArcAngle = sectionArcAngle / (float)itemCountInSection;
        float itemRenderAngle = itemTargetAngle - 90.0f;
        float sectionStartAngle = itemRenderAngle - itemArcAngle / 2.0f;
        RenderSystem.color4f((float)0.3f, (float)0.3f, (float)0.3f, (float)0.3f);
        RadialToolModeSelectionScreen.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        if (isSelected) {
            RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)0.7f);
            RadialToolModeSelectionScreen.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        }
        if (isHovered) {
            RenderSystem.color4f((float)0.7f, (float)0.7f, (float)0.7f, (float)0.7f);
            RadialToolModeSelectionScreen.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        }
    }

    private static void renderModeIcon(@NotNull MatrixStack stack, float innerRadius, float outerRadius, float itemTargetAngle, float iconScaleFactor, @NotNull IRenderableMode mode, FontRenderer fontRenderer) {
        int n;
        float workingAngle;
        for (workingAngle = itemTargetAngle - 90.0f; workingAngle < 0.0f; workingAngle += 360.0f) {
        }
        float itemCenterX = (float)Math.cos(Math.toRadians(workingAngle)) * (innerRadius + outerRadius) / 2.0f;
        float itemCenterY = (float)Math.sin(Math.toRadians(workingAngle)) * (innerRadius + outerRadius) / 2.0f;
        ITextComponent name = mode.getDisplayName();
        int fontWidth = fontRenderer.func_238414_a_((ITextProperties)name);
        if (mode.shouldRenderDisplayNameInMenu()) {
            fontRenderer.getClass();
            n = (int)(16.0f * iconScaleFactor + 6.0f + 9.0f);
        } else {
            n = (int)(16.0f * iconScaleFactor);
        }
        int itemHeight = n;
        float iconStartX = itemCenterX - 16.0f * iconScaleFactor / 2.0f;
        float iconStartY = itemCenterY - (float)itemHeight / 2.0f;
        stack.func_227860_a_();
        RenderSystem.color4f((float)((float)mode.getColorVector().func_82615_a()), (float)((float)mode.getColorVector().func_82617_b()), (float)((float)mode.getColorVector().func_82616_c()), (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(mode.getIcon());
        RadialToolModeSelectionScreen.func_238466_a_((MatrixStack)stack, (int)((int)iconStartX), (int)((int)iconStartY), (int)((int)(16.0f * iconScaleFactor)), (int)((int)(16.0f * iconScaleFactor)), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        stack.func_227860_a_();
        if (mode.shouldRenderDisplayNameInMenu()) {
            stack.func_227861_a_((double)itemCenterX, (double)itemCenterY, 0.0);
            stack.func_227862_a_(0.6f * iconScaleFactor, 0.6f * iconScaleFactor, 0.6f * iconScaleFactor);
            fontRenderer.func_243248_b(stack, mode.getDisplayName(), (float)fontWidth / -2.0f, 6.0f, -855638017);
        }
        stack.func_227865_b_();
        stack.func_227865_b_();
    }

    public void func_231164_f_() {
        this.updateSelection();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void updateSelection() {
        if (this.mainSelectedToolMode != null) {
            M mainToolModeSelection = this.mainSelectedToolMode instanceof IToolModeGroup ? this.selectedOuterToolMode : (this.mainSelectedToolMode instanceof IToolMode ? (IToolMode)this.mainSelectedToolMode : this.toolModeItem.getMode(this.sourceStack));
            this.toolModeItem.setMode(ItemStackUtils.getModeItemStackFromPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g), mainToolModeSelection);
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new HeldToolModeChangedPacket(this.candidates.indexOf(mainToolModeSelection)));
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.updateSelection();
        this.func_231175_as__();
        return true;
    }

    public void onMoveSelectionToTheRight() {
        if (this.mainSelectedToolMode != null) {
            IToolMode newMode;
            M mainToolModeSelection = this.mainSelectedToolMode instanceof IToolModeGroup ? this.selectedOuterToolMode : (this.mainSelectedToolMode instanceof IToolMode ? (IToolMode)this.mainSelectedToolMode : this.toolModeItem.getMode(this.sourceStack));
            int workingIndex = this.candidates.indexOf(mainToolModeSelection);
            if (++workingIndex >= this.candidates.size()) {
                workingIndex = 0;
            }
            if ((newMode = (IToolMode)this.candidates.get(workingIndex)).getGroup().isPresent()) {
                this.mainSelectedToolMode = (IRenderableMode)newMode.getGroup().get();
                this.selectedOuterToolMode = newMode;
            } else {
                this.mainSelectedToolMode = newMode;
                this.selectedOuterToolMode = null;
            }
        }
    }

    public void onMoveSelectionToTheLeft() {
        if (this.mainSelectedToolMode != null) {
            IToolMode newMode;
            M mainToolModeSelection = this.mainSelectedToolMode instanceof IToolModeGroup ? this.selectedOuterToolMode : (this.mainSelectedToolMode instanceof IToolMode ? (IToolMode)this.mainSelectedToolMode : this.toolModeItem.getMode(this.sourceStack));
            int workingIndex = this.candidates.indexOf(mainToolModeSelection);
            if (--workingIndex < 0) {
                workingIndex = this.candidates.size() - 1;
            }
            if ((newMode = (IToolMode)this.candidates.get(workingIndex)).getGroup().isPresent()) {
                this.mainSelectedToolMode = (IRenderableMode)newMode.getGroup().get();
                this.selectedOuterToolMode = newMode;
            } else {
                this.mainSelectedToolMode = newMode;
                this.selectedOuterToolMode = null;
            }
        }
    }
}

