/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network;

import java.util.function.Function;
import mod.chiselsandbits.network.packets.BagGuiPacket;
import mod.chiselsandbits.network.packets.BagGuiStackPacket;
import mod.chiselsandbits.network.packets.ChangeTrackerUpdatedPacket;
import mod.chiselsandbits.network.packets.ClearBagGuiPacket;
import mod.chiselsandbits.network.packets.HeldToolModeChangedPacket;
import mod.chiselsandbits.network.packets.MeasurementUpdatedPacket;
import mod.chiselsandbits.network.packets.MeasurementsResetPacket;
import mod.chiselsandbits.network.packets.MeasurementsUpdatedPacket;
import mod.chiselsandbits.network.packets.ModPacket;
import mod.chiselsandbits.network.packets.NeighborBlockUpdatedPacket;
import mod.chiselsandbits.network.packets.OpenBagGuiPacket;
import mod.chiselsandbits.network.packets.RequestChangeTrackerOperation;
import mod.chiselsandbits.network.packets.SortBagGuiPacket;
import mod.chiselsandbits.network.packets.TileEntityUpdatedPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkChannel {
    private static final String LATEST_PROTO_VER = "1.0";
    private static final String ACCEPTED_PROTO_VERS = "1.0";
    private final SimpleChannel rawChannel;

    public NetworkChannel(String channelName) {
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("chiselsandbits", channelName), () -> "1.0", "1.0"::equals, "1.0"::equals);
    }

    public void registerCommonMessages() {
        int index = -1;
        this.registerMessage(index++, HeldToolModeChangedPacket.class, HeldToolModeChangedPacket::new);
        this.registerMessage(index++, TileEntityUpdatedPacket.class, TileEntityUpdatedPacket::new);
        this.registerMessage(index++, BagGuiPacket.class, BagGuiPacket::new);
        this.registerMessage(index++, BagGuiStackPacket.class, BagGuiStackPacket::new);
        this.registerMessage(index++, ClearBagGuiPacket.class, ClearBagGuiPacket::new);
        this.registerMessage(index++, OpenBagGuiPacket.class, OpenBagGuiPacket::new);
        this.registerMessage(index++, SortBagGuiPacket.class, SortBagGuiPacket::new);
        this.registerMessage(index++, MeasurementUpdatedPacket.class, MeasurementUpdatedPacket::new);
        this.registerMessage(index++, MeasurementsUpdatedPacket.class, MeasurementsUpdatedPacket::new);
        this.registerMessage(index++, MeasurementsResetPacket.class, MeasurementsResetPacket::new);
        this.registerMessage(index++, NeighborBlockUpdatedPacket.class, NeighborBlockUpdatedPacket::new);
        this.registerMessage(index++, ChangeTrackerUpdatedPacket.class, ChangeTrackerUpdatedPacket::new);
        this.registerMessage(index++, RequestChangeTrackerOperation.class, RequestChangeTrackerOperation::new);
    }

    public <MSG extends ModPacket> void registerMessage(int id, Class<MSG> msgClazz, Function<PacketBuffer, MSG> msgCreator) {
        this.rawChannel.registerMessage(id, msgClazz, ModPacket::writePayload, msgCreator, (msg, ctxIn) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxIn.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            ctx.enqueueWork(() -> msg.processPacket(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT)));
        });
    }

    public void sendToServer(ModPacket msg) {
        this.rawChannel.sendToServer((Object)msg);
    }

    public void sendToPlayer(ModPacket msg, ServerPlayerEntity player) {
        this.rawChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public void sendToOrigin(ModPacket msg, NetworkEvent.Context ctx) {
        ServerPlayerEntity player = ctx.getSender();
        if (player != null) {
            this.sendToPlayer(msg, player);
        } else {
            this.sendToServer(msg);
        }
    }

    public void sendToDimension(ModPacket msg, ResourceLocation dim) {
        this.rawChannel.send(PacketDistributor.DIMENSION.with(() -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dim)), (Object)msg);
    }

    public void sendToPosition(ModPacket msg, PacketDistributor.TargetPoint pos) {
        this.rawChannel.send(PacketDistributor.NEAR.with(() -> pos), (Object)msg);
    }

    public void sendToEveryone(ModPacket msg) {
        this.rawChannel.send(PacketDistributor.ALL.noArg(), (Object)msg);
    }

    public void sendToTrackingEntity(ModPacket msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingEntityAndSelf(ModPacket msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingChunk(ModPacket msg, Chunk chunk) {
        this.rawChannel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)msg);
    }
}

