/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.profiling;

import java.util.function.Consumer;
import mod.chiselsandbits.api.profiling.IProfiler;
import mod.chiselsandbits.api.profiling.IProfilerResult;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.profiling.IProfilingManager;
import mod.chiselsandbits.profiling.CandBProfiler;

public class ProfilingManager
implements IProfilingManager {
    private static final ProfilingManager INSTANCE = new ProfilingManager();
    public IProfiler profiler = null;

    public static ProfilingManager getInstance() {
        return INSTANCE;
    }

    private ProfilingManager() {
    }

    @Override
    public IProfiler startProfiling() {
        return new CandBProfiler();
    }

    @Override
    public IProfilerResult endProfiling(IProfiler profiler) {
        if (!(profiler instanceof CandBProfiler)) {
            throw new IllegalArgumentException("Profiler is not a C&B Profiler");
        }
        CandBProfiler candBProfiler = (CandBProfiler)profiler;
        return candBProfiler.getResult();
    }

    public IProfiler getProfiler() {
        return this.profiler;
    }

    public void setProfiler(IProfiler profiler) {
        this.profiler = profiler;
    }

    public boolean hasProfiler() {
        return this.getProfiler() != null;
    }

    public void withProfiler(Consumer<IProfiler> callback) {
        if (this.hasProfiler()) {
            callback.accept(this.getProfiler());
        }
    }

    public IProfilerSection withSection(String name) {
        IProfiler profiler = this.getProfiler();
        if (profiler != null) {
            profiler.startSection(name);
        }
        return () -> {
            if (profiler != null) {
                profiler.endSection();
            }
        };
    }
}

