/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.chunk.ChunkSection;

public class ChunkSectionUtils {
    private ChunkSectionUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ChunkSectionUtils. This is a utility class");
    }

    public static CompoundNBT serializeNBT(ChunkSection chunkSection) {
        CompoundNBT compressedSectionData = new CompoundNBT();
        chunkSection.func_186049_g().func_196963_b(compressedSectionData, "palette", "blockStates");
        return compressedSectionData;
    }

    public static void deserializeNBT(ChunkSection chunkSection, CompoundNBT nbt) {
        if (nbt.isEmpty()) {
            return;
        }
        chunkSection.func_186049_g().func_222642_a(nbt.func_150295_c("palette", 10), nbt.func_197645_o("blockStates"));
        chunkSection.func_76672_e();
    }

    public static ChunkSection rotate90Degrees(ChunkSection source, Direction.Axis axis, int rotationCount) {
        if (rotationCount == 0) {
            return source;
        }
        Vector3d centerVector = new Vector3d(7.5, 7.5, 7.5);
        ChunkSection target = new ChunkSection(0);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Vector3d workingVector = new Vector3d((double)x, (double)y, (double)z);
                    Vector3d rotatedVector = workingVector.func_178788_d(centerVector);
                    for (int i = 0; i < rotationCount; ++i) {
                        rotatedVector = VectorUtils.rotate90Degrees(rotatedVector, axis);
                    }
                    BlockPos sourcePos = new BlockPos(workingVector);
                    Vector3d offsetPos = rotatedVector.func_178787_e(centerVector).func_216372_d(1000.0, 1000.0, 1000.0);
                    BlockPos targetPos = new BlockPos(new Vector3d((double)Math.round(offsetPos.func_82615_a()), (double)Math.round(offsetPos.func_82617_b()), (double)Math.round(offsetPos.func_82616_c())).func_216372_d(0.001, 0.001, 0.001));
                    target.func_222629_a(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), source.func_177485_a(sourcePos.func_177958_n(), sourcePos.func_177956_o(), sourcePos.func_177952_p()));
                }
            }
        }
        return target;
    }

    public static ChunkSection cloneSection(ChunkSection lazyChunkSection) {
        ChunkSection clone = new ChunkSection(0);
        ChunkSectionUtils.deserializeNBT(clone, ChunkSectionUtils.serializeNBT(lazyChunkSection));
        return clone;
    }

    public static void fillFromBottom(ChunkSection chunkSection, BlockState blockState, int amount) {
        int loopCount = Math.max(0, Math.min(amount, StateEntrySize.current().getBitsPerBlock()));
        if (loopCount == 0) {
            return;
        }
        int count = 0;
        for (int y = 0; y < StateEntrySize.current().getBitsPerBlockSide(); ++y) {
            for (int x = 0; x < StateEntrySize.current().getBitsPerBlockSide(); ++x) {
                for (int z = 0; z < StateEntrySize.current().getBitsPerBlockSide(); ++z) {
                    chunkSection.func_222629_a(x, y, z, blockState);
                    if (++count != loopCount) continue;
                    return;
                }
            }
        }
    }

    public static ChunkSection mirror(ChunkSection lazyChunkSection, Direction.Axis axis) {
        ChunkSection result = new ChunkSection(0);
        for (int y = 0; y < StateEntrySize.current().getBitsPerBlockSide(); ++y) {
            for (int x = 0; x < StateEntrySize.current().getBitsPerBlockSide(); ++x) {
                for (int z = 0; z < StateEntrySize.current().getBitsPerBlockSide(); ++z) {
                    BlockState blockState = lazyChunkSection.func_177485_a(x, y, z);
                    int mirroredX = axis == Direction.Axis.X ? StateEntrySize.current().getBitsPerBlockSide() - x - 1 : x;
                    int mirroredY = axis == Direction.Axis.Y ? StateEntrySize.current().getBitsPerBlockSide() - y - 1 : y;
                    int mirroredZ = axis == Direction.Axis.Z ? StateEntrySize.current().getBitsPerBlockSide() - z - 1 : z;
                    result.func_177484_a(mirroredX, mirroredY, mirroredZ, blockState, false);
                }
            }
        }
        return result;
    }
}

