/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.IMouseHandler;
import net.minecraft.util.text.ITextComponent;

public abstract class RecipeGuiTab
implements IMouseHandler {
    public static final int TAB_HEIGHT = 24;
    public static final int TAB_WIDTH = 24;
    protected final int x;
    protected final int y;
    private final HoverChecker hoverChecker;

    public RecipeGuiTab(int x, int y) {
        this.x = x;
        this.y = y;
        this.hoverChecker = new HoverChecker();
        this.hoverChecker.updateBounds(y, y + 24, x, x + 24);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public abstract boolean isSelected(IRecipeCategory<?> var1);

    public void draw(boolean selected, MatrixStack matrixStack, int mouseX, int mouseY) {
        Textures textures = Internal.getTextures();
        IDrawableStatic tab = selected ? textures.getTabSelected() : textures.getTabUnselected();
        tab.draw(matrixStack, this.x, this.y);
    }

    public abstract List<ITextComponent> getTooltip();
}

