/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.gui.Focus;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.recipes.InternalRecipeManagerPlugin;
import mezz.jei.recipes.RecipeCatalystBuilder;
import mezz.jei.recipes.RecipeCategoryData;
import mezz.jei.recipes.RecipeCategoryDataMap;
import mezz.jei.recipes.RecipeManagerPluginSafeWrapper;
import mezz.jei.recipes.RecipeMap;
import mezz.jei.util.ErrorUtil;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeManagerInternal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IngredientManager ingredientManager;
    private final ImmutableList<IRecipeCategory<?>> recipeCategories;
    private final Set<ResourceLocation> hiddenRecipeCategoryUids = new HashSet<ResourceLocation>();
    @Nullable
    private ImmutableList<IRecipeCategory<?>> recipeCategoriesVisibleCache = null;
    private final RecipeCategoryDataMap recipeCategoriesDataMap;
    private final Comparator<IRecipeCategory<?>> recipeCategoryComparator;
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final List<RecipeManagerPluginSafeWrapper> plugins = new ArrayList<RecipeManagerPluginSafeWrapper>();

    public RecipeManagerInternal(ImmutableList<IRecipeCategory<?>> recipeCategories, ImmutableListMultimap<ResourceLocation, Object> recipes, ImmutableListMultimap<ResourceLocation, Object> recipeCatalysts, IngredientManager ingredientManager, ImmutableList<IRecipeManagerPlugin> plugins, RecipeCategorySortingConfig recipeCategorySortingConfig) {
        ErrorUtil.checkNotEmpty(recipeCategories, "recipeCategories");
        this.ingredientManager = ingredientManager;
        Collection recipeCategoryResourceLocations = recipeCategories.stream().map(IRecipeCategory::getUid).collect(Collectors.toList());
        Comparator<ResourceLocation> recipeCategoryUidComparator = recipeCategorySortingConfig.getComparator(recipeCategoryResourceLocations);
        this.recipeInputMap = new RecipeMap(recipeCategoryUidComparator, ingredientManager);
        this.recipeOutputMap = new RecipeMap(recipeCategoryUidComparator, ingredientManager);
        this.recipeCategoryComparator = Comparator.comparing(IRecipeCategory::getUid, recipeCategoryUidComparator);
        this.recipeCategories = ImmutableList.sortedCopyOf(this.recipeCategoryComparator, recipeCategories);
        RecipeCatalystBuilder recipeCatalystBuilder = new RecipeCatalystBuilder(ingredientManager);
        for (IRecipeCategory recipeCategory : recipeCategories) {
            ResourceLocation recipeCategoryUid = recipeCategory.getUid();
            if (!recipeCatalysts.containsKey((Object)recipeCategoryUid)) continue;
            ImmutableList catalysts = recipeCatalysts.get((Object)recipeCategoryUid);
            recipeCatalystBuilder.addCatalysts(recipeCategory, (List<Object>)catalysts, this.recipeInputMap);
        }
        ImmutableListMultimap<IRecipeCategory<?>, Object> recipeCatalystsMap = recipeCatalystBuilder.buildRecipeCatalysts();
        this.recipeCategoriesDataMap = new RecipeCategoryDataMap((List<IRecipeCategory<?>>)recipeCategories, recipeCatalystsMap);
        ImmutableMultimap<String, ResourceLocation> categoriesForRecipeCatalystKeys = recipeCatalystBuilder.buildCategoriesForRecipeCatalystKeys();
        InternalRecipeManagerPlugin internalRecipeManagerPlugin = new InternalRecipeManagerPlugin(categoriesForRecipeCatalystKeys, ingredientManager, this.recipeCategoriesDataMap, this.recipeInputMap, this.recipeOutputMap, () -> this.getRecipeCategoriesStream(null, null, false));
        this.plugins.add(new RecipeManagerPluginSafeWrapper(internalRecipeManagerPlugin));
        for (IRecipeManagerPlugin plugin : plugins) {
            this.plugins.add(new RecipeManagerPluginSafeWrapper(plugin));
        }
        this.addRecipes(recipes);
    }

    private void addRecipes(ImmutableListMultimap<ResourceLocation, Object> recipes) {
        ImmutableSet recipeCategoryUids = recipes.keySet();
        for (ResourceLocation recipeCategoryUid : recipeCategoryUids) {
            LOGGER.debug("Loading recipes: " + recipeCategoryUid.toString());
            for (Object recipe : recipes.get((Object)recipeCategoryUid)) {
                this.addRecipeTyped(recipe, recipeCategoryUid);
            }
        }
    }

    private <T> void addRecipeTyped(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        this.addRecipe(recipe, recipeCategoryData);
    }

    @Deprecated
    public <T> void addRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
        if (hiddenRecipes.contains(recipe)) {
            this.unhideRecipe(recipe, recipeCategoryUid);
        } else {
            this.addRecipe(recipe, recipeCategoryData);
        }
    }

    private <T> void addRecipe(T recipe, RecipeCategoryData<T> recipeCategoryData) {
        IRecipeCategory<T> recipeCategory = recipeCategoryData.getRecipeCategory();
        if (!recipeCategory.isHandled(recipe)) {
            return;
        }
        try {
            Ingredients ingredients = new Ingredients();
            recipeCategory.setIngredients(recipe, ingredients);
            this.recipeInputMap.addRecipe(recipe, recipeCategory, ingredients.getInputIngredients());
            this.recipeOutputMap.addRecipe(recipe, recipeCategory, ingredients.getOutputIngredients());
            recipeCategoryData.getRecipes().add(recipe);
            this.unhideRecipe(recipe, recipeCategory.getUid());
            this.recipeCategoriesVisibleCache = null;
        }
        catch (LinkageError | RuntimeException e) {
            String recipeInfo = ErrorUtil.getInfoFromRecipe(recipe, recipeCategory);
            LOGGER.error("Found a broken recipe: {}\n", (Object)recipeInfo, (Object)e);
        }
    }

    private <V> boolean isCategoryHidden(IRecipeCategory<?> recipeCategory, @Nullable Focus<V> focus) {
        List<Object> visibleCatalysts;
        if (this.hiddenRecipeCategoryUids.contains(recipeCategory.getUid())) {
            return true;
        }
        List<Object> allCatalysts = this.getRecipeCatalysts(recipeCategory, true);
        if (!allCatalysts.isEmpty() && (visibleCatalysts = this.getRecipeCatalysts(recipeCategory, false)).isEmpty()) {
            return true;
        }
        Stream<?> visibleRecipes = this.getRecipesStream(recipeCategory, focus, false);
        return !visibleRecipes.findAny().isPresent();
    }

    public <V> Stream<IRecipeCategory<?>> getRecipeCategoriesStream(@Nullable Collection<ResourceLocation> recipeCategoryUids, @Nullable Focus<V> focus, boolean includeHidden) {
        if (recipeCategoryUids == null && focus == null && !includeHidden) {
            if (this.recipeCategoriesVisibleCache == null) {
                this.recipeCategoriesVisibleCache = (ImmutableList)this.getRecipeCategoriesStreamUncached(null, null, false).collect(ImmutableList.toImmutableList());
            }
            return this.recipeCategoriesVisibleCache.stream();
        }
        return this.getRecipeCategoriesStreamUncached(recipeCategoryUids, focus, includeHidden);
    }

    private <V> Stream<IRecipeCategory<?>> getRecipeCategoriesStreamUncached(@Nullable Collection<ResourceLocation> recipeCategoryUids, @Nullable Focus<V> focus, boolean includeHidden) {
        Stream<IRecipeCategory> categoryStream;
        if (focus == null) {
            categoryStream = recipeCategoryUids == null ? this.recipeCategories.stream() : recipeCategoryUids.stream().distinct().map(this.recipeCategoriesDataMap::get).map(RecipeCategoryData::getRecipeCategory);
        } else {
            Stream uidStream = this.plugins.stream().map(p -> p.getRecipeCategoryUids(focus)).flatMap(Collection::stream).distinct();
            if (recipeCategoryUids != null) {
                uidStream = uidStream.filter(recipeCategoryUids::contains);
            }
            categoryStream = uidStream.map(this.recipeCategoriesDataMap::get).map(RecipeCategoryData::getRecipeCategory);
        }
        if (!includeHidden) {
            categoryStream = categoryStream.filter(c -> !this.isCategoryHidden((IRecipeCategory<?>)c, focus));
        }
        return categoryStream.sorted(this.recipeCategoryComparator);
    }

    public <T, V> Stream<T> getRecipesStream(IRecipeCategory<T> recipeCategory, @Nullable Focus<V> focus, boolean includeHidden) {
        Stream<Object> recipes = this.plugins.stream().map(p -> this.getPluginRecipes((IRecipeManagerPlugin)p, recipeCategory, focus)).flatMap(Collection::stream);
        if (!includeHidden) {
            RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategory);
            Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
            Predicate<Object> notHidden = ((Predicate<Object>)hiddenRecipes::contains).negate();
            recipes = recipes.filter(notHidden);
        }
        return recipes;
    }

    private <T, V> List<T> getPluginRecipes(IRecipeManagerPlugin plugin, IRecipeCategory<T> recipeCategory, @Nullable Focus<V> focus) {
        if (focus != null) {
            return plugin.getRecipes(recipeCategory, focus);
        }
        return plugin.getRecipes(recipeCategory);
    }

    public <T> List<Object> getRecipeCatalysts(IRecipeCategory<T> recipeCategory, boolean includeHidden) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategory);
        ImmutableList<Object> catalysts = recipeCategoryData.getRecipeCatalysts();
        if (includeHidden) {
            return catalysts;
        }
        IngredientFilter ingredientFilter = Internal.getIngredientFilter();
        return catalysts.stream().filter(catalyst -> this.ingredientManager.isIngredientVisible(catalyst, ingredientFilter)).collect(Collectors.toList());
    }

    public <T> void hideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
        hiddenRecipes.add(recipe);
        this.recipeCategoriesVisibleCache = null;
    }

    public <T> void unhideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
        hiddenRecipes.remove(recipe);
        this.recipeCategoriesVisibleCache = null;
    }

    public void hideRecipeCategory(ResourceLocation recipeCategoryUid) {
        this.hiddenRecipeCategoryUids.add(recipeCategoryUid);
        this.recipeCategoriesVisibleCache = null;
    }

    public void unhideRecipeCategory(ResourceLocation recipeCategoryUid) {
        this.recipeCategoriesDataMap.validate(recipeCategoryUid);
        this.hiddenRecipeCategoryUids.remove(recipeCategoryUid);
        this.recipeCategoriesVisibleCache = null;
    }
}

