/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.util.List;
import java.util.function.BiFunction;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.gui.GuiConfigHome;
import mcp.mobius.waila.overlay.TickHandler;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class WailaClient {
    public static KeyBinding openConfig;
    public static KeyBinding showOverlay;
    public static KeyBinding toggleLiquid;
    public static KeyBinding showRecipeInput;
    public static KeyBinding showRecipeOutput;
    protected static BiFunction<String, Integer, KeyBinding> keyBindingBuilder;
    public static Runnable onShowRecipeInput;
    public static Runnable onShowRecipeOutput;

    protected static void init() {
        openConfig = keyBindingBuilder.apply("config", 320);
        showOverlay = keyBindingBuilder.apply("show_overlay", 321);
        toggleLiquid = keyBindingBuilder.apply("toggle_liquid", 322);
        showRecipeInput = keyBindingBuilder.apply("show_recipe_input", 323);
        showRecipeOutput = keyBindingBuilder.apply("show_recipe_output", 324);
    }

    protected static void onJoinServer() {
        if (!Waila.packet.isServerAvailable()) {
            Waila.LOGGER.warn("WTHIT is not found on the server, all syncable config will reset to their default value.");
            PluginConfig.INSTANCE.getSyncableConfigs().forEach(config -> config.setValue(config.getDefaultValue()));
        }
    }

    protected static void onClientTick() {
        Minecraft client = Minecraft.func_71410_x();
        WailaConfig config = Waila.CONFIG.get();
        TickHandler.tickClient();
        while (openConfig.func_151468_f()) {
            client.func_147108_a((Screen)new GuiConfigHome(null));
        }
        while (showOverlay.func_151468_f()) {
            if (config.getGeneral().getDisplayMode() != WailaConfig.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().shouldDisplayTooltip());
        }
        while (toggleLiquid.func_151468_f()) {
            PluginConfig.INSTANCE.set(WailaConstants.CONFIG_SHOW_FLUID, PluginConfig.INSTANCE.get(WailaConstants.CONFIG_SHOW_FLUID));
        }
        while (showRecipeInput.func_151468_f() && onShowRecipeInput != null) {
            onShowRecipeInput.run();
        }
        while (showRecipeOutput.func_151468_f() && onShowRecipeOutput != null) {
            onShowRecipeOutput.run();
        }
    }

    protected static void onItemTooltip(ItemStack stack, List<ITextComponent> tooltip) {
        if (PluginConfig.INSTANCE.get(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.add((ITextComponent)new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModInfo(stack).getName())));
        }
    }
}

