/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public enum DataAccessor implements ICommonAccessor,
IBlockAccessor,
IDataAccessor,
IEntityAccessor
{
    INSTANCE;

    private World world;
    private PlayerEntity player;
    private RayTraceResult hitResult;
    private Vector3d renderingVec = null;
    private Block block = Blocks.field_150350_a;
    private BlockState state = Blocks.field_150350_a.func_176223_P();
    private BlockPos pos = BlockPos.field_177992_a;
    private ResourceLocation blockRegistryName = Registry.field_212630_s.func_212609_b();
    private TileEntity blockEntity;
    private Entity entity;
    private CompoundNBT serverData = null;
    private long timeLastUpdate = System.currentTimeMillis();
    private double partialFrame;
    private ItemStack stack = ItemStack.field_190927_a;

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        return this.state;
    }

    @Override
    public TileEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    @Override
    public RayTraceResult getHitResult() {
        return this.hitResult;
    }

    @Override
    public Vector3d getRenderingPosition() {
        return this.renderingVec;
    }

    @Override
    public CompoundNBT getServerData() {
        if (this.blockEntity != null && this.isTagCorrectBlockEntity(this.serverData)) {
            return this.serverData;
        }
        if (this.entity != null && this.isTagCorrectEntity(this.serverData)) {
            return this.serverData;
        }
        if (this.blockEntity != null) {
            return this.blockEntity.func_189515_b(new CompoundNBT());
        }
        if (this.entity != null) {
            return this.entity.func_189511_e(new CompoundNBT());
        }
        return new CompoundNBT();
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    @Override
    public Direction getSide() {
        return this.hitResult == null ? null : (this.hitResult.func_216346_c() == RayTraceResult.Type.ENTITY ? null : ((BlockRayTraceResult)this.hitResult).func_216354_b());
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public String getModNameFormat() {
        return Waila.CONFIG.get().getFormatting().getModName();
    }

    @Override
    public String getBlockNameFormat() {
        return Waila.CONFIG.get().getFormatting().getBlockName();
    }

    @Override
    public String getFluidNameFormat() {
        return Waila.CONFIG.get().getFormatting().getFluidName();
    }

    @Override
    public String getEntityNameFormat() {
        return Waila.CONFIG.get().getFormatting().getEntityName();
    }

    @Override
    public String getRegistryNameFormat() {
        return Waila.CONFIG.get().getFormatting().getRegistryName();
    }

    @Override
    @Nullable
    public TileEntity getTileEntity() {
        return this.getBlockEntity();
    }

    @Override
    public ResourceLocation getBlockId() {
        return this.blockRegistryName;
    }

    public void set(World world, PlayerEntity player, RayTraceResult hit, Entity viewEntity, double partialTicks) {
        this.world = world;
        this.player = player;
        this.hitResult = hit;
        if (this.hitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.pos = ((BlockRayTraceResult)hit).func_216350_a();
            this.blockEntity = this.world.func_175625_s(this.pos);
            this.entity = null;
            this.setState(world.func_180495_p(this.pos));
        } else if (this.hitResult.func_216346_c() == RayTraceResult.Type.ENTITY) {
            this.entity = ((EntityRayTraceResult)hit).func_216348_a();
            this.pos = new BlockPos(this.entity.func_213303_ch());
            this.blockEntity = null;
            this.setState(Blocks.field_150350_a.func_176223_P());
        }
        if (viewEntity != null) {
            double px = viewEntity.field_70169_q + (viewEntity.func_226277_ct_() - viewEntity.field_70169_q) * partialTicks;
            double py = viewEntity.field_70167_r + (viewEntity.func_226278_cu_() - viewEntity.field_70167_r) * partialTicks;
            double pz = viewEntity.field_70166_s + (viewEntity.func_226281_cx_() - viewEntity.field_70166_s) * partialTicks;
            this.renderingVec = new Vector3d((double)this.pos.func_177958_n() - px, (double)this.pos.func_177956_o() - py, (double)this.pos.func_177952_p() - pz);
            this.partialFrame = partialTicks;
        }
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public void setServerData(CompoundNBT tag) {
        this.serverData = tag;
    }

    public void setState(BlockState state) {
        this.state = state;
        this.block = state.func_177230_c();
        this.stack = this.block.func_185473_a((IBlockReader)this.world, this.pos, state);
        this.blockRegistryName = Registry.field_212618_g.func_177774_c((Object)this.block);
    }

    private boolean isTagCorrectBlockEntity(CompoundNBT tag) {
        if (tag == null) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.func_74762_e("x");
        int y = tag.func_74762_e("y");
        int z = tag.func_74762_e("z");
        BlockPos hitPos = ((BlockRayTraceResult)this.hitResult).func_216350_a();
        if (x == hitPos.func_177958_n() && y == hitPos.func_177956_o() && z == hitPos.func_177952_p()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity(CompoundNBT tag) {
        if (tag == null || !tag.func_74764_b("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.func_74762_e("WailaEntityID");
        if (id == this.entity.func_145782_y()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

