/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;

public enum EntityIconComponent implements IEntityComponentProvider
{
    INSTANCE;

    static final Map<AbstractMinecartEntity.Type, ItemStack> MINECART_STACKS;
    static final Map<BoatEntity.Type, ItemStack> BOAT_STACKS;
    static final ItemStack ITEM_FRAME_STACK;
    static final ItemStack PAINTING_STACK;
    static final ItemStack LEAD_STACK;

    @Override
    public ItemStack getDisplayItem(IEntityAccessor accessor, IPluginConfig config) {
        Entity entity = accessor.getEntity();
        if (entity instanceof AbstractMinecartEntity) {
            return MINECART_STACKS.get(((AbstractMinecartEntity)entity).func_184264_v());
        }
        if (entity instanceof ItemFrameEntity) {
            ItemStack held = ((ItemFrameEntity)entity).func_82335_i();
            return held.func_190926_b() ? ITEM_FRAME_STACK : held;
        }
        if (entity instanceof PaintingEntity) {
            return PAINTING_STACK;
        }
        if (entity instanceof LeashKnotEntity) {
            return LEAD_STACK;
        }
        if (entity instanceof BoatEntity) {
            return BOAT_STACKS.get(((BoatEntity)entity).func_184453_r());
        }
        return ItemStack.field_190927_a;
    }

    static {
        MINECART_STACKS = (Map)Util.func_200696_a((Object)new Object2ObjectOpenHashMap(), m -> {
            m.put((Object)AbstractMinecartEntity.Type.RIDEABLE, (Object)new ItemStack((IItemProvider)Items.field_151143_au));
            m.put((Object)AbstractMinecartEntity.Type.CHEST, (Object)new ItemStack((IItemProvider)Items.field_151108_aI));
            m.put((Object)AbstractMinecartEntity.Type.FURNACE, (Object)new ItemStack((IItemProvider)Items.field_151109_aJ));
            m.put((Object)AbstractMinecartEntity.Type.HOPPER, (Object)new ItemStack((IItemProvider)Items.field_151140_bW));
            m.put((Object)AbstractMinecartEntity.Type.TNT, (Object)new ItemStack((IItemProvider)Items.field_151108_aI));
            m.put((Object)AbstractMinecartEntity.Type.COMMAND_BLOCK, (Object)new ItemStack((IItemProvider)Items.field_151095_cc));
            m.defaultReturnValue((Object)ItemStack.field_190927_a);
        });
        BOAT_STACKS = (Map)Util.func_200696_a((Object)new Object2ObjectOpenHashMap(), m -> {
            m.put((Object)BoatEntity.Type.OAK, (Object)new ItemStack((IItemProvider)Items.field_151124_az));
            m.put((Object)BoatEntity.Type.SPRUCE, (Object)new ItemStack((IItemProvider)Items.field_185150_aH));
            m.put((Object)BoatEntity.Type.BIRCH, (Object)new ItemStack((IItemProvider)Items.field_185151_aI));
            m.put((Object)BoatEntity.Type.JUNGLE, (Object)new ItemStack((IItemProvider)Items.field_185152_aJ));
            m.put((Object)BoatEntity.Type.ACACIA, (Object)new ItemStack((IItemProvider)Items.field_185153_aK));
            m.put((Object)BoatEntity.Type.DARK_OAK, (Object)new ItemStack((IItemProvider)Items.field_185154_aL));
            m.defaultReturnValue((Object)ItemStack.field_190927_a);
        });
        ITEM_FRAME_STACK = new ItemStack((IItemProvider)Items.field_151160_bD);
        PAINTING_STACK = new ItemStack((IItemProvider)Items.field_151159_an);
        LEAD_STACK = new ItemStack((IItemProvider)Items.field_151058_ca);
    }
}

