/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCarpetBlock;
import net.geforcemods.securitycraft.entity.SecurityCameraEntity;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.PlaySoundAtPos;
import net.geforcemods.securitycraft.network.client.SendTip;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    private static final String PREVIOUS_PLAYER_POS_NBT = "SecurityCraftPreviousPlayerPos";

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.getPersistentData().func_74764_b(PREVIOUS_PLAYER_POS_NBT)) {
            BlockPos pos = BlockPos.func_218283_e((long)player.getPersistentData().func_74763_f(PREVIOUS_PLAYER_POS_NBT));
            player.getPersistentData().func_82580_o(PREVIOUS_PLAYER_POS_NBT);
            player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SendTip());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEntity player = event.getPlayer();
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            BlockPos pos = new BlockPos(((SecurityCameraEntity)player.func_184187_bx()).getPreviousPlayerPos());
            player.func_184187_bx().func_70106_y();
            player.getPersistentData().func_74772_a(PREVIOUS_PLAYER_POS_NBT, pos.func_218275_a());
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        if (event.getEntity() != null && PlayerUtils.isPlayerMountedOnCamera(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() == CustomDamageSources.ELECTRICITY) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new PlaySoundAtPos(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), SCSounds.ELECTRIFIED.path, 0.25, "blocks"));
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        List sentries;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
            return;
        }
        World world = event.getWorld();
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(event.getPos());
            BlockState state = world.func_180495_p(event.getPos());
            Block block = state.func_177230_c();
            if (PlayerUtils.isHoldingItem(event.getPlayer(), SCContent.KEY_PANEL, event.getHand())) {
                for (IPasswordConvertible pc : SecurityCraftAPI.getRegisteredPasswordConvertibles()) {
                    if (pc.getOriginalBlock() != block) continue;
                    event.setUseBlock(Event.Result.DENY);
                    event.setUseItem(Event.Result.ALLOW);
                }
                return;
            }
            if (PlayerUtils.isHoldingItem(event.getPlayer(), SCContent.CODEBREAKER, event.getHand()) && SCEventHandler.handleCodebreaking(event)) {
                event.setCanceled(true);
                return;
            }
            if (tileEntity instanceof INameable && ((INameable)tileEntity).canBeNamed() && PlayerUtils.isHoldingItem(event.getPlayer(), Items.field_151057_cb, event.getHand()) && event.getPlayer().func_184586_b(event.getHand()).func_82837_s()) {
                ItemStack nametag = event.getPlayer().func_184586_b(event.getHand());
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
                if (((INameable)tileEntity).getCustomSCName().equals(nametag.func_200301_q())) {
                    PlayerUtils.sendMessageToPlayer(event.getPlayer(), (IFormattableTextComponent)new TranslationTextComponent(tileEntity.func_195044_w().func_177230_c().func_149739_a()), (IFormattableTextComponent)Utils.localize("messages.securitycraft:naming.alreadyMatches", ((INameable)tileEntity).getCustomSCName()), TextFormatting.RED);
                    return;
                }
                if (!event.getPlayer().func_184812_l_()) {
                    nametag.func_190918_g(1);
                }
                ((INameable)tileEntity).setCustomSCName(nametag.func_200301_q());
                PlayerUtils.sendMessageToPlayer(event.getPlayer(), (IFormattableTextComponent)new TranslationTextComponent(tileEntity.func_195044_w().func_177230_c().func_149739_a()), (IFormattableTextComponent)Utils.localize("messages.securitycraft:naming.named", ((INameable)tileEntity).getCustomSCName()), TextFormatting.RED);
                return;
            }
        }
        if (!(sentries = world.func_217357_a(SentryEntity.class, new AxisAlignedBB(event.getPos()))).isEmpty()) {
            event.setCanceled(((SentryEntity)((Object)sentries.get(0))).func_230254_b_(event.getPlayer(), event.getHand()) == ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteracted(PlayerInteractEvent.EntityInteract event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        ItemStack disguiseModule;
        ArrayList<Block> blocks;
        List sentries;
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        if (!event.getWorld().func_201670_d() && event.getWorld().func_175625_s(event.getPos()) instanceof IModuleInventory) {
            IModuleInventory te = (IModuleInventory)event.getWorld().func_175625_s(event.getPos());
            for (int i = 0; i < te.getMaxNumberOfModules(); ++i) {
                if (((ItemStack)te.getInventory().get(i)).func_190926_b()) continue;
                ItemStack stack = (ItemStack)te.getInventory().get(i);
                ItemEntity item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), stack);
                WorldUtils.addScheduledTask(event.getWorld(), () -> event.getWorld().func_217376_c((Entity)item));
                te.onModuleRemoved(stack, ((ModuleItem)stack.func_77973_b()).getModuleType());
                if (te instanceof CustomizableTileEntity) {
                    ((CustomizableTileEntity)te).createLinkedBlockAction(LinkedAction.MODULE_REMOVED, new Object[]{stack, ((ModuleItem)stack.func_77973_b()).getModuleType()}, (CustomizableTileEntity)te);
                }
                if (!(te instanceof SecurityCameraTileEntity)) continue;
                SecurityCameraTileEntity cam = (SecurityCameraTileEntity)te;
                cam.func_145831_w().func_195593_d(cam.func_174877_v().func_177967_a((Direction)cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177229_b((Property)SecurityCameraBlock.FACING), -1), cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177230_c());
            }
        }
        if (!(sentries = ((World)event.getWorld()).func_217357_a(SentryEntity.class, new AxisAlignedBB(event.getPos()))).isEmpty() && !((SentryEntity)((Object)sentries.get(0))).getDisguiseModule().func_190926_b() && (blocks = ((ModuleItem)(disguiseModule = ((SentryEntity)((Object)sentries.get(0))).getDisguiseModule()).func_77973_b()).getBlockAddons(disguiseModule.func_77978_p())).size() > 0 && blocks.get(0) == event.getWorld().func_180495_p(event.getPos()).func_177230_c()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te instanceof IOwnable) {
            String name = event.getPlayer().func_200200_C_().getString();
            String uuid = event.getPlayer().func_146103_bH().getId().toString();
            ((IOwnable)te).setOwner(uuid, name);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity && PlayerUtils.isPlayerMountedOnCamera(event.getTarget()) || event.getTarget() instanceof SentryEntity) {
            ((MobEntity)event.getEntity()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Block block;
        Item held;
        if (event.getPlayer() != null && ((held = event.getPlayer().func_184614_ca().func_77973_b()) == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()) && (block = IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.get(event.getState().func_177230_c())) != null) {
            event.setNewSpeed(10000.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof WitherEntity && event.getState().func_177230_c() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (event.isDismounting() && event.getEntityBeingMounted() instanceof SecurityCameraEntity && event.getEntityMounting() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityMounting();
            TileEntity te = event.getWorldObj().func_175625_s(event.getEntityBeingMounted().func_233580_cy_());
            if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player) && te instanceof SecurityCameraTileEntity && ((SecurityCameraTileEntity)te).hasModule(ModuleType.SMART)) {
                ((SecurityCameraTileEntity)te).lastPitch = player.field_70125_A;
                ((SecurityCameraTileEntity)te).lastYaw = player.field_70177_z;
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer()) && event.getItemStack().func_77973_b() != SCContent.CAMERA_MONITOR.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof ReinforcedCarpetBlock) {
            event.setBurnTime(0);
        }
    }

    private static boolean handleCodebreaking(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getPlayer().field_70170_p;
        TileEntity tileEntity = world.func_175625_s(event.getPos());
        if (tileEntity instanceof IPasswordProtected && ((IPasswordProtected)tileEntity).isCodebreakable()) {
            if (((Boolean)ConfigHandler.SERVER.allowCodebreakerItem.get()).booleanValue()) {
                if (event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == SCContent.CODEBREAKER.get()) {
                    event.getPlayer().func_184586_b(event.getHand()).func_222118_a(1, (LivingEntity)event.getPlayer(), p -> p.func_213334_d(event.getHand()));
                }
                if (event.getPlayer().func_184812_l_() || new Random().nextInt(3) == 1) {
                    return ((IPasswordProtected)tileEntity).onCodebreakerUsed(world.func_180495_p(event.getPos()), event.getPlayer());
                }
                PlayerUtils.sendMessageToPlayer(event.getPlayer(), (IFormattableTextComponent)new TranslationTextComponent(((Item)SCContent.CODEBREAKER.get()).func_77658_a()), (IFormattableTextComponent)Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), TextFormatting.RED);
                return true;
            }
            Block block = world.func_180495_p(event.getPos()).func_177230_c();
            PlayerUtils.sendMessageToPlayer(event.getPlayer(), (IFormattableTextComponent)Utils.localize(block.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        }
        return false;
    }
}

