/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.tileentity.KeypadTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class KeypadBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public KeypadBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return ActionResultType.PASS;
        }
        KeypadTileEntity te = (KeypadTileEntity)world.func_175625_s(pos);
        if (ModuleUtils.isDenied(te, (Entity)player)) {
            if (te.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
            }
            return ActionResultType.FAIL;
        }
        if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
            if (te.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
            }
            KeypadBlock.activate(world, pos, te.getSignalLength());
        } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand) && !PlayerUtils.isHoldingItem(player, SCContent.KEY_PANEL, hand)) {
            te.openPasswordGUI(player);
        }
        return ActionResultType.SUCCESS;
    }

    public static void activate(World world, BlockPos pos, int signalLength) {
        world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        world.func_195593_d(pos, (Block)SCContent.KEYPAD.get());
        world.func_205220_G_().func_205360_a(pos, (Object)SCContent.KEYPAD.get(), signalLength);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        world.func_195593_d(pos, (Block)SCContent.KEYPAD.get());
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d())).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{POWERED});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KeypadTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public static class Convertible
    implements IPasswordConvertible {
        @Override
        public Block getOriginalBlock() {
            return (Block)SCContent.FRAME.get();
        }

        @Override
        public boolean convert(PlayerEntity player, World world, BlockPos pos) {
            world.func_175656_a(pos, (BlockState)((BlockState)((Block)SCContent.KEYPAD.get()).func_176223_P().func_206870_a((Property)FACING, world.func_180495_p(pos).func_177229_b((Property)FrameBlock.FACING))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            ((IOwnable)world.func_175625_s(pos)).setOwner(player.func_110124_au().toString(), player.func_200200_C_().getString());
            return true;
        }
    }
}

