/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.Optional;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.PlaySoundAtPos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class TaserItem
extends Item {
    public boolean powered;

    public TaserItem(Item.Properties properties, boolean isPowered) {
        super(properties);
        this.powered = isPowered;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!(group != SecurityCraft.groupSCTechnical && group != ItemGroup.field_78027_g || this.powered)) {
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() == SCContent.TASER.get() && newStack.func_77973_b() == SCContent.TASER_POWERED.get() || oldStack.func_77973_b() == SCContent.TASER_POWERED.get() && newStack.func_77973_b() == SCContent.TASER.get();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_77951_h()) {
            LivingEntity entity;
            if (player.func_213453_ef() && (player.func_184812_l_() || !this.powered)) {
                ItemStack oneRedstone = new ItemStack((IItemProvider)Items.field_151137_ax, 1);
                if (player.func_184812_l_()) {
                    if (player.func_184586_b(hand).func_77973_b() == SCContent.TASER.get()) {
                        this.setSlotBasedOnHand(player, hand, new ItemStack((IItemProvider)SCContent.TASER_POWERED.get(), 1));
                    } else {
                        this.setSlotBasedOnHand(player, hand, new ItemStack((IItemProvider)SCContent.TASER.get(), 1));
                    }
                    return ActionResult.func_226248_a_((Object)stack);
                }
                if (player.field_71071_by.func_70431_c(oneRedstone)) {
                    int redstoneSlot = player.field_71071_by.func_194014_c(oneRedstone);
                    ItemStack redstoneStack = player.field_71071_by.func_70301_a(redstoneSlot);
                    redstoneStack.func_190920_e(redstoneStack.func_190916_E() - 1);
                    player.field_71071_by.func_70299_a(redstoneSlot, redstoneStack);
                    this.setSlotBasedOnHand(player, hand, new ItemStack((IItemProvider)SCContent.TASER_POWERED.get(), 1));
                    return ActionResult.func_226248_a_((Object)stack);
                }
                return ActionResult.func_226250_c_((Object)stack);
            }
            int range = 11;
            Vector3d startVec = player.func_174824_e(1.0f);
            Vector3d lookVec = player.func_70676_i(1.0f).func_186678_a((double)range);
            Vector3d endVec = startVec.func_178787_e(lookVec);
            AxisAlignedBB boundingBox = player.func_174813_aQ().func_216361_a(lookVec).func_72314_b(1.0, 1.0, 1.0);
            EntityRayTraceResult entityRayTraceResult = TaserItem.rayTraceEntities((Entity)player, startVec, endVec, boundingBox, s -> s instanceof LivingEntity, range * range);
            if (!world.field_72995_K) {
                SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new PlaySoundAtPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SCSounds.TASERFIRED.path, 1.0, "players"));
            }
            if (entityRayTraceResult != null && !(entity = (LivingEntity)entityRayTraceResult.func_216348_a()).func_184585_cz() && entity.func_70097_a(CustomDamageSources.TASER, this.powered ? 2.0f : 1.0f)) {
                int strength = this.powered ? 4 : 1;
                int length = this.powered ? 400 : 200;
                entity.func_195064_c(new EffectInstance(Effects.field_76437_t, length, strength));
                entity.func_195064_c(new EffectInstance(Effects.field_76431_k, length, strength));
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, length, strength));
            }
            if (!player.func_184812_l_()) {
                if (this.powered) {
                    ItemStack taser = new ItemStack((IItemProvider)SCContent.TASER.get(), 1);
                    taser.func_222118_a(150, (LivingEntity)player, p -> p.func_213334_d(hand));
                    this.setSlotBasedOnHand(player, hand, taser);
                } else {
                    stack.func_222118_a(150, (LivingEntity)player, p -> p.func_213334_d(hand));
                }
            }
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    private static EntityRayTraceResult rayTraceEntities(Entity shooter, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double dist) {
        World world = shooter.field_70170_p;
        double distance = dist;
        Entity rayTracedEntity = null;
        Vector3d hitVec = null;
        for (Entity entity : world.func_175674_a(shooter, boundingBox, filter)) {
            Vector3d vector;
            double sqDist;
            AxisAlignedBB boxToCheck = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            Optional optional = boxToCheck.func_216365_b(startVec, endVec);
            if (boxToCheck.func_72318_a(startVec)) {
                if (!(distance >= 0.0)) continue;
                rayTracedEntity = entity;
                hitVec = optional.orElse(startVec);
                distance = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((sqDist = startVec.func_72436_e(vector = (Vector3d)optional.get())) < distance) && distance != 0.0) continue;
            if (entity.func_184208_bv() == shooter.func_184208_bv() && !entity.canRiderInteract()) {
                if (distance != 0.0) continue;
                rayTracedEntity = entity;
                hitVec = vector;
                continue;
            }
            rayTracedEntity = entity;
            hitVec = vector;
            distance = sqDist;
        }
        return rayTracedEntity == null ? null : new EntityRayTraceResult(rayTracedEntity, hitVec);
    }

    private void setSlotBasedOnHand(PlayerEntity player, Hand hand, ItemStack taser) {
        if (hand == Hand.MAIN_HAND) {
            player.func_184201_a(EquipmentSlotType.MAINHAND, taser);
        } else {
            player.func_184201_a(EquipmentSlotType.OFFHAND, taser);
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World world, Entity entity, int slotIndex, boolean isSelected) {
        if (!world.field_72995_K && par1ItemStack.func_77952_i() >= 1) {
            par1ItemStack.func_196085_b(par1ItemStack.func_77952_i() - 1);
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }
}

