/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.geforcemods.securitycraft.SecurityCraft;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class TileEntityNBTCondition
implements ILootCondition {
    private String key;
    private boolean value;

    private TileEntityNBTCondition(String key, boolean value) {
        this.key = key;
        this.value = value;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_237457_g_);
    }

    public boolean test(LootContext lootContext) {
        TileEntity te = lootContext.func_202879_g().func_175625_s(new BlockPos((Vector3d)lootContext.func_216031_c(LootParameters.field_237457_g_)));
        CompoundNBT nbt = te.func_189515_b(new CompoundNBT());
        return nbt.func_74764_b(this.key) && nbt.func_74767_n(this.key) == this.value;
    }

    public LootConditionType func_230419_b_() {
        return SecurityCraft.TILE_ENTITY_NBT_LOOT_CONDITION;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Serializer
    implements ILootSerializer<TileEntityNBTCondition> {
        public void serialize(JsonObject json, TileEntityNBTCondition condition, JsonSerializationContext ctx) {
            json.addProperty("key", condition.key);
            json.addProperty("value", Boolean.valueOf(condition.value));
        }

        public TileEntityNBTCondition deserialize(JsonObject json, JsonDeserializationContext ctx) {
            return new TileEntityNBTCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"key"), JSONUtils.func_151212_i((JsonObject)json, (String)"value"));
        }
    }

    public static class Builder
    implements ILootCondition.IBuilder {
        private String key;
        private boolean value;

        public Builder equals(String key, boolean value) {
            this.key = key;
            this.value = value;
            return this;
        }

        public ILootCondition build() {
            return new TileEntityNBTCondition(this.key, this.value);
        }
    }
}

