/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class RemoteControlMine {
    private int x;
    private int y;
    private int z;
    private String state;

    public RemoteControlMine() {
    }

    public RemoteControlMine(int x, int y, int z, String state) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.state = state;
    }

    public static void encode(RemoteControlMine message, PacketBuffer buf) {
        buf.writeInt(message.x);
        buf.writeInt(message.y);
        buf.writeInt(message.z);
        buf.func_180714_a(message.state);
    }

    public static RemoteControlMine decode(PacketBuffer buf) {
        RemoteControlMine message = new RemoteControlMine();
        message.x = buf.readInt();
        message.y = buf.readInt();
        message.z = buf.readInt();
        message.state = buf.func_150789_c(0x1FFFFFFF);
        return message;
    }

    public static void onMessage(RemoteControlMine message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof IExplosive) {
                IExplosive explosive = (IExplosive)state.func_177230_c();
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof IOwnable && ((IOwnable)te).getOwner().isOwner((PlayerEntity)player)) {
                    if (message.state.equalsIgnoreCase("activate")) {
                        explosive.activateMine(world, pos);
                    } else if (message.state.equalsIgnoreCase("defuse")) {
                        explosive.defuseMine(world, pos);
                    } else if (message.state.equalsIgnoreCase("detonate")) {
                        explosive.explode(world, pos);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

