/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class TogglePictureButton
extends IdButton {
    private ResourceLocation textureLocation;
    private int[] u;
    private int[] v;
    private int currentIndex = 0;
    private final int toggleCount;
    private final int drawOffset;
    private final int drawWidth;
    private final int drawHeight;
    private final int uWidth;
    private final int vHeight;
    private final int textureWidth;
    private final int textureHeight;

    public TogglePictureButton(int id, int xPos, int yPos, int width, int height, ResourceLocation texture, int[] textureX, int[] textureY, int drawOffset, int toggleCount, Consumer<IdButton> onClick) {
        this(id, xPos, yPos, width, height, texture, textureX, textureY, drawOffset, 16, 16, 16, 16, 256, 256, toggleCount, onClick);
    }

    public TogglePictureButton(int id, int xPos, int yPos, int width, int height, ResourceLocation texture, int[] textureX, int[] textureY, int drawOffset, int drawWidth, int drawHeight, int uWidth, int vHeight, int textureWidth, int textureHeight, int toggleCount, Consumer<IdButton> onClick) {
        super(id, xPos, yPos, width, height, "", onClick);
        if (textureX.length != toggleCount || textureY.length != toggleCount) {
            throw new RuntimeException("TogglePictureButton was set up incorrectly. Array lengths must match toggleCount!");
        }
        this.textureLocation = texture;
        this.u = textureX;
        this.v = textureY;
        this.toggleCount = toggleCount;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.drawOffset = drawOffset;
        this.drawWidth = drawWidth;
        this.drawHeight = drawHeight;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            GuiUtils.drawContinuousTexturedBox((MatrixStack)matrix, (ResourceLocation)field_230687_i_, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (int)(46 + this.func_230989_a_(this.func_230449_g_()) * 20), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.func_230927_p_());
            if (this.getTextureLocation() != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTextureLocation());
                TogglePictureButton.func_238466_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + this.drawOffset), (int)(this.field_230691_m_ + this.drawOffset), (int)this.drawWidth, (int)this.drawHeight, (float)this.u[this.currentIndex], (float)this.v[this.currentIndex], (int)this.uWidth, (int)this.vHeight, (int)this.textureWidth, (int)this.textureHeight);
            }
        }
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.setCurrentIndex(this.currentIndex + 1);
        super.func_230982_a_(mouseX, mouseY);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int newIndex) {
        this.currentIndex = newIndex % this.toggleCount;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }
}

