/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.container.TabulaCubeContainer;
import com.github.alexthe666.citadel.client.model.container.TabulaCubeGroupContainer;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TabulaModel
extends AdvancedEntityModel {
    protected Map<String, AdvancedModelBox> cubes = new HashMap<String, AdvancedModelBox>();
    protected List<AdvancedModelBox> rootBoxes = new ArrayList<AdvancedModelBox>();
    protected ITabulaModelAnimator tabulaAnimator;
    public ModelAnimator llibAnimator;
    protected Map<String, AdvancedModelBox> identifierMap = new HashMap<String, AdvancedModelBox>();
    protected double[] scale;

    public TabulaModel(TabulaModelContainer container, ITabulaModelAnimator tabulaAnimator) {
        this.field_78090_t = container.getTextureWidth();
        this.field_78089_u = container.getTextureHeight();
        this.tabulaAnimator = tabulaAnimator;
        for (TabulaCubeContainer cube : container.getCubes()) {
            this.parseCube(cube, null);
        }
        container.getCubeGroups().forEach(this::parseCubeGroup);
        this.updateDefaultPose();
        this.scale = container.getScale();
        this.llibAnimator = ModelAnimator.create();
    }

    public TabulaModel(TabulaModelContainer container) {
        this(container, null);
    }

    private void parseCubeGroup(TabulaCubeGroupContainer container) {
        for (TabulaCubeContainer cube : container.getCubes()) {
            this.parseCube(cube, null);
        }
        container.getCubeGroups().forEach(this::parseCubeGroup);
    }

    private void parseCube(TabulaCubeContainer cube, AdvancedModelBox parent) {
        AdvancedModelBox box = this.createBox(cube);
        this.cubes.put(cube.getName(), box);
        this.identifierMap.put(cube.getIdentifier(), box);
        if (parent != null) {
            parent.func_78792_a(box);
        } else {
            this.rootBoxes.add(box);
        }
        for (TabulaCubeContainer child : cube.getChildren()) {
            this.parseCube(child, box);
        }
    }

    private AdvancedModelBox createBox(TabulaCubeContainer cube) {
        int[] textureOffset = cube.getTextureOffset();
        double[] position = cube.getPosition();
        double[] rotation = cube.getRotation();
        double[] offset = cube.getOffset();
        int[] dimensions = cube.getDimensions();
        float scaleIn = 0.0f;
        AdvancedModelBox box = new AdvancedModelBox(this, cube.getName());
        box.setTextureOffset(textureOffset[0], textureOffset[1]);
        box.field_78809_i = cube.isTextureMirrorEnabled();
        box.func_78793_a((float)position[0], (float)position[1], (float)position[2]);
        box.func_228301_a_((float)offset[0], (float)offset[1], (float)offset[2], dimensions[0], dimensions[1], dimensions[2], scaleIn);
        box.field_78795_f = (float)Math.toRadians(rotation[0]);
        box.field_78796_g = (float)Math.toRadians(rotation[1]);
        box.field_78808_h = (float)Math.toRadians(rotation[2]);
        return box;
    }

    public void func_225597_a_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch) {
        if (this.tabulaAnimator != null) {
            this.tabulaAnimator.setRotationAngles(this, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, 1.0f);
        }
    }

    public AdvancedModelBox getCube(String name) {
        return this.cubes.get(name);
    }

    public AdvancedModelBox getCubeByIdentifier(String identifier) {
        return this.identifierMap.get(identifier);
    }

    public Map<String, AdvancedModelBox> getCubes() {
        return this.cubes;
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.copyOf(this.rootBoxes);
    }

    @Override
    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.copyOf(this.cubes.values());
    }
}

