/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigDouble;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.config.IConfigOptionList;
import fi.dy.masa.malilib.config.IConfigResettable;
import fi.dy.masa.malilib.config.IConfigSlider;
import fi.dy.masa.malilib.config.IConfigStringList;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.IStringRepresentable;
import fi.dy.masa.malilib.config.gui.ConfigOptionChangeListenerButton;
import fi.dy.masa.malilib.config.gui.ConfigOptionChangeListenerKeybind;
import fi.dy.masa.malilib.config.gui.ConfigOptionChangeListenerTextField;
import fi.dy.masa.malilib.config.gui.ConfigOptionListenerResetConfig;
import fi.dy.masa.malilib.config.gui.SliderCallbackDouble;
import fi.dy.masa.malilib.config.gui.SliderCallbackInteger;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ConfigButtonBoolean;
import fi.dy.masa.malilib.gui.button.ConfigButtonKeybind;
import fi.dy.masa.malilib.gui.button.ConfigButtonOptionList;
import fi.dy.masa.malilib.gui.button.ConfigButtonStringList;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IConfigInfoProvider;
import fi.dy.masa.malilib.gui.interfaces.IKeybindConfigGui;
import fi.dy.masa.malilib.gui.interfaces.ISliderCallback;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOptionBase;
import fi.dy.masa.malilib.gui.widgets.WidgetHoverInfo;
import fi.dy.masa.malilib.gui.widgets.WidgetKeybindSettings;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptionsBase;
import fi.dy.masa.malilib.gui.widgets.WidgetSlider;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;

public class WidgetConfigOption
extends WidgetConfigOptionBase<GuiConfigsBase.ConfigOptionWrapper> {
    protected final GuiConfigsBase.ConfigOptionWrapper wrapper;
    protected final IKeybindConfigGui host;
    @Nullable
    protected final KeybindSettings initialKeybindSettings;
    @Nullable
    protected ImmutableList<String> initialStringList;
    protected int colorDisplayPosX;

    public WidgetConfigOption(int x, int y, int width, int height, int labelWidth, int configWidth, GuiConfigsBase.ConfigOptionWrapper wrapper, int listIndex, IKeybindConfigGui host, WidgetListConfigOptionsBase<?, ?> parent) {
        super(x, y, width, height, parent, wrapper, listIndex);
        this.host = host;
        this.wrapper = wrapper;
        if (wrapper.getType() == GuiConfigsBase.ConfigOptionWrapper.Type.CONFIG) {
            IConfigBase config = wrapper.getConfig();
            if (wrapper.getConfig() instanceof IStringRepresentable) {
                IStringRepresentable configStr = (IStringRepresentable)((Object)config);
                this.initialStringValue = configStr.getStringValue();
                this.lastAppliedValue = configStr.getStringValue();
                this.initialKeybindSettings = config.getType() == ConfigType.HOTKEY ? ((IHotkey)config).getKeybind().getSettings() : null;
            } else {
                this.initialStringValue = null;
                this.lastAppliedValue = null;
                this.initialKeybindSettings = null;
                if (wrapper.getConfig() instanceof IConfigStringList) {
                    this.initialStringList = ImmutableList.copyOf(((IConfigStringList)wrapper.getConfig()).getStrings());
                }
            }
            this.addConfigOption(x, y, this.zLevel, labelWidth, configWidth, config);
        } else {
            this.initialStringValue = null;
            this.lastAppliedValue = null;
            this.initialKeybindSettings = null;
            this.addLabel(x, y + 7, labelWidth, 8, -1, wrapper.getLabel());
        }
    }

    protected void addConfigOption(int x, int y, float zLevel, int labelWidth, int configWidth, IConfigBase config) {
        ConfigType type = config.getType();
        int configHeight = 20;
        this.addLabel(x, ++y + 7, labelWidth, 8, -1, config.getConfigGuiDisplayName());
        String comment = null;
        IConfigInfoProvider infoProvider = this.host.getHoverInfoProvider();
        comment = infoProvider != null ? infoProvider.getHoverInfo(config) : config.getComment();
        if (comment != null) {
            this.addConfigComment(x, y + 5, labelWidth, 12, comment);
        }
        x += labelWidth + 10;
        if (type == ConfigType.BOOLEAN) {
            ConfigButtonBoolean optionButton = new ConfigButtonBoolean(x, y, configWidth, configHeight, (IConfigBoolean)config);
            this.addConfigButtonEntry(x + configWidth + 4, y, (IConfigResettable)((Object)config), optionButton);
        } else if (type == ConfigType.OPTION_LIST) {
            ConfigButtonOptionList optionButton = new ConfigButtonOptionList(x, y, configWidth, configHeight, (IConfigOptionList)((Object)config));
            this.addConfigButtonEntry(x + configWidth + 4, y, (IConfigResettable)((Object)config), optionButton);
        } else if (type == ConfigType.STRING_LIST) {
            ConfigButtonStringList optionButton = new ConfigButtonStringList(x, y, configWidth, configHeight, (IConfigStringList)config, this.host, this.host.getDialogHandler());
            this.addConfigButtonEntry(x + configWidth + 4, y, (IConfigResettable)((Object)config), optionButton);
        } else if (type == ConfigType.HOTKEY) {
            IKeybind keybind = ((IHotkey)config).getKeybind();
            ConfigButtonKeybind keybindButton = new ConfigButtonKeybind(x, y, configWidth -= 25, configHeight, keybind, this.host);
            this.addWidget(new WidgetKeybindSettings(x += configWidth + 4, y, 20, 20, keybind, config.getName(), this.parent, this.host.getDialogHandler()));
            this.addButton(keybindButton, this.host.getButtonPressListener());
            this.addKeybindResetButton(x += 25, y, keybind, keybindButton);
        } else if (type == ConfigType.STRING || type == ConfigType.COLOR || type == ConfigType.INTEGER || type == ConfigType.DOUBLE) {
            int resetX = x + configWidth + 4;
            if (type == ConfigType.COLOR) {
                this.colorDisplayPosX = x + (configWidth -= 24) + 4;
            } else if (type == ConfigType.INTEGER || type == ConfigType.DOUBLE) {
                this.colorDisplayPosX = x + (configWidth -= 18) + 2;
            }
            if ((type == ConfigType.INTEGER || type == ConfigType.DOUBLE) && config instanceof IConfigSlider && ((IConfigSlider)config).shouldUseSlider()) {
                this.addConfigSliderEntry(x, y, resetX, configWidth, configHeight, (IConfigSlider)config);
            } else {
                this.addConfigTextFieldEntry(x, y, resetX, configWidth, configHeight, (IConfigValue)config);
            }
            if (config instanceof IConfigSlider) {
                MaLiLibIcons icon = ((IConfigSlider)config).shouldUseSlider() ? MaLiLibIcons.BTN_TXTFIELD : MaLiLibIcons.BTN_SLIDER;
                ButtonGeneric toggleBtn = new ButtonGeneric(this.colorDisplayPosX, y + 2, icon, new String[0]);
                this.addButton(toggleBtn, new ListenerSliderToggle((IConfigSlider)config));
            }
        }
    }

    @Override
    public boolean wasConfigModified() {
        if (this.wrapper.getType() == GuiConfigsBase.ConfigOptionWrapper.Type.CONFIG) {
            IConfigBase config = this.wrapper.getConfig();
            boolean modified = false;
            if (this.wrapper.getConfig() instanceof IStringRepresentable) {
                if (this.textField != null) {
                    modified |= !this.initialStringValue.equals(this.textField.getTextField().func_146179_b());
                }
                if (this.initialKeybindSettings != null && !this.initialKeybindSettings.equals(((IHotkey)config).getKeybind().getSettings())) {
                    modified = true;
                }
                return modified || !this.initialStringValue.equals(((IStringRepresentable)((Object)config)).getStringValue());
            }
            if (this.initialStringList != null && this.wrapper.getConfig() instanceof IConfigStringList) {
                return !this.initialStringList.equals(((IConfigStringList)this.wrapper.getConfig()).getStrings());
            }
        }
        return false;
    }

    @Override
    public void applyNewValueToConfig() {
        if (this.wrapper.getType() == GuiConfigsBase.ConfigOptionWrapper.Type.CONFIG && this.wrapper.getConfig() instanceof IStringRepresentable) {
            IStringRepresentable config = (IStringRepresentable)((Object)this.wrapper.getConfig());
            if (this.textField != null && this.hasPendingModifications()) {
                config.setValueFromString(this.textField.getTextField().func_146179_b());
            }
            this.lastAppliedValue = config.getStringValue();
        }
    }

    protected void addConfigComment(int x, int y, int width, int height, String comment) {
        this.addWidget(new WidgetHoverInfo(x, y, width, height, comment, new Object[0]));
    }

    protected void addConfigButtonEntry(int xReset, int yReset, IConfigResettable config, ButtonBase optionButton) {
        ButtonGeneric resetButton = this.createResetButton(xReset, yReset, config);
        ConfigOptionChangeListenerButton listenerChange = new ConfigOptionChangeListenerButton(config, resetButton, null);
        ConfigOptionListenerResetConfig listenerReset = new ConfigOptionListenerResetConfig(config, new ConfigOptionListenerResetConfig.ConfigResetterButton(optionButton), resetButton, null);
        this.addButton(optionButton, listenerChange);
        this.addButton(resetButton, listenerReset);
    }

    protected void addConfigTextFieldEntry(int x, int y, int resetX, int configWidth, int configHeight, IConfigValue config) {
        GuiTextFieldGeneric field = this.createTextField(x, y + 1, configWidth - 4, configHeight - 3);
        field.func_146203_f(this.maxTextfieldTextLength);
        field.func_146180_a(config.getStringValue());
        ButtonGeneric resetButton = this.createResetButton(resetX, y, config);
        ConfigOptionChangeListenerTextField listenerChange = new ConfigOptionChangeListenerTextField(config, field, resetButton);
        ConfigOptionListenerResetConfig listenerReset = new ConfigOptionListenerResetConfig(config, new ConfigOptionListenerResetConfig.ConfigResetterTextField(config, field), resetButton, null);
        this.addTextField(field, listenerChange);
        this.addButton(resetButton, listenerReset);
    }

    protected void addConfigSliderEntry(int x, int y, int resetX, int configWidth, int configHeight, IConfigSlider config) {
        ISliderCallback callback;
        ButtonGeneric resetButton = this.createResetButton(resetX, y, config);
        if (config instanceof IConfigDouble) {
            callback = new SliderCallbackDouble((IConfigDouble)config, resetButton);
        } else if (config instanceof IConfigInteger) {
            callback = new SliderCallbackInteger((IConfigInteger)config, resetButton);
        } else {
            return;
        }
        WidgetSlider slider = new WidgetSlider(x, y, configWidth, configHeight, callback);
        ConfigOptionListenerResetConfig listenerReset = new ConfigOptionListenerResetConfig(config, null, resetButton, null);
        this.addWidget(slider);
        this.addButton(resetButton, listenerReset);
    }

    protected void addKeybindResetButton(int x, int y, IKeybind keybind, ConfigButtonKeybind buttonHotkey) {
        ButtonGeneric button = this.createResetButton(x, y, keybind);
        ConfigOptionChangeListenerKeybind listener = new ConfigOptionChangeListenerKeybind(keybind, buttonHotkey, button, this.host);
        this.host.addKeybindChangeListener(listener);
        this.addButton(button, listener);
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, MatrixStack matrixStack) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawSubWidgets(mouseX, mouseY, matrixStack);
        if (this.wrapper.getType() == GuiConfigsBase.ConfigOptionWrapper.Type.CONFIG) {
            IConfigBase config = this.wrapper.getConfig();
            this.drawTextFields(mouseX, mouseY, matrixStack);
            super.render(mouseX, mouseY, selected, matrixStack);
            if (config.getType() == ConfigType.COLOR) {
                int y = this.y + 1;
                RenderUtils.drawRect(this.colorDisplayPosX, y + 0, 19, 19, -1);
                RenderUtils.drawRect(this.colorDisplayPosX + 1, y + 1, 17, 17, -16777216);
                RenderUtils.drawRect(this.colorDisplayPosX + 2, y + 2, 15, 15, 0xFF000000 | ((ConfigColor)config).getIntegerValue());
            }
        }
    }

    public static class ListenerSliderToggle
    implements IButtonActionListener {
        protected final IConfigSlider config;

        public ListenerSliderToggle(IConfigSlider config) {
            this.config = config;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            this.config.toggleUseSlider();
            Screen gui = GuiUtils.getCurrentScreen();
            if (gui instanceof GuiBase) {
                ((GuiBase)gui).initGui();
            }
        }
    }
}

