/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.config.IConfigStringList;
import fi.dy.masa.malilib.gui.GuiStringListEdit;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptionsBase;
import fi.dy.masa.malilib.gui.widgets.WidgetStringListEditEntry;

public class WidgetListStringListEdit
extends WidgetListConfigOptionsBase<String, WidgetStringListEditEntry> {
    protected final GuiStringListEdit parent;

    public WidgetListStringListEdit(int x, int y, int width, int height, int configWidth, GuiStringListEdit parent) {
        super(x, y, width, height, configWidth);
        this.parent = parent;
    }

    @Override
    public GuiStringListEdit getParent() {
        return this.parent;
    }

    @Override
    protected void refreshBrowserEntries() {
        this.listContents.clear();
        this.listContents.addAll(this.parent.getConfig().getStrings());
        this.reCreateListEntryWidgets();
    }

    @Override
    protected void reCreateListEntryWidgets() {
        if (this.listContents.size() == 0) {
            this.listWidgets.clear();
            this.maxVisibleBrowserEntries = 1;
            int x = this.posX + 2;
            int y = this.posY + 4 + this.browserEntriesOffsetY;
            this.listWidgets.add(this.createListEntryWidget(x, y, -1, false, ""));
            this.scrollBar.setMaxValue(0);
        } else {
            super.reCreateListEntryWidgets();
        }
    }

    @Override
    protected WidgetStringListEditEntry createListEntryWidget(int x, int y, int listIndex, boolean isOdd, String entry) {
        IConfigStringList config = this.parent.getConfig();
        if (listIndex >= 0 && listIndex < config.getStrings().size()) {
            String defaultValue = config.getDefaultStrings().size() > listIndex ? (String)config.getDefaultStrings().get(listIndex) : "";
            return new WidgetStringListEditEntry(x, y, this.browserEntryWidth, this.browserEntryHeight, listIndex, isOdd, config.getStrings().get(listIndex), defaultValue, this);
        }
        return new WidgetStringListEditEntry(x, y, this.browserEntryWidth, this.browserEntryHeight, listIndex, isOdd, "", "", this);
    }
}

