/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiSchematicProjectsBrowser;
import fi.dy.masa.litematica.gui.widgets.WidgetListSchematicVersions;
import fi.dy.masa.litematica.gui.widgets.WidgetSchematicVersion;
import fi.dy.masa.litematica.schematic.projects.SchematicProject;
import fi.dy.masa.litematica.schematic.projects.SchematicVersion;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.util.SchematicUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfirmAction;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.interfaces.ICompletionListener;
import fi.dy.masa.malilib.interfaces.IConfirmationListener;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.BlockPos;

public class GuiSchematicProjectManager
extends GuiListBase<SchematicVersion, WidgetSchematicVersion, WidgetListSchematicVersions>
implements ISelectionListener<SchematicVersion>,
ICompletionListener {
    private final SchematicProject project;

    public GuiSchematicProjectManager(SchematicProject project) {
        super(10, 24);
        this.project = project;
        this.field_230704_d_ = StringUtils.translate((String)"litematica.gui.title.schematic_project_manager", (Object[])new Object[0]);
    }

    protected int getBrowserWidth() {
        return this.field_230708_k_ - 20;
    }

    protected int getBrowserHeight() {
        return this.field_230709_l_ - 74;
    }

    public void initGui() {
        super.initGui();
        this.createElements();
    }

    private void createElements() {
        int x = 10;
        int y = this.field_230709_l_ - 46;
        x += this.createButton(x, y, false, ButtonListener.Type.SAVE_VERSION);
        x += this.createButton(x, y, false, ButtonListener.Type.OPEN_AREA_EDITOR);
        x += this.createButton(x, y, false, ButtonListener.Type.MOVE_ORIGIN);
        x += this.createButton(x, y, false, ButtonListener.Type.PLACE_TO_WORLD);
        x += this.createButton(x, y, false, ButtonListener.Type.DELETE_AREA);
        x = 10;
        x += this.createButton(x, y += 22, false, ButtonListener.Type.OPEN_PROJECT_BROWSER);
        x += this.createButton(x, y, false, ButtonListener.Type.CLOSE_PROJECT);
    }

    private int createButton(int x, int y, boolean rightAlign, ButtonListener.Type type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, rightAlign, type.getTranslationKey(), new Object[0]);
        String hover = type.getHoverText();
        if (hover != null) {
            button.setHoverStrings(new String[]{hover});
        }
        this.addButton((ButtonBase)button, new ButtonListener(type, this));
        return button.getWidth() + 2;
    }

    private void reCreateGuiElements() {
        this.clearButtons();
        this.clearWidgets();
        this.createElements();
    }

    protected ISelectionListener<SchematicVersion> getSelectionListener() {
        return this;
    }

    public void onSelectionChange(@Nullable SchematicVersion entry) {
        if (entry != null) {
            this.project.switchVersion(entry, true);
            ((WidgetListSchematicVersions)this.getListWidget()).refreshEntries();
        }
        this.reCreateGuiElements();
    }

    public void onTaskCompleted() {
        ((WidgetListSchematicVersions)this.getListWidget()).refreshEntries();
    }

    protected WidgetListSchematicVersions createListWidget(int listX, int listY) {
        return new WidgetListSchematicVersions(listX, listY, this.getBrowserWidth() - 186, this.getBrowserHeight(), this.project, this);
    }

    public static class DeleteAreaExecutor
    implements IConfirmationListener {
        public boolean onActionConfirmed() {
            DataManager.getSchematicProjectsManager().deleteLastSeenArea(Minecraft.func_71410_x());
            return true;
        }

        public boolean onActionCancelled() {
            return false;
        }
    }

    public static class PlaceToWorldExecutor
    implements IConfirmationListener {
        public boolean onActionConfirmed() {
            DataManager.getSchematicProjectsManager().pasteCurrentVersionToWorld();
            return true;
        }

        public boolean onActionCancelled() {
            return false;
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final Type type;
        private final GuiSchematicProjectManager gui;

        public ButtonListener(Type type, GuiSchematicProjectManager gui) {
            this.type = type;
            this.gui = gui;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == Type.OPEN_PROJECT_BROWSER) {
                GuiSchematicProjectsBrowser gui = new GuiSchematicProjectsBrowser();
                GuiBase.openGui((Screen)gui);
            } else if (this.type == Type.SAVE_VERSION) {
                SchematicUtils.saveSchematic(false);
            } else if (this.type == Type.OPEN_AREA_EDITOR) {
                SelectionManager manager = DataManager.getSelectionManager();
                if (manager.getCurrentSelection() != null) {
                    manager.openEditGui(GuiUtils.getCurrentScreen());
                }
            } else if (this.type == Type.PLACE_TO_WORLD) {
                PlaceToWorldExecutor executor = new PlaceToWorldExecutor();
                String title = "litematica.gui.title.schematic_projects.confirm_place_to_world";
                String msg = "litematica.gui.message.schematic_projects.confirm_place_to_world";
                GuiConfirmAction gui = new GuiConfirmAction(320, title, (IConfirmationListener)executor, (Screen)this.gui, msg, new Object[0]);
                GuiBase.openGui((Screen)gui);
            } else if (this.type == Type.DELETE_AREA) {
                DeleteAreaExecutor executor = new DeleteAreaExecutor();
                String title = "litematica.gui.title.schematic_projects.confirm_delete_area";
                String msg = "litematica.gui.message.schematic_projects.confirm_delete_area";
                GuiConfirmAction gui = new GuiConfirmAction(320, title, (IConfirmationListener)executor, (Screen)this.gui, msg, new Object[0]);
                GuiBase.openGui((Screen)gui);
            } else if (this.type == Type.MOVE_ORIGIN) {
                SchematicProject project = DataManager.getSchematicProjectsManager().getCurrentProject();
                if (project != null) {
                    project.setOrigin(new BlockPos(Math.floor(this.gui.mc.field_71439_g.func_226277_ct_()), Math.floor(this.gui.mc.field_71439_g.func_226278_cu_()), Math.floor(this.gui.mc.field_71439_g.func_226281_cx_())));
                    this.gui.reCreateGuiElements();
                }
            } else if (this.type == Type.CLOSE_PROJECT) {
                DataManager.getSchematicProjectsManager().closeCurrentProject();
                GuiSchematicProjectsBrowser gui = new GuiSchematicProjectsBrowser();
                GuiBase.openGui((Screen)gui);
            }
        }

        public static enum Type {
            CLOSE_PROJECT("litematica.gui.button.schematic_projects.close_project"),
            DELETE_AREA("litematica.gui.button.schematic_projects.delete_area", "litematica.gui.button.hover.schematic_projects.delete_area"),
            MOVE_ORIGIN("litematica.gui.button.schematic_projects.move_origin_to_player", "litematica.gui.button.hover.schematic_projects.move_origin_to_player"),
            OPEN_AREA_EDITOR("litematica.gui.button.schematic_projects.open_area_editor"),
            OPEN_PROJECT_BROWSER("litematica.gui.button.schematic_projects.open_project_browser"),
            PLACE_TO_WORLD("litematica.gui.button.schematic_projects.place_to_world", "litematica.gui.button.hover.schematic_projects.place_to_world_warning"),
            SAVE_VERSION("litematica.gui.button.schematic_projects.save_version", "litematica.gui.button.hover.schematic_projects.save_new_version");

            private final String translationKey;
            @Nullable
            private final String hoverText;

            private Type(String label) {
                this(label, null);
            }

            private Type(String translationKey, String hoverText) {
                this.translationKey = translationKey;
                this.hoverText = hoverText;
            }

            public String getTranslationKey() {
                return this.translationKey;
            }

            @Nullable
            public String getHoverText() {
                return this.hoverText != null ? StringUtils.translate((String)this.hoverText, (Object[])new Object[0]) : null;
            }
        }
    }
}

