/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.base.Predicate;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class EntityUtils {
    public static final Predicate<Entity> NOT_PLAYER = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return !(entity instanceof PlayerEntity);
        }
    };

    public static boolean hasToolItem(LivingEntity entity) {
        ItemStack toolItem = DataManager.getToolItem();
        if (toolItem.func_190926_b()) {
            return entity.func_184614_ca().func_190926_b();
        }
        return EntityUtils.isHoldingItem(entity, toolItem);
    }

    public static boolean isHoldingItem(LivingEntity entity, ItemStack stackReference) {
        return !EntityUtils.getHeldItemOfType(entity, stackReference).func_190926_b();
    }

    public static ItemStack getHeldItemOfType(LivingEntity entity, ItemStack stackReference) {
        ItemStack stack = entity.func_184614_ca();
        if (!stack.func_190926_b() && EntityUtils.areStacksEqualIgnoreDurability(stack, stackReference)) {
            return stack;
        }
        stack = entity.func_184592_cb();
        if (!stack.func_190926_b() && EntityUtils.areStacksEqualIgnoreDurability(stack, stackReference)) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public static Hand getUsedHandForItem(PlayerEntity player, ItemStack stack) {
        Hand hand = null;
        if (InventoryUtils.areStacksEqual((ItemStack)player.func_184614_ca(), (ItemStack)stack)) {
            hand = Hand.MAIN_HAND;
        } else if (player.func_184614_ca().func_190926_b() && InventoryUtils.areStacksEqual((ItemStack)player.func_184592_cb(), (ItemStack)stack)) {
            hand = Hand.OFF_HAND;
        }
        return hand;
    }

    public static boolean areStacksEqualIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static Direction getHorizontalLookingDirection(Entity entity) {
        return Direction.func_176733_a((double)entity.field_70177_z);
    }

    public static Direction getVerticalLookingDirection(Entity entity) {
        return entity.field_70125_A > 0.0f ? Direction.DOWN : Direction.UP;
    }

    public static Direction getClosestLookingDirection(Entity entity) {
        if (entity.field_70125_A > 60.0f) {
            return Direction.DOWN;
        }
        if (-entity.field_70125_A > 60.0f) {
            return Direction.UP;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    @Nullable
    public static <T extends Entity> T findEntityByUUID(List<T> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return (T)entity;
        }
        return null;
    }

    @Nullable
    public static String getEntityId(Entity entity) {
        EntityType entitytype = entity.func_200600_R();
        ResourceLocation resourcelocation = EntityType.func_200718_a((EntityType)entitytype);
        return entitytype.func_200715_a() && resourcelocation != null ? resourcelocation.toString() : null;
    }

    @Nullable
    private static Entity createEntityFromNBTSingle(CompoundNBT nbt, World world) {
        try {
            Optional optional = EntityType.func_220330_a((CompoundNBT)nbt, (World)world);
            if (optional.isPresent()) {
                Entity entity = (Entity)optional.get();
                entity.func_184221_a(UUID.randomUUID());
                return entity;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static Entity createEntityAndPassengersFromNBT(CompoundNBT nbt, World world) {
        Entity entity = EntityUtils.createEntityFromNBTSingle(nbt, world);
        if (entity == null) {
            return null;
        }
        if (nbt.func_150297_b("Passengers", 9)) {
            ListNBT taglist = nbt.func_150295_c("Passengers", 10);
            for (int i = 0; i < taglist.size(); ++i) {
                Entity passenger = EntityUtils.createEntityAndPassengersFromNBT(taglist.func_150305_b(i), world);
                if (passenger == null) continue;
                passenger.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    public static void spawnEntityAndPassengersInWorld(Entity entity, World world) {
        if (world.func_217376_c(entity) && entity.func_184207_aI()) {
            for (Entity passenger : entity.func_184188_bt()) {
                passenger.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_() + entity.func_70042_X() + passenger.func_70033_W(), entity.func_226281_cx_(), passenger.field_70177_z, passenger.field_70125_A);
                EntityUtils.setEntityRotations(passenger, passenger.field_70177_z, passenger.field_70125_A);
                EntityUtils.spawnEntityAndPassengersInWorld(passenger, world);
            }
        }
    }

    public static void setEntityRotations(Entity entity, float yaw, float pitch) {
        entity.field_70177_z = yaw;
        entity.field_70126_B = yaw;
        entity.field_70125_A = pitch;
        entity.field_70127_C = pitch;
        if (entity instanceof LivingEntity) {
            LivingEntity livingBase = (LivingEntity)entity;
            livingBase.field_70759_as = yaw;
            livingBase.field_70761_aq = yaw;
            livingBase.field_70758_at = yaw;
            livingBase.field_70760_ar = yaw;
        }
    }

    public static List<Entity> getEntitiesWithinSubRegion(World world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos posEndAbs = PositionUtils.getTransformedPlacementPosition(regionSize.func_177982_a(-1, -1, -1), schematicPlacement, placement).func_177971_a((Vector3i)regionPosRelTransformed).func_177971_a((Vector3i)origin);
        BlockPos regionPosAbs = regionPosRelTransformed.func_177971_a((Vector3i)origin);
        AxisAlignedBB bb = PositionUtils.createEnclosingAABB(regionPosAbs, posEndAbs);
        return world.func_175674_a((Entity)null, bb, null);
    }

    public static boolean shouldPickBlock(PlayerEntity player) {
        return Configs.Generic.PICK_BLOCK_ENABLED.getBooleanValue() && (!Configs.Generic.TOOL_ITEM_ENABLED.getBooleanValue() || !EntityUtils.hasToolItem((LivingEntity)player)) && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue();
    }
}

