/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class AnimalAIHerdPanic
extends Goal {
    protected final CreatureEntity creature;
    protected final double speed;
    protected final Predicate<? super CreatureEntity> targetEntitySelector;
    protected double randPosX;
    protected double randPosY;
    protected double randPosZ;
    protected boolean running;

    public AnimalAIHerdPanic(final CreatureEntity creature, double speedIn) {
        this.creature = creature;
        this.speed = speedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.targetEntitySelector = new Predicate<CreatureEntity>(){

            public boolean apply(@Nullable CreatureEntity animal) {
                if (animal instanceof IHerdPanic && animal.func_200600_R() == creature.func_200600_R()) {
                    return ((IHerdPanic)animal).canPanic();
                }
                return false;
            }
        };
    }

    public boolean func_75250_a() {
        BlockPos blockpos;
        if (this.creature.func_70643_av() == null && !this.creature.func_70027_ad()) {
            return false;
        }
        if (this.creature.func_70027_ad() && (blockpos = this.getRandPos((IBlockReader)this.creature.field_70170_p, (Entity)this.creature, 5, 4)) != null) {
            this.randPosX = blockpos.func_177958_n();
            this.randPosY = blockpos.func_177956_o();
            this.randPosZ = blockpos.func_177952_p();
            return true;
        }
        if (this.creature.func_70643_av() != null && this.creature instanceof IHerdPanic && ((IHerdPanic)this.creature).canPanic()) {
            List list = this.creature.field_70170_p.func_175647_a(this.creature.getClass(), this.getTargetableArea(), this.targetEntitySelector);
            for (CreatureEntity creatureEntity : list) {
                creatureEntity.func_70604_c(this.creature.func_70643_av());
            }
            return this.findRandomPositionFrom(this.creature.func_70643_av());
        }
        return this.findRandomPosition();
    }

    private boolean findRandomPositionFrom(LivingEntity revengeTarget) {
        Vector3d vector3d = RandomPositionGenerator.func_75461_b((CreatureEntity)this.creature, (int)16, (int)7, (Vector3d)revengeTarget.func_213303_ch());
        if (vector3d == null) {
            return false;
        }
        this.randPosX = vector3d.field_72450_a;
        this.randPosY = vector3d.field_72448_b;
        this.randPosZ = vector3d.field_72449_c;
        return true;
    }

    protected AxisAlignedBB getTargetableArea() {
        Vector3d renderCenter = new Vector3d(this.creature.func_226277_ct_() + 0.5, this.creature.func_226278_cu_() + 0.5, this.creature.func_226281_cx_() + 0.5);
        double searchRadius = 15.0;
        AxisAlignedBB aabb = new AxisAlignedBB(-searchRadius, -searchRadius, -searchRadius, searchRadius, searchRadius, searchRadius);
        return aabb.func_191194_a(renderCenter);
    }

    protected boolean findRandomPosition() {
        Vector3d vector3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.creature, (int)5, (int)4);
        if (vector3d == null) {
            return false;
        }
        this.randPosX = vector3d.field_72450_a;
        this.randPosY = vector3d.field_72448_b;
        this.randPosZ = vector3d.field_72449_c;
        return true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void func_75249_e() {
        if (this.creature instanceof IHerdPanic) {
            ((IHerdPanic)this.creature).onPanic();
        }
        this.creature.func_70661_as().func_75492_a(this.randPosX, this.randPosY, this.randPosZ, this.speed);
        this.running = true;
    }

    public void func_75251_c() {
        this.running = false;
    }

    public boolean func_75253_b() {
        return !this.creature.func_70661_as().func_75500_f();
    }

    @Nullable
    protected BlockPos getRandPos(IBlockReader worldIn, Entity entityIn, int horizontalRange, int verticalRange) {
        BlockPos blockpos = entityIn.func_233580_cy_();
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177956_o();
        int k = blockpos.func_177952_p();
        float f = horizontalRange * horizontalRange * verticalRange * 2;
        BlockPos blockpos1 = null;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l = i - horizontalRange; l <= i + horizontalRange; ++l) {
            for (int i1 = j - verticalRange; i1 <= j + verticalRange; ++i1) {
                for (int j1 = k - horizontalRange; j1 <= k + horizontalRange; ++j1) {
                    float f1;
                    blockpos$mutable.func_181079_c(l, i1, j1);
                    if (!worldIn.func_204610_c((BlockPos)blockpos$mutable).func_206884_a((ITag)FluidTags.field_206959_a) || !((f1 = (float)((l - i) * (l - i) + (i1 - j) * (i1 - j) + (j1 - k) * (j1 - k))) < f)) continue;
                    f = f1;
                    blockpos1 = new BlockPos((Vector3i)blockpos$mutable);
                }
            }
        }
        return blockpos1;
    }
}

