/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.EntitySeagull;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;

public class SeagullAIStealFromPlayers
extends Goal {
    private EntitySeagull seagull;
    private Vector3d fleeVec = null;
    private PlayerEntity target;
    private int fleeTime = 0;

    public SeagullAIStealFromPlayers(EntitySeagull entitySeagull) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        this.seagull = entitySeagull;
    }

    public boolean func_75250_a() {
        PlayerEntity valid;
        long worldTime = this.seagull.field_70170_p.func_82737_E() % 10L;
        if (this.seagull.func_70654_ax() >= 100 && worldTime != 0L || this.seagull.isSitting() || !AMConfig.seagullStealing) {
            return false;
        }
        if (this.seagull.func_70681_au().nextInt(12) != 0 && worldTime != 0L || this.seagull.stealCooldown > 0) {
            return false;
        }
        if (this.seagull.func_184614_ca().func_190926_b() && (valid = this.getClosestValidPlayer()) != null) {
            this.target = valid;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.seagull.aiItemFlag = true;
    }

    public void func_75251_c() {
        this.seagull.aiItemFlag = false;
        this.target = null;
        this.fleeVec = null;
        this.fleeTime = 0;
    }

    public boolean func_75253_b() {
        return this.target != null && !this.target.func_184812_l_() && (this.seagull.func_184614_ca().func_190926_b() || this.fleeTime > 0);
    }

    public void func_75246_d() {
        this.seagull.setFlying(true);
        this.seagull.func_70605_aq().func_75642_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_(), (double)1.2f);
        if (this.seagull.func_70032_d((Entity)this.target) < 2.0f && this.seagull.func_184614_ca().func_190926_b()) {
            if (this.hasFoods(this.target)) {
                ItemStack foodStack = this.getFoodItemFrom(this.target);
                if (!foodStack.func_190926_b()) {
                    ItemStack copy = foodStack.func_77946_l();
                    foodStack.func_190918_g(1);
                    copy.func_190920_e(1);
                    this.seagull.peck();
                    this.seagull.func_184611_a(Hand.MAIN_HAND, copy);
                    this.fleeTime = 60;
                    this.seagull.stealCooldown = 1500 + this.seagull.func_70681_au().nextInt(1500);
                    if (this.target instanceof ServerPlayerEntity) {
                        AMAdvancementTriggerRegistry.SEAGULL_STEAL.trigger((ServerPlayerEntity)this.target);
                    }
                } else {
                    this.func_75251_c();
                }
            } else {
                this.func_75251_c();
            }
        }
        if (this.fleeTime > 0) {
            if (this.fleeVec == null) {
                this.fleeVec = this.seagull.getBlockInViewAway(this.target.func_213303_ch(), 4.0f);
            }
            if (this.fleeVec != null) {
                this.seagull.setFlying(true);
                this.seagull.func_70605_aq().func_75642_a(this.fleeVec.field_72450_a, this.fleeVec.field_72448_b, this.fleeVec.field_72449_c, (double)1.2f);
                if (this.seagull.func_195048_a(this.fleeVec) < 5.0) {
                    this.fleeVec = this.seagull.getBlockInViewAway(this.fleeVec, 4.0f);
                }
            }
            --this.fleeTime;
        }
    }

    private PlayerEntity getClosestValidPlayer() {
        List list = this.seagull.field_70170_p.func_175647_a(PlayerEntity.class, this.seagull.func_174813_aQ().func_72314_b(10.0, 25.0, 10.0), EntityPredicates.field_188444_d);
        PlayerEntity closest = null;
        if (!list.isEmpty()) {
            for (PlayerEntity player : list) {
                if (closest != null && !(closest.func_70032_d((Entity)this.seagull) > player.func_70032_d((Entity)this.seagull)) || !this.hasFoods(player)) continue;
                closest = player;
            }
        }
        return closest;
    }

    private boolean hasFoods(PlayerEntity player) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stackIn = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (!stackIn.func_222117_E() || this.isBlacklisted(stackIn)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlacklisted(ItemStack stack) {
        for (String string : AMConfig.seagullStealingBlacklist) {
            if (!stack.func_77973_b().getRegistryName().toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    private ItemStack getFoodItemFrom(PlayerEntity player) {
        ArrayList<ItemStack> foods = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack stackIn = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (!stackIn.func_222117_E() || this.isBlacklisted(stackIn)) continue;
            foods.add(stackIn);
        }
        if (!foods.isEmpty()) {
            return (ItemStack)foods.get(foods.size() <= 1 ? 0 : this.seagull.func_70681_au().nextInt(foods.size() - 1));
        }
        return ItemStack.field_190927_a;
    }
}

