/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.items.ItemRepairTool;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public abstract class EntityCarDamageBase
extends EntityCarBatteryBase {
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityCarDamageBase.class, (IDataSerializer)DataSerializers.field_187193_c);
    private long lastDamage;

    public EntityCarDamageBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_180799_ab()) {
            this.addDamage(1.0f);
        }
        if (this.isStarted() || this.getDamage() > 99.0f) {
            this.particles();
        }
    }

    public void particles() {
        int amount;
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getDamage() < 50.0f) {
            return;
        }
        int damage = (int)this.getDamage();
        if (damage < 70) {
            if (this.field_70146_Z.nextInt(10) != 0) {
                return;
            }
            amount = 1;
        } else if (damage < 80) {
            if (this.field_70146_Z.nextInt(5) != 0) {
                return;
            }
            amount = 1;
        } else {
            amount = damage < 90 ? 2 : 3;
        }
        for (int i = 0; i < amount; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * this.getCarWidth(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * this.getCarHeight(), this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * this.getCarWidth(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onCollision(float speed) {
        super.onCollision(speed);
        float percSpeed = speed / this.getMaxSpeed();
        if (percSpeed > 0.8f) {
            this.addDamage(percSpeed * 5.0f);
            this.playCrashSound();
            if (percSpeed > 0.9f) {
                this.setStarted(false);
                this.playStopSound();
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_190530_aW()) {
            return false;
        }
        if (this.field_70170_p.field_72995_K || !this.func_70089_S()) {
            return false;
        }
        if (!(source.func_76364_f() instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)source.func_76364_f();
        if (player == null) {
            return false;
        }
        if (player.equals((Object)this.getDriver())) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemRepairTool) {
            long time = player.field_70170_p.func_82737_E();
            if (time - this.lastDamage < 10L) {
                this.destroyCar(player, true);
                stack.func_222118_a(50, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(Hand.MAIN_HAND));
            } else {
                this.lastDamage = time;
            }
            return true;
        }
        return false;
    }

    public void addDamage(float val) {
        this.setDamage(this.getDamage() + val);
    }

    @Override
    public boolean canStartCarEngine(PlayerEntity player) {
        boolean b = true;
        if (this.getDamage() >= 100.0f) {
            return false;
        }
        return super.canStartCarEngine(player) && b;
    }

    @Override
    public int getTimeToStart() {
        int value = super.getTimeToStart();
        if (this.getDamage() >= 95.0f) {
            value += this.field_70146_Z.nextInt(25) + 50;
        } else if (this.getDamage() >= 90.0f) {
            value += this.field_70146_Z.nextInt(15) + 30;
        } else if (this.getDamage() >= 80.0f) {
            value += this.field_70146_Z.nextInt(15) + 10;
        } else if (this.getDamage() >= 50.0f) {
            value += this.field_70146_Z.nextInt(10) + 5;
        }
        return value;
    }

    @Override
    public boolean canEngineStayOn() {
        if (this.func_70090_H()) {
            this.addDamage(25.0f);
            return false;
        }
        if (this.func_180799_ab()) {
            return false;
        }
        if (this.getDamage() >= 100.0f) {
            return false;
        }
        return super.canEngineStayOn();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void setDamage(float damage) {
        if (damage > 100.0f) {
            damage = 100.0f;
        } else if (damage < 0.0f) {
            damage = 0.0f;
        }
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("damage", this.getDamage());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setDamage(compound.func_74760_g("damage"));
    }
}

