/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mrcrayfish.guns.client.KeyBinds;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.event.GunReloadEvent;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageReload;
import com.mrcrayfish.guns.network.message.MessageUnload;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReloadHandler {
    private static ReloadHandler instance;
    private int startReloadTick;
    private int reloadTimer;
    private int prevReloadTimer;
    private int reloadingSlot;

    public static ReloadHandler get() {
        if (instance == null) {
            instance = new ReloadHandler();
        }
        return instance;
    }

    private ReloadHandler() {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.prevReloadTimer = this.reloadTimer;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            if (((Boolean)SyncedPlayerData.instance().get((PlayerEntity)player, ModSyncedDataKeys.RELOADING)).booleanValue() && this.reloadingSlot != player.field_71071_by.field_70461_c) {
                this.setReloading(false);
            }
            this.updateReloadTimer((PlayerEntity)player);
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (KeyBinds.KEY_RELOAD.func_151470_d() && event.getAction() == 1) {
            if (!((Boolean)SyncedPlayerData.instance().get((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModSyncedDataKeys.RELOADING)).booleanValue()) {
                this.setReloading(true);
            } else {
                this.setReloading(false);
            }
        }
        if (KeyBinds.KEY_UNLOAD.func_151468_f() && event.getAction() == 1) {
            this.setReloading(false);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageUnload());
        }
    }

    public void setReloading(boolean reloading) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            if (reloading) {
                CompoundNBT tag;
                ItemStack stack = player.func_184614_ca();
                if (stack.func_77973_b() instanceof GunItem && (tag = stack.func_77978_p()) != null && !tag.func_150297_b("IgnoreAmmo", 1)) {
                    Gun gun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack);
                    if (tag.func_74762_e("AmmoCount") >= GunEnchantmentHelper.getAmmoCapacity(stack, gun)) {
                        return;
                    }
                    if (Gun.findAmmo((PlayerEntity)player, gun.getProjectile().getItem()).func_190926_b()) {
                        return;
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((PlayerEntity)player, stack))) {
                        return;
                    }
                    SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.RELOADING, (Object)true);
                    PacketHandler.getPlayChannel().sendToServer((Object)new MessageReload(true));
                    this.reloadingSlot = player.field_71071_by.field_70461_c;
                    MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((PlayerEntity)player, stack));
                }
            } else {
                SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.RELOADING, (Object)false);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageReload(false));
                this.reloadingSlot = -1;
            }
        }
    }

    private void updateReloadTimer(PlayerEntity player) {
        if (((Boolean)SyncedPlayerData.instance().get(player, ModSyncedDataKeys.RELOADING)).booleanValue()) {
            if (this.startReloadTick == -1) {
                this.startReloadTick = player.field_70173_aa + 5;
            }
            if (this.reloadTimer < 5) {
                ++this.reloadTimer;
            }
        } else {
            if (this.startReloadTick != -1) {
                this.startReloadTick = -1;
            }
            if (this.reloadTimer > 0) {
                --this.reloadTimer;
            }
        }
    }

    public int getStartReloadTick() {
        return this.startReloadTick;
    }

    public int getReloadTimer() {
        return this.reloadTimer;
    }

    public float getReloadProgress(float partialTicks) {
        return ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks) / 5.0f;
    }
}

