/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mrcrayfish.guns.crafting.WorkbenchIngredient;
import com.mrcrayfish.guns.crafting.WorkbenchRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WorkbenchRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<WorkbenchRecipe> {
    public WorkbenchRecipe read(ResourceLocation recipeId, JsonObject parent) {
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonArray input = JSONUtils.func_151214_t((JsonObject)parent, (String)"materials");
        for (int i = 0; i < input.size(); ++i) {
            JsonObject object = input.get(i).getAsJsonObject();
            builder.add((Object)WorkbenchIngredient.fromJson(object));
        }
        if (!parent.has("result")) {
            throw new JsonSyntaxException("Missing result item entry");
        }
        JsonObject resultObject = JSONUtils.func_152754_s((JsonObject)parent, (String)"result");
        ItemStack resultItem = ShapedRecipe.func_199798_a((JsonObject)resultObject);
        return new WorkbenchRecipe(recipeId, resultItem, (ImmutableList<WorkbenchIngredient>)builder.build());
    }

    @Nullable
    public WorkbenchRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        ItemStack result = buffer.func_150791_c();
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)((WorkbenchIngredient)Ingredient.func_199566_b((PacketBuffer)buffer)));
        }
        return new WorkbenchRecipe(recipeId, result, (ImmutableList<WorkbenchIngredient>)builder.build());
    }

    public void write(PacketBuffer buffer, WorkbenchRecipe recipe) {
        buffer.func_150788_a(recipe.getItem());
        buffer.func_150787_b(recipe.getMaterials().size());
        for (WorkbenchIngredient ingredient : recipe.getMaterials()) {
            ingredient.func_199564_a(buffer);
        }
    }
}

