/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.integration.chiselsandbits.create;

import com.jozufozu.flywheel.backend.gl.attrib.VertexFormat;
import com.jozufozu.flywheel.backend.gl.buffer.VecBuffer;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.util.BufferBuilderReader;
import com.jozufozu.flywheel.util.VirtualEmptyModelData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;

public class LightAwareBlockModel
implements IModel {
    private static final MatrixStack IDENTITY = new MatrixStack();
    private final BufferBuilderReader reader;

    public LightAwareBlockModel(IBakedModel model, BlockState referenceState) {
        this(model, referenceState, IDENTITY);
    }

    public LightAwareBlockModel(IBakedModel model, BlockState referenceState, MatrixStack ms) {
        this.reader = new BufferBuilderReader(this.getBufferBuilder(model, referenceState, ms));
    }

    public VertexFormat format() {
        return Formats.COLORED_LIT_MODEL;
    }

    public int vertexCount() {
        return this.reader.getVertexCount();
    }

    public void buffer(VecBuffer buffer) {
        for (int i = 0; i < this.vertexCount(); ++i) {
            buffer.putVec3(this.reader.getX(i), this.reader.getY(i), this.reader.getZ(i));
            buffer.putVec3(this.reader.getNX(i), this.reader.getNY(i), this.reader.getNZ(i));
            buffer.putVec2(this.reader.getU(i), this.reader.getV(i));
            buffer.putColor(this.reader.getR(i), this.reader.getG(i), this.reader.getB(i), this.reader.getA(i));
            int light = this.reader.getLight(i);
            byte block = (byte)(LightTexture.func_228450_a_((int)light) << 4);
            byte sky = (byte)(LightTexture.func_228454_b_((int)light) << 4);
            buffer.putVec2(block, sky);
        }
    }

    public BufferBuilder getBufferBuilder(IBakedModel model, BlockState referenceState, MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        BufferBuilder builder = new BufferBuilder(512);
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        blockRenderer.renderModel((IBlockDisplayReader)mc.field_71441_e, model, referenceState, BlockPos.field_177992_a.func_177981_b(255), ms, (IVertexBuilder)builder, true, mc.field_71441_e.field_73012_v, 42L, OverlayTexture.field_229196_a_, (IModelData)VirtualEmptyModelData.INSTANCE);
        builder.func_178977_d();
        return builder;
    }
}

