/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.chiseled.IChiseledBlockItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.modification.operation.IModificationOperation;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.legacy.LegacyLoadManager;
import mod.chiselsandbits.registrars.ModModificationOperation;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockItem
extends BlockItem
implements IChiseledBlockItem {
    public ChiseledBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    @NotNull
    public ActionResultType func_195942_a(@NotNull BlockItemUseContext context) {
        IMultiStateItemStack source = this.createItemStack(context.func_195996_i());
        IWorldAreaMutator areaMutator = context.func_195999_j().func_213453_ef() ? IMutatorFactory.getInstance().covering((IWorld)context.func_195991_k(), context.func_221532_j(), context.func_221532_j().func_72441_c(1.0, 1.0, 1.0)) : IMutatorFactory.getInstance().in((IWorld)context.func_195991_k(), context.func_195995_a());
        IMultiStateSnapshot attemptTarget = areaMutator.createSnapshot();
        boolean noCollisions = ((Stream)source.stream().sequential()).allMatch(stateEntryInfo -> {
            try {
                attemptTarget.setInAreaTarget(stateEntryInfo.getState(), stateEntryInfo.getStartPoint());
                return true;
            }
            catch (SpaceOccupiedException exception) {
                return false;
            }
        });
        if (noCollisions) {
            try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.func_195999_j()));){
                ((Stream)source.stream().sequential()).forEach(stateEntryInfo -> {
                    try {
                        areaMutator.setInAreaTarget(stateEntryInfo.getState(), stateEntryInfo.getStartPoint());
                    }
                    catch (SpaceOccupiedException spaceOccupiedException) {
                        // empty catch block
                    }
                });
            }
            if (context.func_195999_j() == null || !context.func_195999_j().field_71075_bZ.field_75098_d) {
                context.func_195996_i().func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Override
    @NotNull
    public IMultiStateItemStack createItemStack(ItemStack stack) {
        if (stack.func_196082_o().func_74764_b("BlockEntityTag")) {
            ChunkSection legacyLoadedChunkSection = LegacyLoadManager.getInstance().attemptLegacyBlockEntityLoad(stack.func_196082_o().func_74775_l("BlockEntityTag"));
            IMultiStateSnapshot snapshot = MultiStateSnapshotUtils.createFromSection(legacyLoadedChunkSection);
            IMultiStateItemStack multiStateItemStack = snapshot.toItemStack();
            ItemStack tempStack = multiStateItemStack.toBlockStack();
            stack.func_77982_d(tempStack.func_77978_p());
        }
        return new SingleBlockMultiStateItemStack(stack);
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Configuration.getInstance().getCommon().helpText(LocalStrings.HelpBitBag, tooltip, new Object[0]);
    }

    @Override
    public boolean canPlace(ItemStack heldStack, PlayerEntity playerEntity, BlockRayTraceResult blockRayTraceResult) {
        IMultiStateItemStack source = this.createItemStack(heldStack);
        Vector3d target = this.getTargetedBlockPos(heldStack, playerEntity, blockRayTraceResult);
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((IWorld)playerEntity.field_70170_p, target, target.func_72441_c(1.0, 1.0, 1.0));
        IMultiStateSnapshot attemptTarget = areaMutator.createSnapshot();
        boolean noCollision = source.stream().allMatch(stateEntryInfo -> {
            try {
                attemptTarget.setInAreaTarget(stateEntryInfo.getState(), stateEntryInfo.getStartPoint());
                return true;
            }
            catch (SpaceOccupiedException exception) {
                return false;
            }
        });
        return noCollision;
    }

    @Override
    @NotNull
    public IModificationOperation getMode(ItemStack stack) {
        return (IModificationOperation)ModModificationOperation.ROTATE_AROUND_X.get();
    }

    @Override
    public void setMode(ItemStack stack, IModificationOperation mode) {
        IMultiStateItemStack multiStateItemStack = this.createItemStack(stack);
        mode.apply(multiStateItemStack);
    }

    @Override
    @NotNull
    public Collection<IModificationOperation> getPossibleModes() {
        return ModModificationOperation.REGISTRY_SUPPLIER.get().getValues();
    }

    @Override
    public boolean requiresUpdateOnClosure() {
        return false;
    }
}

